/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.shiro.authz;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.WildcardPermission;

public class ActiveMQWildcardPermission
extends WildcardPermission {
    private final boolean caseSensitive;

    public ActiveMQWildcardPermission(String wildcardString) {
        this(wildcardString, true);
    }

    public ActiveMQWildcardPermission(String wildcardString, boolean caseSensitive) {
        super(wildcardString, caseSensitive);
        this.caseSensitive = caseSensitive;
    }

    public boolean implies(Permission p) {
        if (!(p instanceof WildcardPermission)) {
            return false;
        }
        WildcardPermission wp = (WildcardPermission)p;
        List<Set<String>> otherParts = this.getParts(wp);
        int i = 0;
        for (Set<String> otherPart : otherParts) {
            if (this.getParts().size() - 1 < i) {
                return true;
            }
            Set thisPart = (Set)this.getParts().get(i);
            for (String otherToken : otherPart) {
                if (!this.caseSensitive) {
                    otherToken = otherToken.toLowerCase();
                }
                boolean otherIsMatched = false;
                for (String token : thisPart) {
                    if (token.equals("*")) {
                        otherIsMatched = true;
                        break;
                    }
                    if (!this.matches(token, otherToken)) continue;
                    otherIsMatched = true;
                    break;
                }
                if (otherIsMatched) continue;
                return false;
            }
            ++i;
        }
        while (i < this.getParts().size()) {
            Set part = (Set)this.getParts().get(i);
            if (!part.contains("*")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean matches(String pattern, String value) {
        char ch;
        char[] patArr = pattern.toCharArray();
        char[] valArr = value.toCharArray();
        int patIndex = 0;
        int patEndIndex = patArr.length - 1;
        int valIndex = 0;
        int valEndIndex = valArr.length - 1;
        boolean patternContainsStar = false;
        for (char patternChar : patArr) {
            if (patternChar != '*') continue;
            patternContainsStar = true;
            break;
        }
        if (!patternContainsStar) {
            if (patEndIndex != valEndIndex) {
                return false;
            }
            for (int i = 0; i <= patEndIndex; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?' || ch2 == valArr[i]) continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIndex]) != '*' && valIndex <= valEndIndex) {
            if (ch != '?' && ch != valArr[valIndex]) {
                return false;
            }
            ++patIndex;
            ++valIndex;
        }
        if (valIndex > valEndIndex) {
            for (int i = patIndex; i <= patEndIndex; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patEndIndex]) != '*' && valIndex <= valEndIndex) {
            if (ch != '?' && ch != valArr[valEndIndex]) {
                return false;
            }
            --patEndIndex;
            --valEndIndex;
        }
        if (valIndex > valEndIndex) {
            for (int i = patIndex; i <= patEndIndex; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIndex != patEndIndex && valIndex <= valEndIndex) {
            int innerPatternIndex = -1;
            for (int i = patIndex + 1; i <= patEndIndex; ++i) {
                if (patArr[i] != '*') continue;
                innerPatternIndex = i;
                break;
            }
            if (innerPatternIndex == patIndex + 1) {
                ++patIndex;
                continue;
            }
            int innerPatternLength = innerPatternIndex - patIndex - 1;
            int innerValueLength = valEndIndex - valIndex + 1;
            int foundIndex = -1;
            block8: for (int i = 0; i <= innerValueLength - innerPatternLength; ++i) {
                for (int j = 0; j < innerPatternLength; ++j) {
                    ch = patArr[patIndex + j + 1];
                    if (ch != '?' && ch != valArr[valIndex + i + j]) continue block8;
                }
                foundIndex = valIndex + i;
                break;
            }
            if (foundIndex == -1) {
                return false;
            }
            patIndex = innerPatternIndex;
            valIndex = foundIndex + innerPatternLength;
        }
        for (int i = patIndex; i <= patEndIndex; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    protected List<Set<String>> getParts(WildcardPermission wp) {
        if (wp instanceof ActiveMQWildcardPermission) {
            return ((ActiveMQWildcardPermission)wp).getParts();
        }
        return this.getPartsByReflection(wp);
    }

    protected List<Set<String>> getPartsByReflection(WildcardPermission wp) {
        try {
            return this.doGetPartsByReflection(wp);
        }
        catch (Exception e) {
            String msg = "Unable to obtain WildcardPermission instance's 'parts' value.";
            throw new IllegalStateException(msg, e);
        }
    }

    protected List<Set<String>> doGetPartsByReflection(WildcardPermission wp) throws Exception {
        Method getParts = WildcardPermission.class.getDeclaredMethod("getParts", new Class[0]);
        getParts.setAccessible(true);
        return (List)getParts.invoke((Object)wp, new Object[0]);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Set part : this.getParts()) {
            if (buffer.length() > 0) {
                buffer.append(":");
            }
            boolean first = true;
            for (String token : part) {
                if (!first) {
                    buffer.append(",");
                }
                buffer.append(token);
                first = false;
            }
        }
        return buffer.toString();
    }
}

