/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.RouteConfigurationContainer;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceAware;

@Metadata(label="configuration")
@XmlRootElement(name="routeConfigurations")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RouteConfigurationsDefinition
extends OptionalIdentifiedDefinition<RouteConfigurationsDefinition>
implements RouteConfigurationContainer,
ResourceAware {
    @XmlTransient
    private CamelContext camelContext;
    @XmlTransient
    private Resource resource;
    @XmlElementRef
    private List<RouteConfigurationDefinition> routeConfigurations = new ArrayList<RouteConfigurationDefinition>();

    public String getShortName() {
        return "routeConfigurations";
    }

    public String getLabel() {
        return "RouteConfigurations " + this.getId();
    }

    public String toString() {
        return "RouteConfigurations";
    }

    @Override
    public List<RouteConfigurationDefinition> getRouteConfigurations() {
        return this.routeConfigurations;
    }

    @Override
    public void setRouteConfigurations(List<RouteConfigurationDefinition> routeConfigurations) {
        this.routeConfigurations = routeConfigurations;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public RouteConfigurationDefinition routeConfiguration() {
        RouteConfigurationDefinition config = this.createRouteConfiguration(null);
        this.getRouteConfigurations().add(config);
        return config;
    }

    public RouteConfigurationDefinition routeConfiguration(String id) {
        RouteConfigurationDefinition config = this.createRouteConfiguration(id);
        this.getRouteConfigurations().add(config);
        return config;
    }

    public RouteConfigurationDefinition routeConfiguration(RouteConfigurationDefinition config) {
        this.getRouteConfigurations().add(config);
        return config;
    }

    protected RouteConfigurationDefinition createRouteConfiguration(String id) {
        RouteConfigurationDefinition config = new RouteConfigurationDefinition();
        if (id != null) {
            config.setId(id);
        }
        if (this.resource != null) {
            config.setResource(this.resource);
        }
        CamelContextAware.trySetCamelContext((Object)config, (CamelContext)this.camelContext);
        return config;
    }
}

