/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.source.util;

import org.openjdk.source.tree.AnnotatedTypeTree;
import org.openjdk.source.tree.AnnotationTree;
import org.openjdk.source.tree.ArrayAccessTree;
import org.openjdk.source.tree.ArrayTypeTree;
import org.openjdk.source.tree.AssertTree;
import org.openjdk.source.tree.AssignmentTree;
import org.openjdk.source.tree.BinaryTree;
import org.openjdk.source.tree.BlockTree;
import org.openjdk.source.tree.BreakTree;
import org.openjdk.source.tree.CaseTree;
import org.openjdk.source.tree.CatchTree;
import org.openjdk.source.tree.ClassTree;
import org.openjdk.source.tree.CompilationUnitTree;
import org.openjdk.source.tree.CompoundAssignmentTree;
import org.openjdk.source.tree.ConditionalExpressionTree;
import org.openjdk.source.tree.ContinueTree;
import org.openjdk.source.tree.DoWhileLoopTree;
import org.openjdk.source.tree.EmptyStatementTree;
import org.openjdk.source.tree.EnhancedForLoopTree;
import org.openjdk.source.tree.ErroneousTree;
import org.openjdk.source.tree.ExportsTree;
import org.openjdk.source.tree.ExpressionStatementTree;
import org.openjdk.source.tree.ForLoopTree;
import org.openjdk.source.tree.IdentifierTree;
import org.openjdk.source.tree.IfTree;
import org.openjdk.source.tree.ImportTree;
import org.openjdk.source.tree.InstanceOfTree;
import org.openjdk.source.tree.IntersectionTypeTree;
import org.openjdk.source.tree.LabeledStatementTree;
import org.openjdk.source.tree.LambdaExpressionTree;
import org.openjdk.source.tree.LiteralTree;
import org.openjdk.source.tree.MemberReferenceTree;
import org.openjdk.source.tree.MemberSelectTree;
import org.openjdk.source.tree.MethodInvocationTree;
import org.openjdk.source.tree.MethodTree;
import org.openjdk.source.tree.ModifiersTree;
import org.openjdk.source.tree.ModuleTree;
import org.openjdk.source.tree.NewArrayTree;
import org.openjdk.source.tree.NewClassTree;
import org.openjdk.source.tree.OpensTree;
import org.openjdk.source.tree.PackageTree;
import org.openjdk.source.tree.ParameterizedTypeTree;
import org.openjdk.source.tree.ParenthesizedTree;
import org.openjdk.source.tree.PrimitiveTypeTree;
import org.openjdk.source.tree.ProvidesTree;
import org.openjdk.source.tree.RequiresTree;
import org.openjdk.source.tree.ReturnTree;
import org.openjdk.source.tree.SwitchTree;
import org.openjdk.source.tree.SynchronizedTree;
import org.openjdk.source.tree.ThrowTree;
import org.openjdk.source.tree.Tree;
import org.openjdk.source.tree.TreeVisitor;
import org.openjdk.source.tree.TryTree;
import org.openjdk.source.tree.TypeCastTree;
import org.openjdk.source.tree.TypeParameterTree;
import org.openjdk.source.tree.UnaryTree;
import org.openjdk.source.tree.UnionTypeTree;
import org.openjdk.source.tree.UsesTree;
import org.openjdk.source.tree.VariableTree;
import org.openjdk.source.tree.WhileLoopTree;
import org.openjdk.source.tree.WildcardTree;

public class TreeScanner<R, P>
implements TreeVisitor<R, P> {
    public R scan(Tree tree, P p) {
        return tree == null ? null : (R)tree.accept(this, p);
    }

    private R scanAndReduce(Tree tree, P p, R r) {
        return this.reduce(this.scan(tree, p), r);
    }

    public R scan(Iterable<? extends Tree> iterable, P p) {
        R r = null;
        if (iterable != null) {
            boolean bl = true;
            for (Tree tree : iterable) {
                r = (R)(bl ? this.scan(tree, p) : this.scanAndReduce(tree, p, r));
                bl = false;
            }
        }
        return r;
    }

    private R scanAndReduce(Iterable<? extends Tree> iterable, P p, R r) {
        return this.reduce(this.scan(iterable, p), r);
    }

    public R reduce(R r, R r2) {
        return r;
    }

    @Override
    public R visitCompilationUnit(CompilationUnitTree compilationUnitTree, P p) {
        R r = this.scan(compilationUnitTree.getPackage(), p);
        r = this.scanAndReduce(compilationUnitTree.getImports(), p, r);
        r = this.scanAndReduce(compilationUnitTree.getTypeDecls(), p, r);
        return r;
    }

    @Override
    public R visitPackage(PackageTree packageTree, P p) {
        R r = this.scan(packageTree.getAnnotations(), p);
        r = this.scanAndReduce(packageTree.getPackageName(), p, r);
        return r;
    }

    @Override
    public R visitImport(ImportTree importTree, P p) {
        return this.scan(importTree.getQualifiedIdentifier(), p);
    }

    @Override
    public R visitClass(ClassTree classTree, P p) {
        R r = this.scan(classTree.getModifiers(), p);
        r = this.scanAndReduce(classTree.getTypeParameters(), p, r);
        r = this.scanAndReduce(classTree.getExtendsClause(), p, r);
        r = this.scanAndReduce(classTree.getImplementsClause(), p, r);
        r = this.scanAndReduce(classTree.getMembers(), p, r);
        return r;
    }

    @Override
    public R visitMethod(MethodTree methodTree, P p) {
        R r = this.scan(methodTree.getModifiers(), p);
        r = this.scanAndReduce(methodTree.getReturnType(), p, r);
        r = this.scanAndReduce(methodTree.getTypeParameters(), p, r);
        r = this.scanAndReduce(methodTree.getParameters(), p, r);
        r = this.scanAndReduce(methodTree.getReceiverParameter(), p, r);
        r = this.scanAndReduce(methodTree.getThrows(), p, r);
        r = this.scanAndReduce(methodTree.getBody(), p, r);
        r = this.scanAndReduce(methodTree.getDefaultValue(), p, r);
        return r;
    }

    @Override
    public R visitVariable(VariableTree variableTree, P p) {
        R r = this.scan(variableTree.getModifiers(), p);
        r = this.scanAndReduce(variableTree.getType(), p, r);
        r = this.scanAndReduce(variableTree.getNameExpression(), p, r);
        r = this.scanAndReduce(variableTree.getInitializer(), p, r);
        return r;
    }

    @Override
    public R visitEmptyStatement(EmptyStatementTree emptyStatementTree, P p) {
        return null;
    }

    @Override
    public R visitBlock(BlockTree blockTree, P p) {
        return this.scan(blockTree.getStatements(), p);
    }

    @Override
    public R visitDoWhileLoop(DoWhileLoopTree doWhileLoopTree, P p) {
        R r = this.scan(doWhileLoopTree.getStatement(), p);
        r = this.scanAndReduce(doWhileLoopTree.getCondition(), p, r);
        return r;
    }

    @Override
    public R visitWhileLoop(WhileLoopTree whileLoopTree, P p) {
        R r = this.scan(whileLoopTree.getCondition(), p);
        r = this.scanAndReduce(whileLoopTree.getStatement(), p, r);
        return r;
    }

    @Override
    public R visitForLoop(ForLoopTree forLoopTree, P p) {
        R r = this.scan(forLoopTree.getInitializer(), p);
        r = this.scanAndReduce(forLoopTree.getCondition(), p, r);
        r = this.scanAndReduce(forLoopTree.getUpdate(), p, r);
        r = this.scanAndReduce(forLoopTree.getStatement(), p, r);
        return r;
    }

    @Override
    public R visitEnhancedForLoop(EnhancedForLoopTree enhancedForLoopTree, P p) {
        R r = this.scan(enhancedForLoopTree.getVariable(), p);
        r = this.scanAndReduce(enhancedForLoopTree.getExpression(), p, r);
        r = this.scanAndReduce(enhancedForLoopTree.getStatement(), p, r);
        return r;
    }

    @Override
    public R visitLabeledStatement(LabeledStatementTree labeledStatementTree, P p) {
        return this.scan(labeledStatementTree.getStatement(), p);
    }

    @Override
    public R visitSwitch(SwitchTree switchTree, P p) {
        R r = this.scan(switchTree.getExpression(), p);
        r = this.scanAndReduce(switchTree.getCases(), p, r);
        return r;
    }

    @Override
    public R visitCase(CaseTree caseTree, P p) {
        R r = this.scan(caseTree.getExpression(), p);
        r = this.scanAndReduce(caseTree.getStatements(), p, r);
        return r;
    }

    @Override
    public R visitSynchronized(SynchronizedTree synchronizedTree, P p) {
        R r = this.scan(synchronizedTree.getExpression(), p);
        r = this.scanAndReduce(synchronizedTree.getBlock(), p, r);
        return r;
    }

    @Override
    public R visitTry(TryTree tryTree, P p) {
        R r = this.scan(tryTree.getResources(), p);
        r = this.scanAndReduce(tryTree.getBlock(), p, r);
        r = this.scanAndReduce(tryTree.getCatches(), p, r);
        r = this.scanAndReduce(tryTree.getFinallyBlock(), p, r);
        return r;
    }

    @Override
    public R visitCatch(CatchTree catchTree, P p) {
        R r = this.scan(catchTree.getParameter(), p);
        r = this.scanAndReduce(catchTree.getBlock(), p, r);
        return r;
    }

    @Override
    public R visitConditionalExpression(ConditionalExpressionTree conditionalExpressionTree, P p) {
        R r = this.scan(conditionalExpressionTree.getCondition(), p);
        r = this.scanAndReduce(conditionalExpressionTree.getTrueExpression(), p, r);
        r = this.scanAndReduce(conditionalExpressionTree.getFalseExpression(), p, r);
        return r;
    }

    @Override
    public R visitIf(IfTree ifTree, P p) {
        R r = this.scan(ifTree.getCondition(), p);
        r = this.scanAndReduce(ifTree.getThenStatement(), p, r);
        r = this.scanAndReduce(ifTree.getElseStatement(), p, r);
        return r;
    }

    @Override
    public R visitExpressionStatement(ExpressionStatementTree expressionStatementTree, P p) {
        return this.scan(expressionStatementTree.getExpression(), p);
    }

    @Override
    public R visitBreak(BreakTree breakTree, P p) {
        return null;
    }

    @Override
    public R visitContinue(ContinueTree continueTree, P p) {
        return null;
    }

    @Override
    public R visitReturn(ReturnTree returnTree, P p) {
        return this.scan(returnTree.getExpression(), p);
    }

    @Override
    public R visitThrow(ThrowTree throwTree, P p) {
        return this.scan(throwTree.getExpression(), p);
    }

    @Override
    public R visitAssert(AssertTree assertTree, P p) {
        R r = this.scan(assertTree.getCondition(), p);
        r = this.scanAndReduce(assertTree.getDetail(), p, r);
        return r;
    }

    @Override
    public R visitMethodInvocation(MethodInvocationTree methodInvocationTree, P p) {
        R r = this.scan(methodInvocationTree.getTypeArguments(), p);
        r = this.scanAndReduce(methodInvocationTree.getMethodSelect(), p, r);
        r = this.scanAndReduce(methodInvocationTree.getArguments(), p, r);
        return r;
    }

    @Override
    public R visitNewClass(NewClassTree newClassTree, P p) {
        R r = this.scan(newClassTree.getEnclosingExpression(), p);
        r = this.scanAndReduce(newClassTree.getIdentifier(), p, r);
        r = this.scanAndReduce(newClassTree.getTypeArguments(), p, r);
        r = this.scanAndReduce(newClassTree.getArguments(), p, r);
        r = this.scanAndReduce(newClassTree.getClassBody(), p, r);
        return r;
    }

    @Override
    public R visitNewArray(NewArrayTree newArrayTree, P p) {
        R r = this.scan(newArrayTree.getType(), p);
        r = this.scanAndReduce(newArrayTree.getDimensions(), p, r);
        r = this.scanAndReduce(newArrayTree.getInitializers(), p, r);
        r = this.scanAndReduce(newArrayTree.getAnnotations(), p, r);
        for (Iterable iterable : newArrayTree.getDimAnnotations()) {
            r = this.scanAndReduce(iterable, p, r);
        }
        return r;
    }

    @Override
    public R visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree, P p) {
        R r = this.scan(lambdaExpressionTree.getParameters(), p);
        r = this.scanAndReduce(lambdaExpressionTree.getBody(), p, r);
        return r;
    }

    @Override
    public R visitParenthesized(ParenthesizedTree parenthesizedTree, P p) {
        return this.scan(parenthesizedTree.getExpression(), p);
    }

    @Override
    public R visitAssignment(AssignmentTree assignmentTree, P p) {
        R r = this.scan(assignmentTree.getVariable(), p);
        r = this.scanAndReduce(assignmentTree.getExpression(), p, r);
        return r;
    }

    @Override
    public R visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, P p) {
        R r = this.scan(compoundAssignmentTree.getVariable(), p);
        r = this.scanAndReduce(compoundAssignmentTree.getExpression(), p, r);
        return r;
    }

    @Override
    public R visitUnary(UnaryTree unaryTree, P p) {
        return this.scan(unaryTree.getExpression(), p);
    }

    @Override
    public R visitBinary(BinaryTree binaryTree, P p) {
        R r = this.scan(binaryTree.getLeftOperand(), p);
        r = this.scanAndReduce(binaryTree.getRightOperand(), p, r);
        return r;
    }

    @Override
    public R visitTypeCast(TypeCastTree typeCastTree, P p) {
        R r = this.scan(typeCastTree.getType(), p);
        r = this.scanAndReduce(typeCastTree.getExpression(), p, r);
        return r;
    }

    @Override
    public R visitInstanceOf(InstanceOfTree instanceOfTree, P p) {
        R r = this.scan(instanceOfTree.getExpression(), p);
        r = this.scanAndReduce(instanceOfTree.getType(), p, r);
        return r;
    }

    @Override
    public R visitArrayAccess(ArrayAccessTree arrayAccessTree, P p) {
        R r = this.scan(arrayAccessTree.getExpression(), p);
        r = this.scanAndReduce(arrayAccessTree.getIndex(), p, r);
        return r;
    }

    @Override
    public R visitMemberSelect(MemberSelectTree memberSelectTree, P p) {
        return this.scan(memberSelectTree.getExpression(), p);
    }

    @Override
    public R visitMemberReference(MemberReferenceTree memberReferenceTree, P p) {
        R r = this.scan(memberReferenceTree.getQualifierExpression(), p);
        r = this.scanAndReduce(memberReferenceTree.getTypeArguments(), p, r);
        return r;
    }

    @Override
    public R visitIdentifier(IdentifierTree identifierTree, P p) {
        return null;
    }

    @Override
    public R visitLiteral(LiteralTree literalTree, P p) {
        return null;
    }

    @Override
    public R visitPrimitiveType(PrimitiveTypeTree primitiveTypeTree, P p) {
        return null;
    }

    @Override
    public R visitArrayType(ArrayTypeTree arrayTypeTree, P p) {
        return this.scan(arrayTypeTree.getType(), p);
    }

    @Override
    public R visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, P p) {
        R r = this.scan(parameterizedTypeTree.getType(), p);
        r = this.scanAndReduce(parameterizedTypeTree.getTypeArguments(), p, r);
        return r;
    }

    @Override
    public R visitUnionType(UnionTypeTree unionTypeTree, P p) {
        return this.scan(unionTypeTree.getTypeAlternatives(), p);
    }

    @Override
    public R visitIntersectionType(IntersectionTypeTree intersectionTypeTree, P p) {
        return this.scan(intersectionTypeTree.getBounds(), p);
    }

    @Override
    public R visitTypeParameter(TypeParameterTree typeParameterTree, P p) {
        R r = this.scan(typeParameterTree.getAnnotations(), p);
        r = this.scanAndReduce(typeParameterTree.getBounds(), p, r);
        return r;
    }

    @Override
    public R visitWildcard(WildcardTree wildcardTree, P p) {
        return this.scan(wildcardTree.getBound(), p);
    }

    @Override
    public R visitModifiers(ModifiersTree modifiersTree, P p) {
        return this.scan(modifiersTree.getAnnotations(), p);
    }

    @Override
    public R visitAnnotation(AnnotationTree annotationTree, P p) {
        R r = this.scan(annotationTree.getAnnotationType(), p);
        r = this.scanAndReduce(annotationTree.getArguments(), p, r);
        return r;
    }

    @Override
    public R visitAnnotatedType(AnnotatedTypeTree annotatedTypeTree, P p) {
        R r = this.scan(annotatedTypeTree.getAnnotations(), p);
        r = this.scanAndReduce(annotatedTypeTree.getUnderlyingType(), p, r);
        return r;
    }

    @Override
    public R visitModule(ModuleTree moduleTree, P p) {
        R r = this.scan(moduleTree.getAnnotations(), p);
        r = this.scanAndReduce(moduleTree.getName(), p, r);
        r = this.scanAndReduce(moduleTree.getDirectives(), p, r);
        return r;
    }

    @Override
    public R visitExports(ExportsTree exportsTree, P p) {
        R r = this.scan(exportsTree.getPackageName(), p);
        r = this.scanAndReduce(exportsTree.getModuleNames(), p, r);
        return r;
    }

    @Override
    public R visitOpens(OpensTree opensTree, P p) {
        R r = this.scan(opensTree.getPackageName(), p);
        r = this.scanAndReduce(opensTree.getModuleNames(), p, r);
        return r;
    }

    @Override
    public R visitProvides(ProvidesTree providesTree, P p) {
        R r = this.scan(providesTree.getServiceName(), p);
        r = this.scanAndReduce(providesTree.getImplementationNames(), p, r);
        return r;
    }

    @Override
    public R visitRequires(RequiresTree requiresTree, P p) {
        return this.scan(requiresTree.getModuleName(), p);
    }

    @Override
    public R visitUses(UsesTree usesTree, P p) {
        return this.scan(usesTree.getServiceName(), p);
    }

    @Override
    public R visitOther(Tree tree, P p) {
        return null;
    }

    @Override
    public R visitErroneous(ErroneousTree erroneousTree, P p) {
        return null;
    }
}

