/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections4.set.AbstractSortedSetTest;
import org.apache.commons.collections4.set.UnmodifiableSortedSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableSortedSetTest<E>
extends AbstractSortedSetTest<E> {
    protected UnmodifiableSortedSet<E> set;
    protected ArrayList<E> array;

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public UnmodifiableSortedSet<E> makeFullCollection() {
        TreeSet set = new TreeSet(Arrays.asList(this.getFullElements()));
        return (UnmodifiableSortedSet)UnmodifiableSortedSet.unmodifiableSortedSet(set);
    }

    @Override
    public SortedSet<E> makeObject() {
        return UnmodifiableSortedSet.unmodifiableSortedSet(new TreeSet());
    }

    protected void setupSet() {
        this.set = this.makeFullCollection();
        this.array = new ArrayList();
        this.array.add(1);
    }

    @Test
    public void testComparator() {
        this.setupSet();
        Comparator c = this.set.comparator();
        Assertions.assertNull((Object)c, (String)"natural order, so comparator should be null");
    }

    @Test
    public void testDecorateFactory() {
        UnmodifiableSortedSet<E> set = this.makeFullCollection();
        Assertions.assertSame(set, (Object)UnmodifiableSortedSet.unmodifiableSortedSet(set));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableSortedSet.unmodifiableSortedSet(null));
    }

    @Test
    public void testUnmodifiable() {
        this.setupSet();
        this.verifyUnmodifiable((Set<E>)this.set);
        this.verifyUnmodifiable(this.set.headSet((Object)1));
        this.verifyUnmodifiable(this.set.tailSet((Object)1));
        this.verifyUnmodifiable(this.set.subSet((Object)1, (Object)3));
    }

    public void verifyUnmodifiable(Set<E> set) {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.add("value"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.addAll(new TreeSet()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.clear());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.remove("x"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.removeAll(this.array));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.retainAll(this.array));
    }
}

