/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.reloading;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.reloading.PeriodicReloadingTrigger;
import org.apache.commons.configuration2.reloading.ReloadingController;
import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;

public class TestPeriodicReloadingTrigger {
    private static final Object CTRL_PARAM = "Test controller parameter";
    private static final long PERIOD = 60L;
    private static final TimeUnit UNIT = TimeUnit.SECONDS;
    private ScheduledExecutorService executor;
    private ReloadingController controller;

    private static ScheduledFuture<Void> createFutureMock() {
        return (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
    }

    private PeriodicReloadingTrigger createTrigger() {
        return new PeriodicReloadingTrigger(this.controller, CTRL_PARAM, 60L, UNIT, this.executor);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.executor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        this.controller = (ReloadingController)Mockito.mock(ReloadingController.class);
    }

    @Test
    void testDefaultExecutor() {
        PeriodicReloadingTrigger trigger = new PeriodicReloadingTrigger(this.controller, CTRL_PARAM, 60L, UNIT);
        Assertions.assertNotNull((Object)trigger.getExecutorService());
    }

    @Test
    void testInitNoController() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PeriodicReloadingTrigger(null, CTRL_PARAM, 60L, UNIT));
    }

    @Test
    void testIsRunningAfterInit() {
        Assertions.assertFalse((boolean)this.createTrigger().isRunning());
    }

    @Test
    void testShutdown() {
        ScheduledFuture<Void> future = TestPeriodicReloadingTrigger.createFutureMock();
        this.whenScheduled().thenReturn(future);
        Mockito.when((Object)future.cancel(false)).thenReturn((Object)Boolean.TRUE);
        PeriodicReloadingTrigger trigger = this.createTrigger();
        trigger.start();
        trigger.shutdown();
        this.verifyScheduled();
        ((ScheduledFuture)Mockito.verify(future)).cancel(false);
        ((ScheduledExecutorService)Mockito.verify((Object)this.executor)).shutdown();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{future, this.controller, this.executor});
    }

    @Test
    void testShutdownNoExecutor() {
        this.createTrigger().shutdown(false);
    }

    @Test
    void testStart() {
        ScheduledFuture<Void> future = TestPeriodicReloadingTrigger.createFutureMock();
        MutableObject refTask = new MutableObject();
        this.whenScheduled().thenAnswer(invocation -> {
            refTask.setValue((Object)((Runnable)invocation.getArgument(0, Runnable.class)));
            return future;
        });
        Mockito.when((Object)this.controller.checkForReloading(CTRL_PARAM)).thenReturn((Object)Boolean.FALSE);
        PeriodicReloadingTrigger trigger = this.createTrigger();
        trigger.start();
        Assertions.assertTrue((boolean)trigger.isRunning());
        ((Runnable)refTask.getValue()).run();
        this.verifyScheduled();
        ((ReloadingController)Mockito.verify((Object)this.controller)).checkForReloading(CTRL_PARAM);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{future, this.controller, this.executor});
    }

    @Test
    void testStartTwice() {
        ScheduledFuture<Void> future = TestPeriodicReloadingTrigger.createFutureMock();
        this.whenScheduled().thenReturn(future);
        PeriodicReloadingTrigger trigger = this.createTrigger();
        trigger.start();
        trigger.start();
        this.verifyScheduled();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{future, this.controller, this.executor});
    }

    @Test
    void testStop() {
        ScheduledFuture<Void> future = TestPeriodicReloadingTrigger.createFutureMock();
        this.whenScheduled().thenReturn(future);
        Mockito.when((Object)future.cancel(false)).thenReturn((Object)Boolean.TRUE);
        PeriodicReloadingTrigger trigger = this.createTrigger();
        trigger.start();
        trigger.stop();
        Assertions.assertFalse((boolean)trigger.isRunning());
        this.verifyScheduled();
        ((ScheduledFuture)Mockito.verify(future)).cancel(false);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{future, this.controller, this.executor});
    }

    @Test
    void testStopNotRunning() {
        this.createTrigger().stop();
    }

    private void verifyScheduled() {
        ((ScheduledExecutorService)Mockito.verify((Object)this.executor)).scheduleAtFixedRate((Runnable)ArgumentMatchers.any(), ArgumentMatchers.eq((long)60L), ArgumentMatchers.eq((long)60L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)UNIT))));
    }

    private OngoingStubbing<ScheduledFuture<?>> whenScheduled() {
        return Mockito.when(this.executor.scheduleAtFixedRate((Runnable)ArgumentMatchers.any(), ArgumentMatchers.eq((long)60L), ArgumentMatchers.eq((long)60L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)UNIT)))));
    }
}

