/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.internal.Debug;

public class PngImageMetadata
implements ImageMetadata {
    private static final String NEWLINE = System.lineSeparator();
    private final ImageMetadata textualInformation;
    private final TiffImageMetadata exif;

    public PngImageMetadata(ImageMetadata textualInformation) {
        this(textualInformation, null);
    }

    public PngImageMetadata(ImageMetadata textualInformation, TiffImageMetadata exif) {
        this.textualInformation = Objects.requireNonNull(textualInformation);
        this.exif = exif;
    }

    public void dump() {
        Debug.debug(this.toString());
    }

    public TiffImageMetadata getExif() {
        return this.exif;
    }

    @Override
    public List<? extends ImageMetadata.ImageMetadataItem> getItems() {
        if (this.exif == null) {
            return this.textualInformation.getItems();
        }
        ArrayList<? extends ImageMetadata.ImageMetadataItem> result = new ArrayList<ImageMetadata.ImageMetadataItem>(this.textualInformation.getItems());
        result.addAll(this.exif.getItems());
        return result;
    }

    public ImageMetadata getTextualInformation() {
        return this.textualInformation;
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        StringBuilder result = new StringBuilder();
        result.append(prefix);
        result.append("Textual information:");
        result.append(NEWLINE);
        result.append(this.textualInformation.toString("\t"));
        if (this.exif != null) {
            result.append(NEWLINE);
            result.append(prefix);
            result.append("Exif metadata:");
            result.append(NEWLINE);
            result.append(this.exif.toString("\t"));
        }
        return result.toString();
    }
}

