/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.AbstractTempDirTest;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.TempDirectory;
import org.apache.commons.io.file.TempFile;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.io.test.TestUtils;
import org.apache.commons.lang3.SystemProperties;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class FileUtilsTest
extends AbstractTempDirTest {
    private static final Path DIR_SIZE_1 = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]);
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final long DATE3 = 1000000002000L;
    private static final long DATE2 = 1000000001000L;
    private static final long DATE1 = 1000000000000L;
    private static final int TEST_DIRECTORY_SIZE = 0;
    private static final BigInteger TEST_DIRECTORY_SIZE_BI = BigInteger.ZERO;
    private static final BigInteger TEST_DIRECTORY_SIZE_GT_ZERO_BI = BigInteger.valueOf(100L);
    private static final ListDirectoryWalker LIST_WALKER = new ListDirectoryWalker();
    private File testFile1;
    private File testFile2;
    private long testFile1Size;
    private long testFile2Size;

    FileUtilsTest() {
    }

    private static void setDosReadOnly(Path p, boolean readOnly) throws IOException {
        if (Files.getFileStore(p).supportsFileAttributeView(DosFileAttributeView.class)) {
            Files.setAttribute(p, "dos:readonly", readOnly, LinkOption.NOFOLLOW_LINKS);
        }
    }

    private void assertContentMatchesAfterCopyURLToFileFor(String resourceName, File destination) throws IOException {
        FileUtils.copyURLToFile((URL)this.getClass().getResource(resourceName), (File)destination);
        try (InputStream fis = Files.newInputStream(destination.toPath(), new OpenOption[0]);
             InputStream expected = this.getClass().getResourceAsStream(resourceName);){
            Assertions.assertTrue((boolean)IOUtils.contentEquals((InputStream)expected, (InputStream)fis), (String)"Content is not equal.");
        }
    }

    private void backDateFile10Minutes(File testFile) throws IOException {
        long mins10 = 600000L;
        long lastModified1 = this.getLastModifiedMillis(testFile);
        Assertions.assertTrue((boolean)this.setLastModifiedMillis(testFile, lastModified1 - 600000L));
        Assertions.assertNotEquals((long)this.getLastModifiedMillis(testFile), (long)lastModified1, (String)"Should have changed source date");
    }

    private void consumeRemaining(Iterator<File> iterator) {
        if (iterator != null) {
            iterator.forEachRemaining(e -> {});
        }
    }

    private Path createCircularOsSymbolicLink(String linkName, String targetName) throws IOException {
        return Files.createSymbolicLink(Paths.get(linkName, new String[0]), Paths.get(targetName, new String[0]), new FileAttribute[0]);
    }

    private void createCircularSymbolicLink(File file) throws IOException {
        Assertions.assertTrue((boolean)file.exists());
        String linkName = file + "/cycle";
        String targetName = file + "/..";
        Assertions.assertTrue((boolean)file.exists());
        Path linkPath = Paths.get(linkName, new String[0]);
        Assertions.assertFalse((boolean)Files.exists(linkPath, new LinkOption[0]));
        Path targetPath = Paths.get(targetName, new String[0]);
        Assertions.assertTrue((boolean)Files.exists(targetPath, new LinkOption[0]));
        try {
            Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
        }
        catch (UnsupportedOperationException e) {
            this.createCircularOsSymbolicLink(linkName, targetName);
        }
        Assertions.assertTrue((boolean)Files.isSymbolicLink(linkPath), () -> "Expected a symbolic link here: " + linkName);
    }

    private void createFilesForTestCopyDirectory(File grandParentDir, File parentDir, File childDir) throws IOException {
        File childDir2 = new File(parentDir, "child2");
        File grandChildDir = new File(childDir, "grandChild");
        File grandChild2Dir = new File(childDir2, "grandChild2");
        File file1 = new File(grandParentDir, "file1.txt");
        File file2 = new File(parentDir, "file2.txt");
        File file3 = new File(childDir, "file3.txt");
        File file4 = new File(childDir2, "file4.txt");
        File file5 = new File(grandChildDir, "file5.txt");
        File file6 = new File(grandChild2Dir, "file6.txt");
        FileUtils.deleteDirectory((File)grandParentDir);
        grandChildDir.mkdirs();
        grandChild2Dir.mkdirs();
        FileUtils.writeStringToFile((File)file1, (String)"File 1 in grandparent", (String)"UTF8");
        FileUtils.writeStringToFile((File)file2, (String)"File 2 in parent", (String)"UTF8");
        FileUtils.writeStringToFile((File)file3, (String)"File 3 in child", (String)"UTF8");
        FileUtils.writeStringToFile((File)file4, (String)"File 4 in child2", (String)"UTF8");
        FileUtils.writeStringToFile((File)file5, (String)"File 5 in grandChild", (String)"UTF8");
        FileUtils.writeStringToFile((File)file6, (String)"File 6 in grandChild2", (String)"UTF8");
    }

    private ImmutablePair<Path, Path> createTempSymbolicLinkedRelativeDir() throws IOException {
        Path targetDir = this.tempDirPath.resolve("subdir");
        Path symLinkedDir = this.tempDirPath.resolve("symlinked-dir");
        Files.createDirectory(targetDir, new FileAttribute[0]);
        Files.createSymbolicLink(symLinkedDir, targetDir, new FileAttribute[0]);
        return ImmutablePair.of((Object)symLinkedDir, (Object)targetDir);
    }

    private Set<String> getFilePathSet(List<File> files) {
        return files.stream().map(f -> {
            try {
                return f.getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toSet());
    }

    private long getLastModifiedMillis(File file) throws IOException {
        return FileUtils.lastModified((File)file);
    }

    private String getName() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateFilesAndDirs(File dir, IOFileFilter fileFilter, IOFileFilter dirFilter, Collection<File> expectedFilesAndDirs) {
        Iterator iterator = FileUtils.iterateFilesAndDirs((File)dir, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        int filesCount = 0;
        try {
            ArrayList<File> actualFiles = new ArrayList<File>();
            while (iterator.hasNext()) {
                ++filesCount;
                File file = (File)iterator.next();
                actualFiles.add(file);
                Assertions.assertTrue((boolean)expectedFilesAndDirs.contains(file), () -> "Unexpected directory/file " + file + ", expected one of " + expectedFilesAndDirs);
            }
            Assertions.assertEquals((int)expectedFilesAndDirs.size(), (int)filesCount, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(actualFiles));
        }
        finally {
            this.consumeRemaining(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openOutputStream_noParent(boolean createFile) throws Exception {
        File file = new File("test.txt");
        Assertions.assertNull((Object)file.getParentFile());
        try {
            if (createFile) {
                TestUtils.createLineFileUtf8(file, new String[]{"Hello"});
            }
            try (FileOutputStream out = FileUtils.openOutputStream((File)file);){
                out.write(0);
            }
            Assertions.assertTrue((boolean)file.exists());
        }
        finally {
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    private boolean setLastModifiedMillis(File testFile, long millis) {
        return testFile.setLastModified(millis);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.testFile1 = new File(this.tempDirFile, "file1-test.txt");
        this.testFile2 = new File(this.tempDirFile, "file1a-test.txt");
        this.testFile1Size = this.testFile1.length();
        this.testFile2Size = this.testFile2.length();
        if (!this.testFile1.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile1 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output3 = new BufferedOutputStream(Files.newOutputStream(this.testFile1.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output3, this.testFile1Size);
        }
        if (!this.testFile2.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile2 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output2 = new BufferedOutputStream(Files.newOutputStream(this.testFile2.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output2, this.testFile2Size);
        }
        FileUtils.deleteDirectory((File)this.tempDirFile);
        this.tempDirFile.mkdirs();
        if (!this.testFile1.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile1 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(this.testFile1.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, this.testFile1Size);
        }
        if (!this.testFile2.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile2 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.testFile2.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, this.testFile2Size);
        }
    }

    @Test
    void testByteCountToDisplaySizeBigInteger() {
        BigInteger b1023 = BigInteger.valueOf(1023L);
        BigInteger b1025 = BigInteger.valueOf(1025L);
        BigInteger KB1 = BigInteger.valueOf(1024L);
        BigInteger MB1 = KB1.multiply(KB1);
        BigInteger GB1 = MB1.multiply(KB1);
        BigInteger GB2 = GB1.add(GB1);
        BigInteger TB1 = GB1.multiply(KB1);
        BigInteger PB1 = TB1.multiply(KB1);
        BigInteger EB1 = PB1.multiply(KB1);
        BigInteger ZB1 = EB1.multiply(KB1);
        BigInteger YB1 = ZB1.multiply(KB1);
        BigInteger RB1 = YB1.multiply(KB1);
        BigInteger QB1 = RB1.multiply(KB1);
        Assertions.assertEquals((Object)"0 bytes", (Object)FileUtils.byteCountToDisplaySize((BigInteger)BigInteger.ZERO));
        Assertions.assertEquals((Object)"1 bytes", (Object)FileUtils.byteCountToDisplaySize((BigInteger)BigInteger.ONE));
        Assertions.assertEquals((Object)"1023 bytes", (Object)FileUtils.byteCountToDisplaySize((BigInteger)b1023));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)KB1));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)b1025));
        Assertions.assertEquals((Object)"1023 KB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)MB1.subtract(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)MB1));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)MB1.add(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1023 MB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)GB1.subtract(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)GB1));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)GB1.add(BigInteger.ONE)));
        Assertions.assertEquals((Object)"2 GB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)GB2));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)GB2.subtract(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1 TB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)TB1));
        Assertions.assertEquals((Object)"1 PB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)PB1));
        Assertions.assertEquals((Object)"1 EB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)EB1));
        Assertions.assertEquals((Object)"1 ZB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)ZB1));
        Assertions.assertEquals((Object)"1 YB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)YB1));
        Assertions.assertEquals((Object)"1 RB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)RB1));
        Assertions.assertEquals((Object)"1 QB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)QB1));
        Assertions.assertEquals((Object)"7 EB", (Object)FileUtils.byteCountToDisplaySize((long)Long.MAX_VALUE));
        Assertions.assertEquals((Object)"63 KB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)BigInteger.valueOf(65535L)));
        Assertions.assertEquals((Object)"31 KB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)BigInteger.valueOf(32767L)));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)BigInteger.valueOf(Integer.MAX_VALUE)));
    }

    @Test
    void testByteCountToDisplaySizeLong() {
        Assertions.assertEquals((Object)"0 bytes", (Object)FileUtils.byteCountToDisplaySize((long)0L));
        Assertions.assertEquals((Object)"1 bytes", (Object)FileUtils.byteCountToDisplaySize((long)1L));
        Assertions.assertEquals((Object)"1023 bytes", (Object)FileUtils.byteCountToDisplaySize((long)1023L));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize((long)1024L));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize((long)1025L));
        Assertions.assertEquals((Object)"1023 KB", (Object)FileUtils.byteCountToDisplaySize((long)1047552L));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize((long)0x100000L));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize((long)0x100400L));
        Assertions.assertEquals((Object)"1023 MB", (Object)FileUtils.byteCountToDisplaySize((long)0x3FF00000L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((long)0x40000000L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((long)0x40100000L));
        Assertions.assertEquals((Object)"2 GB", (Object)FileUtils.byteCountToDisplaySize((long)0x80000000L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((long)Integer.MAX_VALUE));
        Assertions.assertEquals((Object)"1 TB", (Object)FileUtils.byteCountToDisplaySize((long)0x10000000000L));
        Assertions.assertEquals((Object)"1 PB", (Object)FileUtils.byteCountToDisplaySize((long)0x4000000000000L));
        Assertions.assertEquals((Object)"1 EB", (Object)FileUtils.byteCountToDisplaySize((long)0x1000000000000000L));
        Assertions.assertEquals((Object)"7 EB", (Object)FileUtils.byteCountToDisplaySize((long)Long.MAX_VALUE));
        Assertions.assertEquals((Object)"1 EB", (Object)FileUtils.byteCountToDisplaySize((long)0x1000000000000000L));
        Assertions.assertEquals((Object)"1 EB", (Object)FileUtils.byteCountToDisplaySize((long)0x1000000000000001L));
        Assertions.assertEquals((Object)"1 EB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_EB_BI));
        Assertions.assertEquals((Object)"1 EB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_EB_BI.add(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((long)0x40000000L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((long)0x40000001L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_GB_BI));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_GB_BI.add(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize((long)1024L));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize((long)1025L));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_KB_BI));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_KB_BI.add(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize((long)0x100000L));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize((long)0x100001L));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_MB_BI));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_MB_BI.add(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1 PB", (Object)FileUtils.byteCountToDisplaySize((long)0x4000000000000L));
        Assertions.assertEquals((Object)"1 PB", (Object)FileUtils.byteCountToDisplaySize((long)0x4000000000001L));
        Assertions.assertEquals((Object)"1 PB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_PB_BI));
        Assertions.assertEquals((Object)"1 PB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_PB_BI.add(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1 TB", (Object)FileUtils.byteCountToDisplaySize((long)0x10000000000L));
        Assertions.assertEquals((Object)"1 TB", (Object)FileUtils.byteCountToDisplaySize((long)0x10000000001L));
        Assertions.assertEquals((Object)"1 TB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_TB_BI));
        Assertions.assertEquals((Object)"1 TB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_TB_BI.add(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1023 PB", (Object)FileUtils.byteCountToDisplaySize((long)0xFFFFFFFFFFFFFFFL));
        Assertions.assertEquals((Object)"1023 PB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_EB_BI.subtract(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1023 MB", (Object)FileUtils.byteCountToDisplaySize((long)0x3FFFFFFFL));
        Assertions.assertEquals((Object)"1023 MB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_GB_BI.subtract(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1023 bytes", (Object)FileUtils.byteCountToDisplaySize((long)1023L));
        Assertions.assertEquals((Object)"1023 bytes", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_KB_BI.subtract(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1023 KB", (Object)FileUtils.byteCountToDisplaySize((long)1048575L));
        Assertions.assertEquals((Object)"1023 KB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_MB_BI.subtract(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1023 TB", (Object)FileUtils.byteCountToDisplaySize((long)0x3FFFFFFFFFFFFL));
        Assertions.assertEquals((Object)"1023 TB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_PB_BI.subtract(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1023 GB", (Object)FileUtils.byteCountToDisplaySize((long)0xFFFFFFFFFFL));
        Assertions.assertEquals((Object)"1023 GB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)FileUtils.ONE_TB_BI.subtract(BigInteger.ONE)));
        Assertions.assertEquals((Object)"63 KB", (Object)FileUtils.byteCountToDisplaySize((long)65535L));
        Assertions.assertEquals((Object)"31 KB", (Object)FileUtils.byteCountToDisplaySize((long)32767L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((long)Integer.MAX_VALUE));
    }

    @Test
    void testByteCountToDisplaySizeNumber() {
        Assertions.assertEquals((Object)"0 bytes", (Object)FileUtils.byteCountToDisplaySize((Number)0));
        Assertions.assertEquals((Object)"1 bytes", (Object)FileUtils.byteCountToDisplaySize((Number)1));
        Assertions.assertEquals((Object)"1023 bytes", (Object)FileUtils.byteCountToDisplaySize((Number)1023));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize((Number)1024));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize((Number)1025));
        Assertions.assertEquals((Object)"1023 KB", (Object)FileUtils.byteCountToDisplaySize((Number)1047552L));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize((Number)0x100000L));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize((Number)0x100400L));
        Assertions.assertEquals((Object)"1023 MB", (Object)FileUtils.byteCountToDisplaySize((Number)0x3FF00000L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((Number)0x40000000L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((Number)0x40100000L));
        Assertions.assertEquals((Object)"2 GB", (Object)FileUtils.byteCountToDisplaySize((Number)0x80000000L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((Number)Integer.MAX_VALUE));
        Assertions.assertEquals((Object)"1 TB", (Object)FileUtils.byteCountToDisplaySize((Number)0x10000000000L));
        Assertions.assertEquals((Object)"1 PB", (Object)FileUtils.byteCountToDisplaySize((Number)0x4000000000000L));
        Assertions.assertEquals((Object)"1 EB", (Object)FileUtils.byteCountToDisplaySize((Number)0x1000000000000000L));
        Assertions.assertEquals((Object)"7 EB", (Object)FileUtils.byteCountToDisplaySize((Number)Long.MAX_VALUE));
        Assertions.assertEquals((Object)"63 KB", (Object)FileUtils.byteCountToDisplaySize((Number)65535));
        Assertions.assertEquals((Object)"31 KB", (Object)FileUtils.byteCountToDisplaySize((Number)Short.MAX_VALUE));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((Number)Integer.MAX_VALUE));
    }

    @Test
    void testChecksum() throws Exception {
        String text = "Imagination is more important than knowledge - Einstein";
        File file = new File(this.tempDirFile, "checksum-test.txt");
        FileUtils.writeStringToFile((File)file, (String)"Imagination is more important than knowledge - Einstein", (String)StandardCharsets.US_ASCII.name());
        CRC32 expectedChecksum = new CRC32();
        expectedChecksum.update("Imagination is more important than knowledge - Einstein".getBytes(StandardCharsets.US_ASCII), 0, "Imagination is more important than knowledge - Einstein".length());
        long expectedValue = expectedChecksum.getValue();
        CRC32 testChecksum = new CRC32();
        Checksum resultChecksum = FileUtils.checksum((File)file, (Checksum)testChecksum);
        long resultValue = resultChecksum.getValue();
        Assertions.assertSame((Object)testChecksum, (Object)resultChecksum);
        Assertions.assertEquals((long)expectedValue, (long)resultValue);
    }

    @Test
    void testChecksumCRC32() throws Exception {
        String text = "Imagination is more important than knowledge - Einstein";
        File file = new File(this.tempDirFile, "checksum-test.txt");
        FileUtils.writeStringToFile((File)file, (String)"Imagination is more important than knowledge - Einstein", (String)StandardCharsets.US_ASCII.name());
        CRC32 expectedChecksum = new CRC32();
        expectedChecksum.update("Imagination is more important than knowledge - Einstein".getBytes(StandardCharsets.US_ASCII), 0, "Imagination is more important than knowledge - Einstein".length());
        long expectedValue = expectedChecksum.getValue();
        long resultValue = FileUtils.checksumCRC32((File)file);
        Assertions.assertEquals((long)expectedValue, (long)resultValue);
    }

    @Test
    void testChecksumDouble() throws Exception {
        String text1 = "Imagination is more important than knowledge - Einstein";
        File file1 = new File(this.tempDirFile, "checksum-test.txt");
        FileUtils.writeStringToFile((File)file1, (String)"Imagination is more important than knowledge - Einstein", (String)StandardCharsets.US_ASCII.name());
        String text2 = "To be or not to be - Shakespeare";
        File file2 = new File(this.tempDirFile, "checksum-test2.txt");
        FileUtils.writeStringToFile((File)file2, (String)"To be or not to be - Shakespeare", (String)StandardCharsets.US_ASCII.name());
        CRC32 expectedChecksum = new CRC32();
        expectedChecksum.update("Imagination is more important than knowledge - Einstein".getBytes(StandardCharsets.US_ASCII), 0, "Imagination is more important than knowledge - Einstein".length());
        expectedChecksum.update("To be or not to be - Shakespeare".getBytes(StandardCharsets.US_ASCII), 0, "To be or not to be - Shakespeare".length());
        long expectedValue = expectedChecksum.getValue();
        CRC32 testChecksum = new CRC32();
        FileUtils.checksum((File)file1, (Checksum)testChecksum);
        FileUtils.checksum((File)file2, (Checksum)testChecksum);
        long resultValue = testChecksum.getValue();
        Assertions.assertEquals((long)expectedValue, (long)resultValue);
    }

    @Test
    void testChecksumOnDirectory() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.checksum((File)FileUtils.current(), (Checksum)new CRC32()));
    }

    @Test
    void testChecksumOnNullChecksum() throws Exception {
        String text = "Imagination is more important than knowledge - Einstein";
        File file = new File(this.tempDirFile, "checksum-test.txt");
        FileUtils.writeStringToFile((File)file, (String)"Imagination is more important than knowledge - Einstein", (String)StandardCharsets.US_ASCII.name());
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.checksum((File)file, null));
    }

    @Test
    void testChecksumOnNullFile() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.checksum(null, (Checksum)new CRC32()));
    }

    @Test
    void testCompareSizeOf() {
        File start = new File("src/test/java");
        long sizeLong1 = FileUtils.sizeOf((File)start);
        BigInteger sizeBig = FileUtils.sizeOfAsBigInteger((File)start);
        long sizeLong2 = FileUtils.sizeOf((File)start);
        Assertions.assertEquals((long)sizeLong1, (long)sizeLong2, (String)"Size should not change");
        Assertions.assertEquals((long)sizeLong1, (long)sizeBig.longValue(), (String)"longSize should equal BigSize");
    }

    @Test
    void testContentEquals() throws Exception {
        File file = new File(this.tempDirFile, this.getName());
        File file2 = new File(this.tempDirFile, this.getName() + "2");
        Assertions.assertTrue((boolean)FileUtils.contentEquals(null, null));
        Assertions.assertFalse((boolean)FileUtils.contentEquals(null, (File)file));
        Assertions.assertFalse((boolean)FileUtils.contentEquals((File)file, null));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)file, (File)file));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)file, (File)file2));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)file2, (File)file2));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)file2, (File)file));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.contentEquals((File)this.tempDirFile, (File)this.tempDirFile));
        File objFile1 = new File(this.tempDirFile, this.getName() + ".object");
        FileUtils.copyURLToFile((URL)this.getClass().getResource("/java/lang/Object.class"), (File)objFile1);
        File objFile1b = new File(this.tempDirFile, this.getName() + ".object2");
        FileUtils.copyURLToFile((URL)this.getClass().getResource("/java/lang/Object.class"), (File)objFile1b);
        File objFile2 = new File(this.tempDirFile, this.getName() + ".collection");
        FileUtils.copyURLToFile((URL)this.getClass().getResource("/java/util/Collection.class"), (File)objFile2);
        Assertions.assertFalse((boolean)FileUtils.contentEquals((File)objFile1, (File)objFile2));
        Assertions.assertFalse((boolean)FileUtils.contentEquals((File)objFile1b, (File)objFile2));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)objFile1, (File)objFile1b));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)objFile1, (File)objFile1));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)objFile1b, (File)objFile1b));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)objFile2, (File)objFile2));
        file.createNewFile();
        file2.createNewFile();
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)file, (File)file));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)file, (File)file2));
    }

    @Test
    void testContentEqualsIgnoreEOL() throws Exception {
        File file1 = new File(this.tempDirFile, this.getName());
        File file2 = new File(this.tempDirFile, this.getName() + "2");
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(null, null, null));
        Assertions.assertFalse((boolean)FileUtils.contentEqualsIgnoreEOL(null, (File)file1, null));
        Assertions.assertFalse((boolean)FileUtils.contentEqualsIgnoreEOL((File)file1, null, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file1, (File)file1, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file1, (File)file2, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file2, (File)file2, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file2, (File)file1, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.contentEqualsIgnoreEOL((File)this.tempDirFile, (File)this.tempDirFile, null));
        File tfile1 = new File(this.tempDirFile, this.getName() + ".txt1");
        FileUtils.write((File)tfile1, (CharSequence)"123\r");
        File tfile2 = new File(this.tempDirFile, this.getName() + ".txt2");
        FileUtils.write((File)tfile2, (CharSequence)"123\n");
        File tfile3 = new File(this.tempDirFile, this.getName() + ".collection");
        FileUtils.write((File)tfile3, (CharSequence)"123\r\n2");
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile1, (File)tfile1, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile2, (File)tfile2, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile3, (File)tfile3, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile1, (File)tfile2, null));
        Assertions.assertFalse((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile1, (File)tfile3, null));
        Assertions.assertFalse((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile2, (File)tfile3, null));
        URL urlCR = this.getClass().getResource("FileUtilsTestDataCR.bin");
        Assertions.assertNotNull((Object)urlCR);
        File cr = new File(urlCR.toURI());
        Assertions.assertTrue((boolean)cr.exists());
        URL urlCRLF = this.getClass().getResource("FileUtilsTestDataCRLF.bin");
        Assertions.assertNotNull((Object)urlCRLF);
        File crlf = new File(urlCRLF.toURI());
        Assertions.assertTrue((boolean)crlf.exists());
        URL urlLF = this.getClass().getResource("FileUtilsTestDataLF.bin");
        Assertions.assertNotNull((Object)urlLF);
        File lf = new File(urlLF.toURI());
        Assertions.assertTrue((boolean)lf.exists());
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)cr, (File)cr, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)crlf, (File)crlf, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)lf, (File)lf, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)cr, (File)crlf, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)cr, (File)lf, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)crlf, (File)lf, null));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)cr, (File)cr));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)crlf, (File)crlf));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)lf, (File)lf));
        Assertions.assertFalse((boolean)FileUtils.contentEquals((File)cr, (File)crlf));
        Assertions.assertFalse((boolean)FileUtils.contentEquals((File)cr, (File)lf));
        Assertions.assertFalse((boolean)FileUtils.contentEquals((File)crlf, (File)lf));
        file1.createNewFile();
        file2.createNewFile();
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file1, (File)file1, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file1, (File)file2, null));
    }

    @Test
    void testCopyDir_SymbolicLink() throws Exception {
        File realDirectory = new File(this.tempDirFile, "real_directory");
        realDirectory.mkdir();
        File content = new File(realDirectory, "hello.txt");
        FileUtils.writeStringToFile((File)content, (String)"HELLO WORLD", (String)"UTF8");
        Path linkPath = this.tempDirFile.toPath().resolve("link_to_directory");
        Files.createSymbolicLink(linkPath, realDirectory.toPath(), new FileAttribute[0]);
        File destination = new File(this.tempDirFile, "destination");
        FileUtils.copyDirectory((File)linkPath.toFile(), (File)destination);
        Assumptions.assumeTrue((boolean)content.delete());
        Assertions.assertFalse((boolean)Files.isSymbolicLink(destination.toPath()));
        File copied_content = new File(destination, "hello.txt");
        String actual = FileUtils.readFileToString((File)copied_content, (String)"UTF8");
        Assertions.assertEquals((Object)"HELLO WORLD", (Object)actual);
    }

    @Test
    void testCopyDir_SymbolicLinkCycle() throws Exception {
        File topDirectory = new File(this.tempDirFile, "topDirectory");
        topDirectory.mkdir();
        File content = new File(topDirectory, "hello.txt");
        FileUtils.writeStringToFile((File)content, (String)"HELLO WORLD", (String)"UTF8");
        File childDirectory = new File(topDirectory, "child_directory");
        childDirectory.mkdir();
        Path linkPath = childDirectory.toPath().resolve("link_to_top");
        Files.createSymbolicLink(linkPath, topDirectory.toPath(), new FileAttribute[0]);
        File destination = new File(this.tempDirFile, "destination");
        FileUtils.copyDirectory((File)linkPath.toFile(), (File)destination);
        Assumptions.assumeTrue((boolean)content.delete());
        Assertions.assertFalse((boolean)Files.isSymbolicLink(destination.toPath()));
        File copied_content = new File(destination, "hello.txt");
        String actual = FileUtils.readFileToString((File)copied_content, (String)"UTF8");
        Assertions.assertEquals((Object)"HELLO WORLD", (Object)actual);
        File[] copied = destination.listFiles();
        Assertions.assertEquals((int)2, (int)copied.length);
    }

    @Test
    void testCopyDirectory_brokenSymbolicLink() throws IOException {
        File sourceDirectory = new File(this.tempDirFile, "source_directory");
        sourceDirectory.mkdir();
        File targetFile = new File(sourceDirectory, "hello.txt");
        FileUtils.writeStringToFile((File)targetFile, (String)"HELLO WORLD", (String)"UTF8");
        Path targetPath = targetFile.toPath();
        Path linkPath = sourceDirectory.toPath().resolve("linkfile");
        Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
        Assumptions.assumeTrue((boolean)Files.isSymbolicLink(linkPath), () -> "Expected a symlink here: " + linkPath);
        Assumptions.assumeTrue((boolean)Files.exists(linkPath, new LinkOption[0]));
        Assumptions.assumeTrue((boolean)Files.exists(linkPath, LinkOption.NOFOLLOW_LINKS));
        Assumptions.assumeTrue((boolean)targetFile.delete());
        Assumptions.assumeFalse((boolean)Files.exists(linkPath, new LinkOption[0]));
        Assumptions.assumeTrue((boolean)Files.exists(linkPath, LinkOption.NOFOLLOW_LINKS));
        File destination = new File(this.tempDirFile, "destination");
        FileUtils.copyDirectory((File)sourceDirectory, (File)destination);
        Assertions.assertTrue((boolean)destination.exists());
        Path copiedBrokenSymlink = new File(destination, "linkfile").toPath();
        Assertions.assertTrue((boolean)Files.isSymbolicLink(copiedBrokenSymlink));
        Assertions.assertFalse((boolean)Files.exists(copiedBrokenSymlink, new LinkOption[0]));
    }

    @Test
    void testCopyDirectory_SymbolicLink() throws IOException {
        File sourceDirectory = new File(this.tempDirFile, "source_directory");
        sourceDirectory.mkdir();
        File targetFile = new File(sourceDirectory, "hello.txt");
        FileUtils.writeStringToFile((File)targetFile, (String)"HELLO WORLD", (String)"UTF8");
        Path targetPath = targetFile.toPath();
        Path linkPath = sourceDirectory.toPath().resolve("linkfile");
        Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
        Assumptions.assumeTrue((boolean)Files.isSymbolicLink(linkPath), () -> "Expected a symlink here: " + linkPath);
        Assumptions.assumeTrue((boolean)Files.exists(linkPath, new LinkOption[0]));
        Assumptions.assumeTrue((boolean)Files.exists(linkPath, LinkOption.NOFOLLOW_LINKS));
        File destination = new File(this.tempDirFile, "destination");
        FileUtils.copyDirectory((File)sourceDirectory, (File)destination);
        Assertions.assertTrue((boolean)destination.exists());
        Path copiedSymlink = new File(destination, "linkfile").toPath();
        Assertions.assertTrue((boolean)Files.isSymbolicLink(copiedSymlink));
        Assertions.assertTrue((boolean)Files.exists(copiedSymlink, new LinkOption[0]));
    }

    @Test
    void testCopyDirectory_SymbolicLinkExternalFile() throws Exception {
        File content = new File(this.tempDirFile, "hello.txt");
        FileUtils.writeStringToFile((File)content, (String)"HELLO WORLD", (String)"UTF8");
        File realDirectory = new File(this.tempDirFile, "real_directory");
        realDirectory.mkdir();
        Path linkPath = realDirectory.toPath().resolve("link_to_file");
        Files.createSymbolicLink(linkPath, content.toPath(), new FileAttribute[0]);
        File destination = new File(this.tempDirFile, "destination");
        FileUtils.copyDirectory((File)realDirectory, (File)destination);
        File copiedLink = new File(destination, "link_to_file");
        Assertions.assertTrue((boolean)Files.isSymbolicLink(copiedLink.toPath()));
        String actual = FileUtils.readFileToString((File)copiedLink, (String)"UTF8");
        Assertions.assertEquals((Object)"HELLO WORLD", (Object)actual);
        Path source = Files.readSymbolicLink(copiedLink.toPath());
        Assertions.assertEquals((Object)content.toPath(), (Object)source);
    }

    @Test
    void testCopyDirectoryExceptions() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyDirectory(null, null));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyDirectory(null, (File)this.testFile1));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyDirectory((File)this.testFile1, null));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyDirectory(null, (File)new File("a")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyDirectory((File)this.testFile1, (File)new File("a")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyDirectory((File)this.testFile1, (File)new File("a")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyDirectory((File)this.tempDirFile, (File)this.tempDirFile));
        Assertions.assertThrows(IOException.class, () -> FileUtils.copyDirectory((File)new File("doesnt-exist"), (File)new File("a")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyDirectory((File)this.tempDirFile, (File)this.testFile1));
    }

    @Test
    void testCopyDirectoryFiltered() throws IOException {
        File grandParentDir = new File(this.tempDirFile, "grandparent");
        File parentDir = new File(grandParentDir, "parent");
        File childDir = new File(parentDir, "child");
        this.createFilesForTestCopyDirectory(grandParentDir, parentDir, childDir);
        NameFileFilter filter = new NameFileFilter(new String[]{"parent", "child", "file3.txt"});
        File destDir = new File(this.tempDirFile, "copydest");
        FileUtils.copyDirectory((File)grandParentDir, (File)destDir, (FileFilter)filter);
        List<File> files = LIST_WALKER.list(destDir);
        Assertions.assertEquals((int)3, (int)files.size());
        Assertions.assertEquals((Object)"parent", (Object)files.get(0).getName());
        Assertions.assertEquals((Object)"child", (Object)files.get(1).getName());
        Assertions.assertEquals((Object)"file3.txt", (Object)files.get(2).getName());
    }

    @Test
    void testCopyDirectoryPreserveDates() throws Exception {
        File source = new File(this.tempDirFile, "source");
        File sourceDirectory = new File(source, "directory");
        File sourceFile = new File(sourceDirectory, "hello.txt");
        source.mkdirs();
        sourceDirectory.mkdir();
        FileUtils.writeStringToFile((File)sourceFile, (String)"HELLO WORLD", (String)"UTF8");
        Assertions.assertTrue((boolean)this.setLastModifiedMillis(sourceFile, 1000000002000L));
        Assertions.assertTrue((boolean)this.setLastModifiedMillis(sourceDirectory, 1000000001000L));
        Assertions.assertTrue((boolean)this.setLastModifiedMillis(source, 1000000000000L));
        File target = new File(this.tempDirFile, "target");
        File targetDirectory = new File(target, "directory");
        File targetFile = new File(targetDirectory, "hello.txt");
        FileUtils.copyDirectory((File)source, (File)target, (boolean)false);
        Assertions.assertNotEquals((long)1000000000000L, (long)this.getLastModifiedMillis(target));
        Assertions.assertNotEquals((long)1000000001000L, (long)this.getLastModifiedMillis(targetDirectory));
        if (!SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertNotEquals((long)1000000002000L, (long)this.getLastModifiedMillis(targetFile));
        }
        if (!SystemUtils.IS_OS_WINDOWS) {
            Set<PosixFilePermission> parentPerms = Files.getPosixFilePermissions(target.getParentFile().toPath(), new LinkOption[0]);
            Set<PosixFilePermission> targetPerms = Files.getPosixFilePermissions(target.toPath(), new LinkOption[0]);
            Assertions.assertEquals(parentPerms, targetPerms);
        } else {
            AclFileAttributeView parentView = Files.getFileAttributeView(target.getParentFile().toPath(), AclFileAttributeView.class, new LinkOption[0]);
            AclFileAttributeView targetView = Files.getFileAttributeView(target.toPath(), AclFileAttributeView.class, new LinkOption[0]);
            Assertions.assertEquals(parentView.getAcl(), targetView.getAcl());
        }
        FileUtils.deleteDirectory((File)target);
        FileUtils.copyDirectory((File)source, (File)target, (boolean)true);
        Assertions.assertEquals((long)1000000000000L, (long)this.getLastModifiedMillis(target));
        Assertions.assertEquals((long)1000000001000L, (long)this.getLastModifiedMillis(targetDirectory));
        Assertions.assertEquals((long)1000000002000L, (long)this.getLastModifiedMillis(targetFile));
        FileUtils.deleteDirectory((File)target);
        target.mkdirs();
        FileUtils.copyDirectory((File)source, (File)target, (boolean)true);
        Assertions.assertEquals((long)1000000000000L, (long)this.getLastModifiedMillis(target));
        Assertions.assertEquals((long)1000000001000L, (long)this.getLastModifiedMillis(targetDirectory));
        Assertions.assertEquals((long)1000000002000L, (long)this.getLastModifiedMillis(targetFile));
        FileUtils.deleteDirectory((File)target);
        targetDirectory.mkdirs();
        FileUtils.copyDirectory((File)source, (File)target, (boolean)true);
        Assertions.assertEquals((long)1000000000000L, (long)this.getLastModifiedMillis(target));
        Assertions.assertEquals((long)1000000001000L, (long)this.getLastModifiedMillis(targetDirectory));
        Assertions.assertEquals((long)1000000002000L, (long)this.getLastModifiedMillis(targetFile));
        FileUtils.deleteDirectory((File)target);
    }

    @Test
    void testCopyDirectoryToChild() throws IOException {
        File grandParentDir = new File(this.tempDirFile, "grandparent");
        File parentDir = new File(grandParentDir, "parent");
        File childDir = new File(parentDir, "child");
        this.createFilesForTestCopyDirectory(grandParentDir, parentDir, childDir);
        long expectedCount = LIST_WALKER.list(grandParentDir).size() + LIST_WALKER.list(parentDir).size();
        long expectedSize = FileUtils.sizeOfDirectory((File)grandParentDir) + FileUtils.sizeOfDirectory((File)parentDir);
        FileUtils.copyDirectory((File)parentDir, (File)childDir);
        Assertions.assertEquals((long)expectedCount, (long)LIST_WALKER.list(grandParentDir).size());
        Assertions.assertEquals((long)expectedSize, (long)FileUtils.sizeOfDirectory((File)grandParentDir));
        Assertions.assertTrue((expectedCount > 0L ? 1 : 0) != 0, (String)"Count > 0");
        Assertions.assertTrue((expectedSize > 0L ? 1 : 0) != 0, (String)"Size > 0");
    }

    @Test
    void testCopyDirectoryToDirectory_NonExistingDest() throws Exception {
        if (!this.testFile1.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile1 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(this.testFile1.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 1234L);
        }
        if (!this.testFile2.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile2 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.testFile2.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 4321L);
        }
        File srcDir = this.tempDirFile;
        File subDir = new File(srcDir, "sub");
        subDir.mkdir();
        File subFile = new File(subDir, "A.txt");
        FileUtils.writeStringToFile((File)subFile, (String)"HELLO WORLD", (String)"UTF8");
        File destDir = new File(FileUtils.getTempDirectoryPath(), "tmp-FileUtilsTestCase");
        FileUtils.deleteDirectory((File)destDir);
        File actualDestDir = new File(destDir, srcDir.getName());
        FileUtils.copyDirectoryToDirectory((File)srcDir, (File)destDir);
        Assertions.assertTrue((boolean)destDir.exists(), (String)"Check exists");
        Assertions.assertTrue((boolean)actualDestDir.exists(), (String)"Check exists");
        long srcSize = FileUtils.sizeOfDirectory((File)srcDir);
        Assertions.assertTrue((srcSize > 0L ? 1 : 0) != 0, (String)"Size > 0");
        Assertions.assertEquals((long)srcSize, (long)FileUtils.sizeOfDirectory((File)actualDestDir), (String)"Check size");
        Assertions.assertTrue((boolean)new File(actualDestDir, "sub/A.txt").exists());
        FileUtils.deleteDirectory((File)destDir);
    }

    @Test
    void testCopyDirectoryToExistingDest() throws Exception {
        if (!this.testFile1.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile1 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(this.testFile1.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 1234L);
        }
        if (!this.testFile2.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile2 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.testFile2.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 4321L);
        }
        File srcDir = this.tempDirFile;
        File subDir = new File(srcDir, "sub");
        subDir.mkdir();
        File subFile = new File(subDir, "A.txt");
        FileUtils.writeStringToFile((File)subFile, (String)"HELLO WORLD", (String)"UTF8");
        File destDir = new File(SystemProperties.getJavaIoTmpdir(), "tmp-FileUtilsTestCase");
        FileUtils.deleteDirectory((File)destDir);
        destDir.mkdirs();
        FileUtils.copyDirectory((File)srcDir, (File)destDir);
        long srcSize = FileUtils.sizeOfDirectory((File)srcDir);
        Assertions.assertTrue((srcSize > 0L ? 1 : 0) != 0, (String)"Size > 0");
        Assertions.assertEquals((long)srcSize, (long)FileUtils.sizeOfDirectory((File)destDir));
        Assertions.assertTrue((boolean)new File(destDir, "sub/A.txt").exists());
    }

    @Test
    void testCopyDirectoryToGrandChild() throws IOException {
        File grandParentDir = new File(this.tempDirFile, "grandparent");
        File parentDir = new File(grandParentDir, "parent");
        File childDir = new File(parentDir, "child");
        this.createFilesForTestCopyDirectory(grandParentDir, parentDir, childDir);
        long expectedCount = LIST_WALKER.list(grandParentDir).size() * 2;
        long expectedSize = FileUtils.sizeOfDirectory((File)grandParentDir) * 2L;
        FileUtils.copyDirectory((File)grandParentDir, (File)childDir);
        Assertions.assertEquals((long)expectedCount, (long)LIST_WALKER.list(grandParentDir).size());
        Assertions.assertEquals((long)expectedSize, (long)FileUtils.sizeOfDirectory((File)grandParentDir));
        Assertions.assertTrue((expectedSize > 0L ? 1 : 0) != 0, (String)"Size > 0");
    }

    @Test
    void testCopyDirectoryToItself() throws Exception {
        File dir = new File(this.tempDirFile, "itself");
        dir.mkdirs();
        FileUtils.copyDirectoryToDirectory((File)dir, (File)dir);
        Assertions.assertEquals((int)1, (int)LIST_WALKER.list(dir).size());
    }

    @Test
    void testCopyDirectoryToNonExistingDest() throws Exception {
        if (!this.testFile1.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile1 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(this.testFile1.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 1234L);
        }
        if (!this.testFile2.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile2 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.testFile2.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 4321L);
        }
        File srcDir = this.tempDirFile;
        File subDir = new File(srcDir, "sub");
        subDir.mkdir();
        File subFile = new File(subDir, "A.txt");
        FileUtils.writeStringToFile((File)subFile, (String)"HELLO WORLD", (String)"UTF8");
        File destDir = new File(FileUtils.getTempDirectoryPath(), "tmp-FileUtilsTestCase");
        FileUtils.deleteDirectory((File)destDir);
        FileUtils.copyDirectory((File)srcDir, (File)destDir);
        Assertions.assertTrue((boolean)destDir.exists(), (String)"Check exists");
        long sizeOfSrcDirectory = FileUtils.sizeOfDirectory((File)srcDir);
        Assertions.assertTrue((sizeOfSrcDirectory > 0L ? 1 : 0) != 0, (String)"Size > 0");
        Assertions.assertEquals((long)sizeOfSrcDirectory, (long)FileUtils.sizeOfDirectory((File)destDir), (String)"Check size");
        Assertions.assertTrue((boolean)new File(destDir, "sub/A.txt").exists());
        FileUtils.deleteDirectory((File)destDir);
    }

    @Test
    void testCopyDirectoryWithPotentialFalsePartialMatch() throws IOException {
        File grandParentDir = new File(this.tempDirFile, "grandparent");
        File parentDir = new File(grandParentDir, "parent");
        File parDir = new File(grandParentDir, "par");
        File childDir = new File(parentDir, "child");
        this.createFilesForTestCopyDirectory(grandParentDir, parDir, childDir);
        List<File> initFiles = LIST_WALKER.list(grandParentDir);
        List<File> parFiles = LIST_WALKER.list(parDir);
        long expectedCount = initFiles.size() + parFiles.size();
        long expectedSize = FileUtils.sizeOfDirectory((File)grandParentDir) + FileUtils.sizeOfDirectory((File)parDir);
        FileUtils.copyDirectory((File)parDir, (File)childDir);
        List<File> latestFiles = LIST_WALKER.list(grandParentDir);
        Assertions.assertEquals((long)expectedCount, (long)latestFiles.size());
        Assertions.assertEquals((long)expectedSize, (long)FileUtils.sizeOfDirectory((File)grandParentDir));
        Assertions.assertTrue((expectedCount > 0L ? 1 : 0) != 0, (String)"Count > 0");
        Assertions.assertTrue((expectedSize > 0L ? 1 : 0) != 0, (String)"Size > 0");
        Set<String> initFilePaths = this.getFilePathSet(initFiles);
        Set<String> newFilePaths = this.getFilePathSet(latestFiles);
        newFilePaths.removeAll(initFilePaths);
        Assertions.assertEquals((int)parFiles.size(), (int)newFilePaths.size());
    }

    @Test
    void testCopyFile_SymbolicLink() throws Exception {
        File sourceDirectory = new File(this.tempDirFile, "source_directory");
        sourceDirectory.mkdir();
        File targetFile = new File(sourceDirectory, "hello.txt");
        FileUtils.writeStringToFile((File)targetFile, (String)"HELLO WORLD", (String)"UTF8");
        Path targetPath = targetFile.toPath();
        Path linkPath = sourceDirectory.toPath().resolve("linkfile");
        Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
        File destination = new File(this.tempDirFile, "destination");
        FileUtils.copyFile((File)linkPath.toFile(), (File)destination);
        Assertions.assertFalse((boolean)Files.isSymbolicLink(destination.toPath()));
        String contents = FileUtils.readFileToString((File)destination, (Charset)StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"HELLO WORLD", (Object)contents);
    }

    @Test
    void testCopyFile1() throws Exception {
        File destination = new File(this.tempDirFile, "copy1.txt");
        this.backDateFile10Minutes(this.testFile1);
        FileUtils.copyFile((File)this.testFile1, (File)destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)this.testFile1Size, (long)destination.length(), (String)"Check Full copy");
        Assertions.assertEquals((long)this.getLastModifiedMillis(this.testFile1), (long)this.getLastModifiedMillis(destination), (String)"Check last modified date preserved");
    }

    @Test
    void testCopyFile1ToDir() throws Exception {
        File directory = new File(this.tempDirFile, "subdir");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File destination = new File(directory, this.testFile1.getName());
        this.backDateFile10Minutes(this.testFile1);
        FileUtils.copyFileToDirectory((File)this.testFile1, (File)directory);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)this.testFile1Size, (long)destination.length(), (String)"Check Full copy");
        Assertions.assertEquals((long)FileUtils.lastModified((File)this.testFile1), (long)FileUtils.lastModified((File)destination), (String)"Check last modified date preserved");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyFileToDirectory((File)destination, (File)directory), (String)"Should not be able to copy a file into the same directory as itself");
    }

    @Test
    void testCopyFile2() throws Exception {
        File destination = new File(this.tempDirFile, "copy2.txt");
        this.backDateFile10Minutes(this.testFile1);
        FileUtils.copyFile((File)this.testFile1, (File)destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)this.testFile2Size, (long)destination.length(), (String)"Check Full copy");
        Assertions.assertEquals((long)this.getLastModifiedMillis(this.testFile1), (long)this.getLastModifiedMillis(destination), (String)"Check last modified date preserved");
    }

    @Test
    void testCopyFile2ToDir() throws Exception {
        File directory = new File(this.tempDirFile, "subdir");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File destination = new File(directory, this.testFile1.getName());
        this.backDateFile10Minutes(this.testFile1);
        FileUtils.copyFileToDirectory((File)this.testFile1, (File)directory);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)this.testFile2Size, (long)destination.length(), (String)"Check Full copy");
        Assertions.assertEquals((long)FileUtils.lastModified((File)this.testFile1), (long)FileUtils.lastModified((File)destination), (String)"Check last modified date preserved");
    }

    @Test
    void testCopyFile2WithoutFileDatePreservation() throws Exception {
        File destFile = new File(this.tempDirFile, "copy2.txt");
        this.backDateFile10Minutes(this.testFile1);
        long nowMillis = System.currentTimeMillis() - 1000L;
        FileUtils.copyFile((File)this.testFile1, (File)destFile, (boolean)false);
        Assertions.assertTrue((boolean)destFile.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)this.testFile1Size, (long)destFile.length(), (String)"Check Full copy");
        long destLastModMillis = this.getLastModifiedMillis(destFile);
        long unexpectedMillis = this.getLastModifiedMillis(this.testFile1);
        if (!SystemUtils.IS_OS_WINDOWS) {
            long deltaMillis = destLastModMillis - unexpectedMillis;
            Assertions.assertNotEquals((long)unexpectedMillis, (long)destLastModMillis, (String)("Check last modified date not same as input, delta " + deltaMillis));
            Assertions.assertTrue((destLastModMillis > nowMillis ? 1 : 0) != 0, (String)(destLastModMillis + " > " + nowMillis + " (delta " + deltaMillis + ")"));
        }
    }

    @Test
    @Disabled
    void testCopyFileLarge() throws Exception {
        File largeFile = new File(this.tempDirFile, "large.txt");
        File destination = new File(this.tempDirFile, "copylarge.txt");
        if (!largeFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + largeFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(largeFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0x40000000L);
        }
        FileUtils.copyFile((File)largeFile, (File)destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)largeFile.length(), (long)destination.length(), (String)"Check Full copy");
    }

    @Test
    void testCopyFileToOutputStream() throws Exception {
        ByteArrayOutputStream destination = new ByteArrayOutputStream();
        FileUtils.copyFile((File)this.testFile1, (OutputStream)destination);
        Assertions.assertEquals((long)this.testFile1Size, (long)destination.size(), (String)"Check Full copy size");
        byte[] expected = FileUtils.readFileToByteArray((File)this.testFile1);
        Assertions.assertArrayEquals((byte[])expected, (byte[])destination.toByteArray(), (String)"Check Full copy");
    }

    @Test
    void testCopyFileToReadOnlyDirectory() throws Exception {
        File directory = new File(this.tempDirFile, "readonly");
        if (!directory.exists()) {
            Assumptions.assumeTrue((boolean)directory.mkdirs());
        }
        Assumptions.assumeTrue((boolean)directory.setWritable(false));
        Assertions.assertThrows(IOException.class, () -> FileUtils.copyFileToDirectory((File)this.testFile1, (File)directory), (String)"Should not be able to copy a file into a readonly directory");
    }

    @Test
    void testCopyToDirectoryWithDirectory() throws IOException {
        File inputDirectory;
        File destDirectory = new File(this.tempDirFile, "destination");
        if (!destDirectory.exists()) {
            destDirectory.mkdirs();
        }
        if (!(inputDirectory = new File(this.tempDirFile, "input")).exists()) {
            inputDirectory.mkdirs();
        }
        File outputDirDestination = new File(destDirectory, inputDirectory.getName());
        FileUtils.copyToDirectory((File)this.testFile1, (File)inputDirectory);
        File destFile1 = new File(outputDirDestination, this.testFile1.getName());
        FileUtils.copyToDirectory((File)this.testFile2, (File)inputDirectory);
        File destFile2 = new File(outputDirDestination, this.testFile2.getName());
        FileUtils.copyToDirectory((File)inputDirectory, (File)destDirectory);
        Assertions.assertTrue((boolean)outputDirDestination.exists(), (String)"Check Exists");
        Assertions.assertTrue((boolean)outputDirDestination.isDirectory(), (String)"Check Directory");
        Assertions.assertTrue((boolean)destFile1.exists(), (String)"Check Exists");
        Assertions.assertEquals((long)this.testFile1Size, (long)destFile1.length(), (String)"Check Full Copy");
        Assertions.assertTrue((boolean)destFile2.exists(), (String)"Check Exists");
        Assertions.assertEquals((long)this.testFile2Size, (long)destFile2.length(), (String)"Check Full Copy");
    }

    @Test
    void testCopyToDirectoryWithFile() throws IOException {
        File directory = new File(this.tempDirFile, "subdir");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File destination = new File(directory, this.testFile1.getName());
        FileUtils.copyToDirectory((File)this.testFile1, (File)directory);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exists");
        Assertions.assertEquals((long)this.testFile1Size, (long)destination.length(), (String)"Check Full Copy");
    }

    @Test
    void testCopyToDirectoryWithFileSourceDoesNotExist() {
        Assertions.assertThrows(IOException.class, () -> FileUtils.copyToDirectory((File)new File(this.tempDirFile, "doesNotExists"), (File)this.tempDirFile));
    }

    @Test
    void testCopyToDirectoryWithFileSourceIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyToDirectory((File)null, (File)this.tempDirFile));
    }

    @Test
    void testCopyToDirectoryWithIterable() throws IOException {
        File directory = new File(this.tempDirFile, "subdir");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        ArrayList<File> input = new ArrayList<File>();
        input.add(this.testFile1);
        input.add(this.testFile2);
        File destFile1 = new File(directory, this.testFile1.getName());
        File destFile2 = new File(directory, this.testFile2.getName());
        FileUtils.copyToDirectory(input, (File)directory);
        Assertions.assertTrue((boolean)destFile1.exists(), (String)"Check Exists");
        Assertions.assertEquals((long)this.testFile1Size, (long)destFile1.length(), (String)"Check Full Copy");
        Assertions.assertTrue((boolean)destFile2.exists(), (String)"Check Exists");
        Assertions.assertEquals((long)this.testFile2Size, (long)destFile2.length(), (String)"Check Full Copy");
    }

    @Test
    void testCopyToDirectoryWithIterableSourceDoesNotExist() {
        Assertions.assertThrows(IOException.class, () -> FileUtils.copyToDirectory(Collections.singleton(new File(this.tempDirFile, "doesNotExists")), (File)this.tempDirFile));
    }

    @Test
    void testCopyToDirectoryWithIterableSourceIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyToDirectory((Iterable)null, (File)this.tempDirFile));
    }

    @Test
    void testCopyToSelf() throws Exception {
        File destination = new File(this.tempDirFile, "copy3.txt");
        FileUtils.copyFile((File)this.testFile1, (File)destination);
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyFile((File)destination, (File)destination));
    }

    @Test
    void testCopyURLToFile() throws Exception {
        File file = new File(this.tempDirFile, this.getName());
        this.assertContentMatchesAfterCopyURLToFileFor("/java/lang/Object.class", file);
    }

    @Test
    void testCopyURLToFileCreatesParentDirs() throws Exception {
        File file = this.managedTempDirPath.resolve("subdir").resolve(this.getName()).toFile();
        this.assertContentMatchesAfterCopyURLToFileFor("/java/lang/Object.class", file);
    }

    @Test
    void testCopyURLToFileReplacesExisting() throws Exception {
        File file = new File(this.tempDirFile, this.getName());
        this.assertContentMatchesAfterCopyURLToFileFor("/java/lang/Object.class", file);
        this.assertContentMatchesAfterCopyURLToFileFor("/java/lang/String.class", file);
    }

    @Test
    void testCopyURLToFileWithTimeout() throws Exception {
        File file = new File(this.tempDirFile, "testCopyURLToFileWithTimeout");
        String resourceName = "/java/lang/Object.class";
        FileUtils.copyURLToFile((URL)this.getClass().getResource("/java/lang/Object.class"), (File)file, (int)500, (int)500);
        try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
             InputStream resStream = this.getClass().getResourceAsStream("/java/lang/Object.class");){
            Assertions.assertTrue((boolean)IOUtils.contentEquals((InputStream)resStream, (InputStream)fis), (String)"Content is not equal.");
        }
    }

    @Test
    void testCountFolders1FileSize0() {
        Assertions.assertEquals((long)0L, (long)FileUtils.sizeOfDirectory((File)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]).toFile()));
    }

    @Test
    void testCountFolders1FileSize1() {
        Assertions.assertEquals((long)1L, (long)FileUtils.sizeOfDirectory((File)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]).toFile()));
    }

    @Test
    void testCountFolders2FileSize2() {
        Assertions.assertEquals((long)2L, (long)FileUtils.sizeOfDirectory((File)Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]).toFile()));
    }

    @Test
    void testCountFolders2FileSize4() {
        Assertions.assertEquals((long)8L, (long)FileUtils.sizeOfDirectory((File)Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-4", new String[0]).toFile()));
    }

    @Test
    void testCreateParentDirectories() throws IOException {
        FileUtils.createParentDirectories((File)FileUtils.current());
        FileUtils.createParentDirectories(null);
    }

    @Test
    void testDecodeUrl() {
        Assertions.assertEquals((Object)"", (Object)FileUtils.decodeUrl((String)""));
        Assertions.assertEquals((Object)"foo", (Object)FileUtils.decodeUrl((String)"foo"));
        Assertions.assertEquals((Object)"+", (Object)FileUtils.decodeUrl((String)"+"));
        Assertions.assertEquals((Object)"% ", (Object)FileUtils.decodeUrl((String)"%25%20"));
        Assertions.assertEquals((Object)"%20", (Object)FileUtils.decodeUrl((String)"%2520"));
        Assertions.assertEquals((Object)"jar:file:/C:/dir/sub dir/1.0/foo-1.0.jar!/org/Bar.class", (Object)FileUtils.decodeUrl((String)"jar:file:/C:/dir/sub%20dir/1.0/foo-1.0.jar!/org/Bar.class"));
    }

    @Test
    void testDecodeUrlEncodingUtf8() {
        Assertions.assertEquals((Object)"\u00e4\u00f6\u00fc\u00df", (Object)FileUtils.decodeUrl((String)"%C3%A4%C3%B6%C3%BC%C3%9F"));
    }

    @Test
    void testDecodeUrlLenient() {
        Assertions.assertEquals((Object)" ", (Object)FileUtils.decodeUrl((String)" "));
        Assertions.assertEquals((Object)"\u00e4\u00f6\u00fc\u00df", (Object)FileUtils.decodeUrl((String)"\u00e4\u00f6\u00fc\u00df"));
        Assertions.assertEquals((Object)"%", (Object)FileUtils.decodeUrl((String)"%"));
        Assertions.assertEquals((Object)"% ", (Object)FileUtils.decodeUrl((String)"%%20"));
        Assertions.assertEquals((Object)"%2", (Object)FileUtils.decodeUrl((String)"%2"));
        Assertions.assertEquals((Object)"%2G", (Object)FileUtils.decodeUrl((String)"%2G"));
    }

    @Test
    void testDecodeUrlNullSafe() {
        Assertions.assertNull((Object)FileUtils.decodeUrl(null));
    }

    @Test
    void testDelete() throws Exception {
        Assertions.assertEquals((Object)this.testFile1, (Object)FileUtils.delete((File)this.testFile1));
        Assertions.assertThrows(IOException.class, () -> FileUtils.delete((File)new File("does not exist.nope")));
    }

    @Test
    void testDeleteDirectoryFailsOnFile() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.deleteDirectory((File)this.testFile1));
    }

    @Test
    void testDeleteDirectoryNoopIfAbsent() {
        Assertions.assertDoesNotThrow(() -> FileUtils.deleteDirectory((File)new File("does not exist.nope")));
    }

    @Test
    void testDeleteDirectorySymbolicLink() throws IOException {
        Path symlinkedDir = (Path)this.createTempSymbolicLinkedRelativeDir().getLeft();
        FileUtils.deleteDirectory((File)symlinkedDir.toFile());
        Assertions.assertFalse((boolean)Files.exists(symlinkedDir, new LinkOption[0]));
    }

    @Test
    void testDeleteDirectorySymbolicLinkAbsent() throws IOException {
        ImmutablePair<Path, Path> pair = this.createTempSymbolicLinkedRelativeDir();
        Path symlinkedDir = (Path)pair.getLeft();
        Path targetDir = (Path)pair.getRight();
        Assertions.assertTrue((boolean)Files.exists(symlinkedDir, new LinkOption[0]), symlinkedDir::toString);
        Files.delete(symlinkedDir);
        Assertions.assertTrue((boolean)Files.exists(targetDir, new LinkOption[0]), targetDir::toString);
        Assertions.assertFalse((boolean)Files.exists(symlinkedDir, new LinkOption[0]), symlinkedDir::toString);
        FileUtils.deleteDirectory((File)symlinkedDir.toFile());
        Assertions.assertFalse((boolean)Files.exists(symlinkedDir, new LinkOption[0]), symlinkedDir::toString);
    }

    @Test
    void testDeleteDirectorySymbolicLinkAbsentDeepTarget() throws IOException {
        ImmutablePair<Path, Path> pair = this.createTempSymbolicLinkedRelativeDir();
        Path symLinkedDir = (Path)pair.getLeft();
        Path targetDir = (Path)pair.getRight();
        Path targetDir2 = targetDir.resolve("subdir2");
        Path symLinkedDir2 = targetDir.resolve("symlinked-dir2");
        Files.createDirectory(targetDir2, new FileAttribute[0]);
        Files.createSymbolicLink(symLinkedDir2, targetDir2, new FileAttribute[0]);
        Assertions.assertTrue((boolean)Files.exists(symLinkedDir2, new LinkOption[0]), symLinkedDir2::toString);
        Files.delete(targetDir2);
        Assertions.assertFalse((boolean)Files.exists(targetDir2, new LinkOption[0]), targetDir2::toString);
        Assertions.assertFalse((boolean)Files.exists(symLinkedDir2, new LinkOption[0]), symLinkedDir2::toString);
        FileUtils.deleteDirectory((File)targetDir.toFile());
        Assertions.assertFalse((boolean)Files.exists(targetDir, new LinkOption[0]), targetDir::toString);
    }

    @Test
    void testDeleteDirectorySymbolicLinkAbsentTarget() throws IOException {
        ImmutablePair<Path, Path> pair = this.createTempSymbolicLinkedRelativeDir();
        Path symlinkedDir = (Path)pair.getLeft();
        Path targetDir = (Path)pair.getRight();
        Assertions.assertTrue((boolean)Files.exists(symlinkedDir, new LinkOption[0]), symlinkedDir::toString);
        Files.delete(targetDir);
        Assertions.assertFalse((boolean)Files.exists(targetDir, new LinkOption[0]), targetDir::toString);
        Assertions.assertFalse((boolean)Files.exists(symlinkedDir, new LinkOption[0]), symlinkedDir::toString);
        FileUtils.deleteDirectory((File)symlinkedDir.toFile());
        Assertions.assertFalse((boolean)Files.exists(symlinkedDir, new LinkOption[0]), symlinkedDir::toString);
    }

    @Test
    void testDeleteQuietlyDir() throws IOException {
        File testDirectory = new File(this.tempDirFile, "testDeleteQuietlyDir");
        File testFile = new File(testDirectory, "testDeleteQuietlyFile");
        testDirectory.mkdirs();
        if (!testFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        Assertions.assertTrue((boolean)testDirectory.exists());
        Assertions.assertTrue((boolean)testFile.exists());
        FileUtils.deleteQuietly((File)testDirectory);
        Assertions.assertFalse((boolean)testDirectory.exists(), (String)"Check No Exist");
        Assertions.assertFalse((boolean)testFile.exists(), (String)"Check No Exist");
    }

    @Test
    void testDeleteQuietlyFile() throws IOException {
        File testFile = new File(this.tempDirFile, "testDeleteQuietlyFile");
        if (!testFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        Assertions.assertTrue((boolean)testFile.exists());
        FileUtils.deleteQuietly((File)testFile);
        Assertions.assertFalse((boolean)testFile.exists(), (String)"Check No Exist");
    }

    @Test
    void testDeleteQuietlyForNull() {
        FileUtils.deleteQuietly(null);
    }

    @Test
    void testDeleteQuietlyNonExistent() {
        File testFile = new File("testDeleteQuietlyNonExistent");
        Assertions.assertFalse((boolean)testFile.exists());
        FileUtils.deleteQuietly((File)testFile);
    }

    @Test
    void testFileUtils() throws Exception {
        File file1 = new File(this.tempDirFile, "test.txt");
        String fileName = file1.getAbsolutePath();
        try (OutputStream out = Files.newOutputStream(file1.toPath(), new OpenOption[0]);){
            out.write("This is a test".getBytes(StandardCharsets.UTF_8));
        }
        File file2 = new File(this.tempDirFile, "test2.txt");
        FileUtils.writeStringToFile((File)file2, (String)fileName, (String)UTF_8);
        Assertions.assertTrue((boolean)file2.exists());
        Assertions.assertTrue((file2.length() > 0L ? 1 : 0) != 0);
        String file2contents = FileUtils.readFileToString((File)file2, (String)UTF_8);
        Assertions.assertEquals((Object)fileName, (Object)file2contents, (String)"Second file's contents correct");
        Assertions.assertTrue((boolean)file2.delete());
        String contents = FileUtils.readFileToString((File)new File(fileName), (String)UTF_8);
        Assertions.assertEquals((Object)"This is a test", (Object)contents, (String)"FileUtils.fileRead()");
    }

    @Test
    void testForceDeleteAFile1() throws Exception {
        File destination = new File(this.tempDirFile, "copy1.txt");
        destination.createNewFile();
        Assertions.assertTrue((boolean)destination.exists(), (String)"Copy1.txt doesn't exist to delete");
        FileUtils.forceDelete((File)destination);
        Assertions.assertFalse((boolean)destination.exists(), (String)"Check No Exist");
    }

    @Test
    void testForceDeleteAFile2() throws Exception {
        File destination = new File(this.tempDirFile, "copy2.txt");
        destination.createNewFile();
        Assertions.assertTrue((boolean)destination.exists(), (String)"Copy2.txt doesn't exist to delete");
        FileUtils.forceDelete((File)destination);
        Assertions.assertFalse((boolean)destination.exists(), (String)"Check No Exist");
    }

    @Test
    void testForceDeleteAFileDoesNotExist() {
        File destination = new File(this.tempDirFile, "no_such_file");
        Assertions.assertFalse((boolean)destination.exists(), (String)"Check No Exist");
        Assertions.assertThrowsExactly(FileNotFoundException.class, () -> FileUtils.forceDelete((File)destination));
    }

    @Test
    public void testForceDeleteBrokenSymlink() throws Exception {
        ImmutablePair<Path, Path> pair = this.createTempSymbolicLinkedRelativeDir();
        Path symlinkedDir = (Path)pair.getLeft();
        Path targetDir = (Path)pair.getRight();
        Files.delete(targetDir);
        Assertions.assertFalse((boolean)Files.exists(symlinkedDir, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.isSymbolicLink(symlinkedDir));
        FileUtils.forceDelete((File)symlinkedDir.toFile());
        Assertions.assertFalse((boolean)Files.exists(symlinkedDir, new LinkOption[0]));
        Assertions.assertFalse((boolean)Files.isSymbolicLink(symlinkedDir));
    }

    @Test
    void testForceDeleteDir() throws Exception {
        File testDirectory = this.tempDirFile;
        Assertions.assertTrue((boolean)testDirectory.exists(), (String)"TestDirectory must exist");
        FileUtils.forceDelete((File)testDirectory);
        Assertions.assertFalse((boolean)testDirectory.exists(), (String)"TestDirectory must not exist");
    }

    @Test
    @EnabledOnOs(value={OS.MAC})
    void testForceDeleteReadOnlyDirectory() throws Exception {
        TempFile destination;
        try (TempDirectory destDir = TempDirectory.create("dir-", new FileAttribute[0]);){
            destination = TempFile.create(destDir, "test-", ".txt", new FileAttribute[0]);
            try {
                Assertions.assertTrue((boolean)Files.isDirectory(destDir.get(), new LinkOption[0]));
                Assertions.assertEquals((Object)destDir.get(), (Object)destination.get().getParent());
                File file = destination.toFile();
                Assertions.assertTrue((boolean)file.setReadOnly());
                Assertions.assertTrue((boolean)file.canRead());
                Assertions.assertFalse((boolean)file.canWrite());
                Counters.PathCounters delete = destDir.delete();
                Assertions.assertEquals((long)1L, (long)delete.getDirectoryCounter().get());
                Assertions.assertEquals((long)1L, (long)delete.getFileCounter().get());
                Assertions.assertFalse((boolean)file.exists());
                Assertions.assertFalse((boolean)destDir.exists(new LinkOption[0]));
            }
            finally {
                if (destination != null) {
                    destination.close();
                }
            }
        }
        destDir = TempDirectory.create("dir-", new FileAttribute[0]);
        try {
            destination = TempFile.create(destDir, "test-", ".txt", new FileAttribute[0]);
            try {
                Assertions.assertTrue((boolean)Files.isDirectory(destDir.get(), new LinkOption[0]));
                Assertions.assertEquals((Object)destDir.get(), (Object)destination.get().getParent());
                File dir = destDir.toFile();
                Assertions.assertTrue((boolean)dir.setReadOnly());
                Assertions.assertTrue((boolean)dir.canRead());
                Assertions.assertFalse((boolean)dir.canWrite());
                Assertions.assertTrue((boolean)dir.exists(), (String)"File doesn't exist to delete");
                FileUtils.forceDelete((File)dir);
                Assertions.assertFalse((boolean)destination.exists(new LinkOption[0]), (String)"Check deletion");
                Assertions.assertFalse((boolean)dir.exists(), (String)"Check deletion");
                Assertions.assertFalse((boolean)destDir.exists(new LinkOption[0]), (String)"Check deletion");
            }
            finally {
                if (destination != null) {
                    destination.close();
                }
            }
        }
        finally {
            if (destDir != null) {
                destDir.close();
            }
        }
    }

    @Test
    void testForceDeleteReadOnlyFile() throws Exception {
        File file;
        try (TempFile destination = TempFile.create("test-", ".txt", new FileAttribute[0]);){
            file = destination.toFile();
            Assertions.assertTrue((boolean)file.setReadOnly(), (String)"Setting file read-only successful");
            Assertions.assertTrue((boolean)file.canRead(), (String)"File must be readable");
            Assertions.assertFalse((boolean)file.canWrite(), (String)"File must not be writable");
            Assertions.assertTrue((boolean)file.exists(), (String)"File doesn't exist to delete");
            FileUtilsTest.setDosReadOnly(file.toPath(), false);
            Assertions.assertTrue((boolean)file.delete(), (String)"File.delete() must delete read-only file");
        }
        destination = TempFile.create("test-", ".txt", new FileAttribute[0]);
        try {
            file = destination.toFile();
            Assertions.assertTrue((boolean)file.setReadOnly(), (String)"Setting file read-only successful");
            Assertions.assertTrue((boolean)file.canRead(), (String)"File must be readable");
            Assertions.assertFalse((boolean)file.canWrite(), (String)"File must not be writable");
            Assertions.assertTrue((boolean)file.exists(), (String)"File doesn't exist to delete");
            FileUtils.forceDelete((File)file);
            Assertions.assertFalse((boolean)file.exists(), (String)"FileUtils.forceDelete() must delete read-only file");
        }
        finally {
            if (destination != null) {
                destination.close();
            }
        }
    }

    @Test
    public void testForceDeleteSymlink() throws Exception {
        ImmutablePair<Path, Path> pair = this.createTempSymbolicLinkedRelativeDir();
        Path symlinkedDir = (Path)pair.getLeft();
        Path targetDir = (Path)pair.getRight();
        Assertions.assertTrue((boolean)Files.exists(symlinkedDir, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.isSymbolicLink(symlinkedDir));
        Assertions.assertTrue((boolean)Files.exists(targetDir, new LinkOption[0]));
        FileUtils.forceDelete((File)symlinkedDir.toFile());
        Assertions.assertFalse((boolean)Files.exists(symlinkedDir, new LinkOption[0]));
        Assertions.assertFalse((boolean)Files.isSymbolicLink(symlinkedDir));
        Assertions.assertTrue((boolean)Files.exists(targetDir, new LinkOption[0]));
    }

    @Test
    @EnabledOnOs(value={OS.MAC})
    void testForceDeleteUnwritableDirectory() throws Exception {
        File dir;
        TempFile file;
        try (TempDirectory destDir = TempDirectory.create("dir-", new FileAttribute[0]);){
            file = TempFile.create(destDir, "test-", ".txt", new FileAttribute[0]);
            try {
                Assertions.assertTrue((boolean)Files.isDirectory(destDir.get(), new LinkOption[0]));
                Assertions.assertEquals((Object)destDir.get(), (Object)file.get().getParent());
                dir = destDir.toFile();
                Assertions.assertTrue((boolean)dir.canWrite());
                Assertions.assertTrue((boolean)dir.setWritable(false), () -> "setWritable(false) on " + dir);
                Assertions.assertFalse((boolean)dir.canWrite());
                Assertions.assertTrue((boolean)dir.canRead());
                Assertions.assertFalse((boolean)dir.delete());
                Assertions.assertFalse((boolean)file.toFile().delete());
                Assertions.assertTrue((boolean)dir.setWritable(true));
                Assertions.assertTrue((boolean)file.toFile().delete());
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
        destDir = TempDirectory.create("dir-", new FileAttribute[0]);
        try {
            file = TempFile.create(destDir, "test-", ".txt", new FileAttribute[0]);
            try {
                Assertions.assertTrue((boolean)Files.isDirectory(destDir.get(), new LinkOption[0]));
                Assertions.assertEquals((Object)destDir.get(), (Object)file.get().getParent());
                dir = destDir.toFile();
                Assertions.assertTrue((boolean)dir.canWrite());
                Assertions.assertTrue((boolean)dir.setWritable(false));
                Assertions.assertFalse((boolean)dir.canWrite());
                Assertions.assertTrue((boolean)dir.canRead());
                Assertions.assertFalse((boolean)dir.delete());
                FileUtils.forceDelete((File)dir);
                Assertions.assertFalse((boolean)file.exists(new LinkOption[0]));
                Assertions.assertFalse((boolean)dir.exists());
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
        finally {
            if (destDir != null) {
                destDir.close();
            }
        }
    }

    @Test
    void testForceDeleteUnwritableFile() throws Exception {
        File file;
        try (TempFile destination = TempFile.create("test-", ".txt", new FileAttribute[0]);){
            file = destination.toFile();
            Assertions.assertTrue((boolean)file.canWrite(), (String)"File must be writable");
            Assertions.assertTrue((boolean)file.setWritable(false), (String)"Setting file unwritable successful");
            Assertions.assertFalse((boolean)file.canWrite(), (String)"File must not be writable");
            Assertions.assertTrue((boolean)file.canRead(), (String)"File must be readable");
            Assertions.assertTrue((boolean)file.exists(), (String)"File must exist to delete");
            FileUtilsTest.setDosReadOnly(file.toPath(), false);
            Assertions.assertTrue((boolean)file.delete(), (String)"File.delete() must delete unwritable file");
        }
        destination = TempFile.create("test-", ".txt", new FileAttribute[0]);
        try {
            file = destination.toFile();
            Assertions.assertTrue((boolean)file.canWrite(), (String)"File must be writable");
            Assertions.assertTrue((boolean)file.setWritable(false), (String)"Setting file unwritable successful");
            Assertions.assertFalse((boolean)file.canWrite(), (String)"File must not be writable");
            Assertions.assertTrue((boolean)file.canRead(), (String)"File must be readable");
            Assertions.assertTrue((boolean)file.exists(), (String)"File must exist to delete");
            FileUtils.forceDelete((File)file);
            Assertions.assertFalse((boolean)file.exists(), (String)"FileUtils.forceDelete() must delete unwritable file");
        }
        finally {
            if (destination != null) {
                destination.close();
            }
        }
    }

    @Test
    void testForceMkdir() throws Exception {
        FileUtils.forceMkdir((File)this.tempDirFile);
        File testFile = new File(this.tempDirFile, this.getName());
        testFile.createNewFile();
        Assertions.assertTrue((boolean)testFile.exists(), (String)"Test file does not exist.");
        Assertions.assertThrows(IOException.class, () -> FileUtils.forceMkdir((File)testFile));
        testFile.delete();
        FileUtils.forceMkdir((File)testFile);
        Assertions.assertTrue((boolean)testFile.exists(), (String)"Directory was not created.");
        FileUtils.forceMkdir(null);
    }

    @Test
    void testForceMkdirParent() throws Exception {
        Assertions.assertTrue((boolean)this.tempDirFile.exists());
        File testParentDir = new File(this.tempDirFile, "testForceMkdirParent");
        testParentDir.delete();
        Assertions.assertFalse((boolean)testParentDir.exists());
        File testFile = new File(testParentDir, "test.txt");
        Assertions.assertFalse((boolean)testParentDir.exists());
        Assertions.assertFalse((boolean)testFile.exists());
        FileUtils.forceMkdirParent((File)testFile);
        Assertions.assertTrue((boolean)testParentDir.exists());
        Assertions.assertFalse((boolean)testFile.exists());
        FileUtils.forceMkdirParent((File)testFile);
        Assertions.assertTrue((boolean)testParentDir.exists());
        Assertions.assertFalse((boolean)testFile.exists());
    }

    @Test
    void testGetFile() {
        File expected_A = new File("src");
        File expected_B = new File(expected_A, "main");
        File expected_C = new File(expected_B, "java");
        Assertions.assertEquals((Object)expected_A, (Object)FileUtils.getFile((String[])new String[]{"src"}), (String)"A");
        Assertions.assertEquals((Object)expected_B, (Object)FileUtils.getFile((String[])new String[]{"src", "main"}), (String)"B");
        Assertions.assertEquals((Object)expected_C, (Object)FileUtils.getFile((String[])new String[]{"src", "main", "java"}), (String)"C");
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.getFile((String[])null));
    }

    @Test
    void testGetFile_Parent() {
        File parent = new File("parent");
        File expected_A = new File(parent, "src");
        File expected_B = new File(expected_A, "main");
        File expected_C = new File(expected_B, "java");
        Assertions.assertEquals((Object)expected_A, (Object)FileUtils.getFile((File)parent, (String[])new String[]{"src"}), (String)"A");
        Assertions.assertEquals((Object)expected_B, (Object)FileUtils.getFile((File)parent, (String[])new String[]{"src", "main"}), (String)"B");
        Assertions.assertEquals((Object)expected_C, (Object)FileUtils.getFile((File)parent, (String[])new String[]{"src", "main", "java"}), (String)"C");
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.getFile((File)parent, (String[])null));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.getFile((File)null, (String[])new String[]{"src"}));
    }

    @Test
    void testGetTempDirectory() {
        File tempDirectory = new File(FileUtils.getTempDirectoryPath());
        Assertions.assertEquals((Object)tempDirectory, (Object)FileUtils.getTempDirectory());
    }

    @Test
    void testGetTempDirectoryPath() {
        Assertions.assertEquals((Object)SystemProperties.getJavaIoTmpdir(), (Object)FileUtils.getTempDirectoryPath());
    }

    @Test
    void testGetUserDirectory() {
        File userDirectory = new File(SystemProperties.getUserHome());
        Assertions.assertEquals((Object)userDirectory, (Object)FileUtils.getUserDirectory());
    }

    @Test
    void testGetUserDirectoryPath() {
        Assertions.assertEquals((Object)SystemProperties.getUserHome(), (Object)FileUtils.getUserDirectoryPath());
    }

    @Test
    void testIO276() throws Exception {
        File dir = new File("target", "IO276");
        Files.deleteIfExists(dir.toPath());
        Assertions.assertTrue((boolean)dir.mkdirs(), (String)(dir + " should not be present"));
        File file = new File(dir, "IO276.txt");
        Assertions.assertTrue((boolean)file.createNewFile(), (String)(file + " should not be present"));
        FileUtils.forceDeleteOnExit((File)dir);
    }

    @Test
    void testIO300() {
        File testDirectory = this.tempDirFile;
        File src = new File(testDirectory, "dir1");
        File dest = new File(src, "dir2");
        Assertions.assertTrue((boolean)dest.mkdirs());
        Assertions.assertTrue((boolean)src.exists());
        Assertions.assertThrows(IOException.class, () -> FileUtils.moveDirectoryToDirectory((File)src, (File)dest, (boolean)false));
        Assertions.assertTrue((boolean)src.exists());
    }

    @Test
    void testIO575() throws IOException {
        Path sourceDir = Files.createTempDirectory("source-dir", new FileAttribute[0]);
        String fileName = "some-file";
        Path sourceFile = Files.createFile(sourceDir.resolve("some-file"), new FileAttribute[0]);
        Assertions.assertEquals((Object)SystemUtils.IS_OS_WINDOWS, (Object)sourceFile.toFile().canExecute());
        sourceFile.toFile().setExecutable(true);
        Assertions.assertTrue((boolean)sourceFile.toFile().canExecute());
        Path destDir = Files.createTempDirectory("some-empty-destination", new FileAttribute[0]);
        FileUtils.copyDirectory((File)sourceDir.toFile(), (File)destDir.toFile());
        Path destFile = destDir.resolve("some-file");
        Assertions.assertTrue((boolean)destFile.toFile().exists());
        Assertions.assertTrue((boolean)destFile.toFile().canExecute());
    }

    @Test
    void testIsDirectory() throws IOException {
        File tempDirAsFile;
        Assertions.assertFalse((boolean)FileUtils.isDirectory(null, (LinkOption[])new LinkOption[0]));
        Assertions.assertTrue((boolean)FileUtils.isDirectory((File)this.tempDirFile, (LinkOption[])new LinkOption[0]));
        Assertions.assertFalse((boolean)FileUtils.isDirectory((File)this.testFile1, (LinkOption[])new LinkOption[0]));
        try (TempDirectory tempDir = TempDirectory.create(this.getClass().getCanonicalName(), new FileAttribute[0]);){
            tempDirAsFile = tempDir.toFile();
            Assertions.assertTrue((boolean)FileUtils.isDirectory((File)tempDirAsFile, (LinkOption[])new LinkOption[0]));
        }
        Assertions.assertFalse((boolean)FileUtils.isDirectory((File)tempDirAsFile, (LinkOption[])new LinkOption[0]));
    }

    @Test
    void testIsEmptyDirectory() throws IOException {
        try (TempDirectory tempDir = TempDirectory.create(this.getClass().getCanonicalName(), new FileAttribute[0]);){
            File tempDirAsFile = tempDir.toFile();
            Assertions.assertTrue((boolean)FileUtils.isEmptyDirectory((File)tempDirAsFile));
        }
        Assertions.assertFalse((boolean)FileUtils.isEmptyDirectory((File)DIR_SIZE_1.toFile()));
    }

    @ParameterizedTest
    @ValueSource(longs={1L, 100L, 1000L, 10000L, 100000L, 1000000L})
    void testIsFileNewerOlder(long millis) throws Exception {
        File oldFile = new File(this.tempDirFile, "FileUtils-old.txt");
        File refFile = new File(this.tempDirFile, "FileUtils-reference.txt");
        File newFile = new File(this.tempDirFile, "FileUtils-new.txt");
        File invalidFile = new File(this.tempDirFile, "FileUtils-invalid-file.txt");
        Path oldPath = oldFile.toPath();
        Path refPath = refFile.toPath();
        Path newPath = newFile.toPath();
        long actualMillis = SystemUtils.IS_OS_MAC && SystemUtils.IS_JAVA_1_8 ? millis + 1000L : millis;
        FileTime oldFileTime = FileTime.from(actualMillis * 1L, TimeUnit.MILLISECONDS);
        FileTime refFileTime = FileTime.from(actualMillis * 2L, TimeUnit.MILLISECONDS);
        FileTime testFileTime = FileTime.from(actualMillis * 3L, TimeUnit.MILLISECONDS);
        FileTime newFileTime = FileTime.from(actualMillis * 4L, TimeUnit.MILLISECONDS);
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(oldPath, new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        Files.setLastModifiedTime(oldPath, oldFileTime);
        output = new BufferedOutputStream(Files.newOutputStream(refPath, new OpenOption[0]));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            ((OutputStream)output).close();
        }
        Files.setLastModifiedTime(refPath, refFileTime);
        Date date = new Date(testFileTime.toMillis());
        long now = date.getTime();
        Instant instant = date.toInstant();
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        OffsetDateTime offsetDateTime = zonedDateTime.toOffsetDateTime();
        LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
        LocalDate localDate = zonedDateTime.toLocalDate();
        LocalDate localDatePlusDay = localDate.plusDays(1L);
        LocalTime localTime0 = LocalTime.MIDNIGHT;
        OffsetTime offsetTime0 = OffsetTime.of(localTime0, ZoneOffset.UTC);
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(newPath, new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        Files.setLastModifiedTime(newPath, newFileTime);
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (File)refFile), (String)"Old File - Newer - File");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (Date)date), (String)"Old File - Newer - Date");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (long)now), (String)"Old File - Newer - Mili");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (Instant)instant), (String)"Old File - Newer - Instant");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (ChronoZonedDateTime)zonedDateTime), (String)"Old File - Newer - ZonedDateTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (OffsetDateTime)offsetDateTime), (String)"Old File - Newer - OffsetDateTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (ChronoLocalDateTime)localDateTime), (String)"Old File - Newer - LocalDateTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (ChronoLocalDateTime)localDateTime, (ZoneId)ZoneId.systemDefault()), (String)"Old File - Newer - LocalDateTime,ZoneId");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (ChronoLocalDate)localDate), (String)"Old File - Newer - LocalDate");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)oldFile, (ChronoLocalDate)localDate, (LocalTime)localTime0), (String)"Old File - Newer - LocalDate,LocalTime");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)oldFile, (ChronoLocalDate)localDate, (OffsetTime)offsetTime0), (String)"Old File - Newer - LocalDate,OffsetTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (ChronoLocalDate)localDatePlusDay), (String)"Old File - Newer - LocalDate plus one day");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (ChronoLocalDate)localDatePlusDay, (LocalTime)localTime0), (String)"Old File - Newer - LocalDate plus one day,LocalTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (ChronoLocalDate)localDatePlusDay, (OffsetTime)offsetTime0), (String)"Old File - Newer - LocalDate plus one day,OffsetTime");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (File)refFile), (String)"New File - Newer - File");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (Date)date), (String)"New File - Newer - Date");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (long)now), (String)"New File - Newer - Mili");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (Instant)instant), (String)"New File - Newer - Instant");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (ChronoZonedDateTime)zonedDateTime), (String)"New File - Newer - ZonedDateTime");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (OffsetDateTime)offsetDateTime), (String)"New File - Newer - OffsetDateTime");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (ChronoLocalDateTime)localDateTime), (String)"New File - Newer - LocalDateTime");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (ChronoLocalDateTime)localDateTime, (ZoneId)ZoneId.systemDefault()), (String)"New File - Newer - LocalDateTime,ZoneId");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)newFile, (ChronoLocalDate)localDate), (String)"New File - Newer - LocalDate");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (ChronoLocalDate)localDate, (LocalTime)localTime0), (String)"New File - Newer - LocalDate,LocalTime");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (ChronoLocalDate)localDate, (OffsetTime)offsetTime0), (String)"New File - Newer - LocalDate,OffsetTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)newFile, (ChronoLocalDate)localDatePlusDay), (String)"New File - Newer - LocalDate plus one day");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)newFile, (ChronoLocalDate)localDatePlusDay, (LocalTime)localTime0), (String)"New File - Newer - LocalDate plus one day,LocalTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)newFile, (ChronoLocalDate)localDatePlusDay, (OffsetTime)offsetTime0), (String)"New File - Newer - LocalDate plus one day,OffsetTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)invalidFile, (File)refFile), (String)"Illegal - Newer - File");
        Assertions.assertThrows(UncheckedIOException.class, () -> FileUtils.isFileNewer((File)newFile, (File)invalidFile));
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (File)refFile), (String)"Old File - Older - File");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (Date)date), (String)"Old File - Older - Date");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (long)now), (String)"Old File - Older - Mili");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (Instant)instant), (String)"Old File - Older - Instant");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (ChronoZonedDateTime)zonedDateTime), (String)"Old File - Older - ZonedDateTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (OffsetDateTime)offsetDateTime), (String)"Old File - Older - OffsetDateTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (ChronoLocalDateTime)localDateTime), (String)"Old File - Older - LocalDateTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (ChronoLocalDateTime)localDateTime, (ZoneId)ZoneId.systemDefault()), (String)"Old File - Older - LocalDateTime,LocalTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (ChronoLocalDate)localDate), (String)"Old File - Older - LocalDate");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)oldFile, (ChronoLocalDate)localDate, (LocalTime)localTime0), (String)"Old File - Older - LocalDate,LocalTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)oldFile, (ChronoLocalDate)localDate, (OffsetTime)offsetTime0), (String)"Old File - Older - LocalDate,OffsetTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (ChronoLocalDate)localDatePlusDay), (String)"Old File - Older - LocalDate plus one day");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (ChronoLocalDate)localDatePlusDay, (LocalTime)localTime0), (String)"Old File - Older - LocalDate plus one day,LocalTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (ChronoLocalDate)localDatePlusDay, (OffsetTime)offsetTime0), (String)"Old File - Older - LocalDate plus one day,OffsetTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (File)refFile), (String)"New File - Older - File");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (Date)date), (String)"New File - Older - Date");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (long)now), (String)"New File - Older - Mili");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (Instant)instant), (String)"New File - Older - Instant");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (ChronoZonedDateTime)zonedDateTime), (String)"New File - Older - ZonedDateTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (OffsetDateTime)offsetDateTime), (String)"New File - Older - OffsetDateTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (ChronoLocalDateTime)localDateTime), (String)"New File - Older - LocalDateTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (ChronoLocalDateTime)localDateTime, (ZoneId)ZoneId.systemDefault()), (String)"New File - Older - LocalDateTime,ZoneId");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)newFile, (ChronoLocalDate)localDate), (String)"New File - Older - LocalDate");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (ChronoLocalDate)localDate, (LocalTime)localTime0), (String)"New File - Older - LocalDate,LocalTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (ChronoLocalDate)localDate, (OffsetTime)offsetTime0), (String)"New File - Older - LocalDate,OffsetTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)newFile, (ChronoLocalDate)localDatePlusDay), (String)"New File - Older - LocalDate plus one day");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)newFile, (ChronoLocalDate)localDatePlusDay, (LocalTime)localTime0), (String)"New File - Older - LocalDate plus one day,LocalTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)newFile, (ChronoLocalDate)localDatePlusDay, (OffsetTime)offsetTime0), (String)"New File - Older - LocalDate plus one day,OffsetTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)invalidFile, (File)refFile), (String)"Illegal - Older - File");
        Assertions.assertThrows(UncheckedIOException.class, () -> FileUtils.isFileOlder((File)newFile, (File)invalidFile));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileNewer(null, (long)now));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileNewer((File)oldFile, (File)null));
        Assertions.assertThrows(UncheckedIOException.class, () -> FileUtils.isFileNewer((File)oldFile, (File)invalidFile));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileNewer((File)oldFile, (Date)null));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileOlder(null, (long)now));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileOlder((File)oldFile, (File)null));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileOlder((File)oldFile, (Date)null));
        Assertions.assertThrows(UncheckedIOException.class, () -> FileUtils.isFileOlder((File)oldFile, (File)invalidFile));
    }

    @Test
    void testIsRegularFile() throws IOException {
        Assertions.assertFalse((boolean)FileUtils.isRegularFile(null, (LinkOption[])new LinkOption[0]));
        Assertions.assertFalse((boolean)FileUtils.isRegularFile((File)this.tempDirFile, (LinkOption[])new LinkOption[0]));
        Assertions.assertTrue((boolean)FileUtils.isRegularFile((File)this.testFile1, (LinkOption[])new LinkOption[0]));
        Files.delete(this.testFile1.toPath());
        Assertions.assertFalse((boolean)FileUtils.isRegularFile((File)this.testFile1, (LinkOption[])new LinkOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testIterateFiles() throws Exception {
        File srcDir = this.tempDirFile;
        File subDir = new File(srcDir, "list_test");
        File subSubDir = new File(subDir, "subSubDir");
        File notSubSubDir = new File(subDir, "notSubSubDir");
        Assertions.assertTrue((boolean)subDir.mkdir());
        Assertions.assertTrue((boolean)subSubDir.mkdir());
        Assertions.assertTrue((boolean)notSubSubDir.mkdir());
        Iterator iterator = null;
        try {
            ArrayList<String> expectedFileNames = new ArrayList<String>(Arrays.asList("a.txt", "b.txt", "c.txt", "d.txt", "e.txt", "f.txt"));
            int[] fileSizes = new int[]{123, 234, 345, 456, 678, 789};
            Assertions.assertEquals((int)expectedFileNames.size(), (int)fileSizes.length);
            Collections.sort(expectedFileNames);
            Arrays.sort(fileSizes);
            for (int i = 0; i < fileSizes.length; ++i) {
                TestUtils.generateTestData(new File(subDir, (String)expectedFileNames.get(i)), (long)fileSizes[i]);
            }
            String subSubFileName = "z.txt";
            TestUtils.generateTestData(new File(subSubDir, "z.txt"), 1L);
            expectedFileNames.add("z.txt");
            String notSubSubFileName = "not.txt";
            TestUtils.generateTestData(new File(notSubSubDir, "not.txt"), 1L);
            WildcardFileFilter allFilesFileFilter = WildcardFileFilter.builder().setWildcards(new String[]{"*.*"}).get();
            NameFileFilter dirFilter = new NameFileFilter("subSubDir");
            iterator = FileUtils.iterateFiles((File)subDir, (IOFileFilter)allFilesFileFilter, (IOFileFilter)dirFilter);
            HashMap<String, String> matchedFileNames = new HashMap<String, String>();
            ArrayList<String> actualFileNames = new ArrayList<String>();
            while (iterator.hasNext()) {
                boolean found = false;
                String fileName = ((File)iterator.next()).getName();
                actualFileNames.add(fileName);
                for (int j = 0; !found && j < expectedFileNames.size(); ++j) {
                    String expectedFileName = (String)expectedFileNames.get(j);
                    if (!expectedFileName.equals(fileName)) continue;
                    matchedFileNames.put(expectedFileName, expectedFileName);
                    found = true;
                }
            }
            Assertions.assertEquals((int)expectedFileNames.size(), (int)matchedFileNames.size());
            Collections.sort(actualFileNames);
            Assertions.assertEquals(expectedFileNames, actualFileNames);
            this.consumeRemaining(iterator);
            notSubSubDir.delete();
        }
        catch (Throwable throwable) {
            this.consumeRemaining(iterator);
            notSubSubDir.delete();
            subSubDir.delete();
            subDir.delete();
            throw throwable;
        }
        subSubDir.delete();
        subDir.delete();
    }

    @Test
    void testIterateFilesAndDirs() throws IOException {
        File srcDir = this.tempDirFile;
        File subDir1 = new File(srcDir, "subdir1");
        File subDir2 = new File(subDir1, "subdir2");
        File subDir3 = new File(subDir2, "subdir3");
        File subDir4 = new File(subDir2, "subdir4");
        Assertions.assertTrue((boolean)subDir1.mkdir());
        Assertions.assertTrue((boolean)subDir2.mkdir());
        Assertions.assertTrue((boolean)subDir3.mkdir());
        Assertions.assertTrue((boolean)subDir4.mkdir());
        File someFile = new File(subDir2, "a.txt");
        WildcardFileFilter fileFilterAllFiles = WildcardFileFilter.builder().setWildcards(new String[]{"*.*"}).get();
        WildcardFileFilter fileFilterAllDirs = WildcardFileFilter.builder().setWildcards(new String[]{"*"}).get();
        WildcardFileFilter fileFilterExtTxt = WildcardFileFilter.builder().setWildcards(new String[]{"*.txt"}).get();
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(someFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 100L);
        }
        List<File> expectedFilesAndDirs = Arrays.asList(subDir1, subDir2, someFile, subDir3, subDir4);
        this.iterateFilesAndDirs(subDir1, (IOFileFilter)fileFilterAllFiles, (IOFileFilter)fileFilterAllDirs, expectedFilesAndDirs);
        expectedFilesAndDirs = Arrays.asList(subDir1, subDir2, someFile, subDir3, subDir4);
        this.iterateFilesAndDirs(subDir1, (IOFileFilter)fileFilterExtTxt, (IOFileFilter)fileFilterAllDirs, expectedFilesAndDirs);
        expectedFilesAndDirs = Arrays.asList(subDir1, subDir2, someFile);
        this.iterateFilesAndDirs(subDir1, (IOFileFilter)fileFilterAllFiles, (IOFileFilter)new NameFileFilter("subdir2"), expectedFilesAndDirs);
        expectedFilesAndDirs = Arrays.asList(subDir1, subDir2, someFile);
        this.iterateFilesAndDirs(subDir1, (IOFileFilter)fileFilterExtTxt, (IOFileFilter)new NameFileFilter("subdir2"), expectedFilesAndDirs);
    }

    @Test
    void testIterateFilesOnlyNoDirs() throws IOException {
        File directory = this.tempDirFile;
        Assertions.assertTrue((boolean)new File(directory, "TEST").mkdir());
        Assertions.assertTrue((boolean)new File(directory, "test.txt").createNewFile());
        WildcardFileFilter filter = WildcardFileFilter.builder().setWildcards(new String[]{"*"}).setIoCase(IOCase.INSENSITIVE).get();
        FileUtils.iterateFiles((File)directory, (IOFileFilter)filter, null).forEachRemaining(file -> Assertions.assertFalse((boolean)file.isDirectory(), file::getAbsolutePath));
    }

    @Test
    void testListFiles() throws Exception {
        File srcDir = this.tempDirFile;
        File subDir = new File(srcDir, "list_test");
        File subDir2 = new File(subDir, "subdir");
        subDir.mkdir();
        subDir2.mkdir();
        String[] expectedFileNames = new String[]{"a.txt", "b.txt", "c.txt", "d.txt", "e.txt", "f.txt"};
        int[] fileSizes = new int[]{123, 234, 345, 456, 678, 789};
        for (int i = 0; i < expectedFileNames.length; ++i) {
            File theFile = new File(subDir, expectedFileNames[i]);
            if (!theFile.getParentFile().exists()) {
                Assertions.fail((String)("Cannot create file " + theFile + " as the parent directory does not exist"));
            }
            try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(theFile.toPath(), new OpenOption[0]));){
                TestUtils.generateTestData(output, (long)fileSizes[i]);
                continue;
            }
        }
        Collection actualFiles = FileUtils.listFiles((File)subDir, (IOFileFilter)WildcardFileFilter.builder().setWildcards(new String[]{"*.*"}).get(), (IOFileFilter)WildcardFileFilter.builder().setWildcards(new String[]{"*"}).get());
        int count = actualFiles.size();
        Object[] fileObjs = actualFiles.toArray();
        Assertions.assertEquals((int)expectedFileNames.length, (int)actualFiles.size(), (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((Collection)actualFiles));
        HashMap<String, String> foundFileNames = new HashMap<String, String>();
        for (int i = 0; i < count; ++i) {
            boolean found = false;
            for (int j = 0; !found && j < expectedFileNames.length; ++j) {
                if (!expectedFileNames[j].equals(((File)fileObjs[i]).getName())) continue;
                foundFileNames.put(expectedFileNames[j], expectedFileNames[j]);
                found = true;
            }
        }
        Assertions.assertEquals((int)foundFileNames.size(), (int)expectedFileNames.length, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(foundFileNames));
    }

    @Test
    void testListFilesOnlyNoDirs() throws IOException {
        File directory = this.tempDirFile;
        Assertions.assertTrue((boolean)new File(directory, "TEST").mkdir());
        Assertions.assertTrue((boolean)new File(directory, "test.txt").createNewFile());
        WildcardFileFilter filter = WildcardFileFilter.builder().setWildcards(new String[]{"*"}).setIoCase(IOCase.INSENSITIVE).get();
        for (File file : FileUtils.listFiles((File)directory, (IOFileFilter)filter, null)) {
            Assertions.assertFalse((boolean)file.isDirectory(), file::getAbsolutePath);
        }
    }

    @Test
    void testListFilesWithDirs() throws IOException {
        File srcDir = this.tempDirFile;
        File subDir1 = new File(srcDir, "subdir");
        File subDir2 = new File(subDir1, "subdir2");
        subDir1.mkdir();
        subDir2.mkdir();
        File someFile = new File(subDir2, "a.txt");
        if (!someFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + someFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(someFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 100L);
        }
        File subDir3 = new File(subDir2, "subdir3");
        subDir3.mkdir();
        Collection files = FileUtils.listFilesAndDirs((File)subDir1, (IOFileFilter)WildcardFileFilter.builder().setWildcards(new String[]{"*.*"}).get(), (IOFileFilter)WildcardFileFilter.builder().setWildcards(new String[]{"*"}).get());
        Assertions.assertEquals((int)4, (int)files.size());
        Assertions.assertTrue((boolean)files.contains(subDir1), (String)"Should contain the directory.");
        Assertions.assertTrue((boolean)files.contains(subDir2), (String)"Should contain the directory.");
        Assertions.assertTrue((boolean)files.contains(someFile), (String)"Should contain the file.");
        Assertions.assertTrue((boolean)files.contains(subDir3), (String)"Should contain the directory.");
    }

    @Test
    void testMoveDirectory_CopyDelete() throws Exception {
        File dir = this.tempDirFile;
        File src = new File(dir, "testMoveDirectory2Source"){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean renameTo(File dest) {
                return false;
            }
        };
        File testDir = new File(src, "foo");
        File testFile = new File(testDir, "bar");
        testDir.mkdirs();
        if (!testFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        File destination = new File(dir, "testMoveDirectory1Dest");
        FileUtils.deleteDirectory((File)destination);
        FileUtils.moveDirectory((File)src, (File)destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
        File movedDir = new File(destination, testDir.getName());
        File movedFile = new File(movedDir, testFile.getName());
        Assertions.assertTrue((boolean)movedDir.exists(), (String)"Check dir moved");
        Assertions.assertTrue((boolean)movedFile.exists(), (String)"Check file moved");
    }

    @Test
    void testMoveDirectory_Errors() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveDirectory(null, (File)new File("foo")));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveDirectory((File)new File("foo"), null));
        Assertions.assertThrows(FileNotFoundException.class, () -> FileUtils.moveDirectory((File)new File("non-existent"), (File)new File("foo")));
        File testFile = new File(this.tempDirFile, "testMoveDirectoryFile");
        if (!testFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.moveDirectory((File)testFile, (File)new File("foo")));
        File testSrcFile = new File(this.tempDirFile, "testMoveDirectorySource");
        File testDestFile = new File(this.tempDirFile, "testMoveDirectoryDest");
        testSrcFile.mkdir();
        testDestFile.mkdir();
        Assertions.assertThrows(FileExistsException.class, () -> FileUtils.moveDirectory((File)testSrcFile, (File)testDestFile), (String)"Expected FileExistsException when dest already exists");
    }

    @Test
    void testMoveDirectoryRename() throws Exception {
        File dir = this.tempDirFile;
        File src = new File(dir, "testMoveDirectory1Source");
        File testDir = new File(src, "foo");
        File testFile = new File(testDir, "bar");
        testDir.mkdirs();
        if (!testFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        File destination = new File(dir, "testMoveDirectory1Dest");
        FileUtils.deleteDirectory((File)destination);
        FileUtils.moveDirectory((File)src, (File)destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
        File movedDir = new File(destination, testDir.getName());
        File movedFile = new File(movedDir, testFile.getName());
        Assertions.assertTrue((boolean)movedDir.exists(), (String)"Check dir moved");
        Assertions.assertTrue((boolean)movedFile.exists(), (String)"Check file moved");
    }

    @Test
    void testMoveDirectoryToDirectory() throws Exception {
        File dir = this.tempDirFile;
        File src = new File(dir, "testMoveDirectory1Source");
        File testChildDir = new File(src, "foo");
        File testFile = new File(testChildDir, "bar");
        testChildDir.mkdirs();
        if (!testFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        File destDir = new File(dir, "testMoveDirectory1Dest");
        FileUtils.deleteDirectory((File)destDir);
        Assertions.assertFalse((boolean)destDir.exists(), (String)"Check Exist before");
        FileUtils.moveDirectoryToDirectory((File)src, (File)destDir, (boolean)true);
        Assertions.assertTrue((boolean)destDir.exists(), (String)"Check Exist after");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
        File movedDir = new File(destDir, src.getName());
        File movedChildDir = new File(movedDir, testChildDir.getName());
        File movedFile = new File(movedChildDir, testFile.getName());
        Assertions.assertTrue((boolean)movedDir.exists(), (String)"Check dir moved");
        Assertions.assertTrue((boolean)movedChildDir.exists(), (String)"Check child dir moved");
        Assertions.assertTrue((boolean)movedFile.exists(), (String)"Check file moved");
    }

    @Test
    void testMoveDirectoryToDirectoryErrors() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveDirectoryToDirectory(null, (File)new File("foo"), (boolean)true));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveDirectoryToDirectory((File)new File("foo"), null, (boolean)true));
        File testFile1 = new File(this.tempDirFile, "testMoveFileFile1");
        File testFile2 = new File(this.tempDirFile, "testMoveFileFile2");
        if (!testFile1.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile1 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(testFile1.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 0L);
        }
        if (!testFile2.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile2 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile2.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        Assertions.assertThrows(IOException.class, () -> FileUtils.moveDirectoryToDirectory((File)testFile1, (File)testFile2, (boolean)true));
        File nonExistent = new File(this.tempDirFile, "testMoveFileNonExistent");
        Assertions.assertThrows(IOException.class, () -> FileUtils.moveDirectoryToDirectory((File)testFile1, (File)nonExistent, (boolean)false));
    }

    @Test
    void testMoveFile_CopyDelete() throws Exception {
        File destination = new File(this.tempDirFile, "move2.txt");
        File src = new File(this.testFile1.getAbsolutePath()){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean renameTo(File f) {
                return false;
            }
        };
        FileUtils.moveFile((File)src, (File)destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
    }

    @Test
    void testMoveFile_CopyDelete_Failed() {
        File destination = new File(this.tempDirFile, "move3.txt");
        File src = new File(this.testFile1.getAbsolutePath()){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean delete() {
                return false;
            }

            @Override
            public boolean renameTo(File f) {
                return false;
            }
        };
        Assertions.assertThrows(IOException.class, () -> FileUtils.moveFile((File)src, (File)destination));
        Assertions.assertFalse((boolean)destination.exists(), (String)"Check Rollback");
        Assertions.assertTrue((boolean)src.exists(), (String)"Original exists");
    }

    @Test
    void testMoveFile_CopyDelete_WithFileDatePreservation() throws Exception {
        File destination = new File(this.tempDirFile, "move2.txt");
        this.backDateFile10Minutes(this.testFile1);
        File src = new File(this.testFile1.getAbsolutePath()){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean renameTo(File f) {
                return false;
            }
        };
        long expected = this.getLastModifiedMillis(this.testFile1);
        FileUtils.moveFile((File)src, (File)destination, (CopyOption[])new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES});
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
        long destLastMod = this.getLastModifiedMillis(destination);
        long delta = destLastMod - expected;
        Assertions.assertEquals((long)expected, (long)destLastMod, (String)("Check last modified date same as input, delta " + delta));
    }

    @Test
    void testMoveFile_CopyDelete_WithoutFileDatePreservation() throws Exception {
        File destination = new File(this.tempDirFile, "move2.txt");
        this.backDateFile10Minutes(this.testFile1);
        long nowMillis = System.currentTimeMillis() - 1000L;
        File src = new File(this.testFile1.getAbsolutePath()){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean renameTo(File f) {
                return false;
            }
        };
        long unexpectedMillis = this.getLastModifiedMillis(this.testFile1);
        FileUtils.moveFile((File)src, (File)destination, (CopyOption[])PathUtils.EMPTY_COPY_OPTIONS);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
        if (!SystemUtils.IS_OS_WINDOWS) {
            long destLastModMillis = this.getLastModifiedMillis(destination);
            long deltaMillis = destLastModMillis - unexpectedMillis;
            Assertions.assertNotEquals((long)unexpectedMillis, (long)destLastModMillis, (String)("Check last modified date not same as input, delta " + deltaMillis));
            Assertions.assertTrue((destLastModMillis > nowMillis ? 1 : 0) != 0, (String)(destLastModMillis + " > " + nowMillis + " (delta " + deltaMillis + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testMoveFile_Errors() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveFile(null, (File)new File("foo")));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveFile((File)new File("foo"), null));
        Assertions.assertThrows(FileNotFoundException.class, () -> FileUtils.moveFile((File)new File("non-existent"), (File)new File("foo")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.moveFile((File)this.tempDirFile, (File)new File("foo")));
        File testSourceFile = new File(this.tempDirFile, "testMoveFileSource");
        File testDestFile = new File(this.tempDirFile, "testMoveFileSource");
        if (!testSourceFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testSourceFile + " as the parent directory does not exist"));
        }
        BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(testSourceFile.toPath(), new OpenOption[0]));
        try {
            TestUtils.generateTestData(output1, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output1);
        }
        Assertions.assertTrue((boolean)testDestFile.getParentFile().exists(), () -> "Cannot create file " + testDestFile + " as the parent directory does not exist");
        BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testDestFile.toPath(), new OpenOption[0]));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        Assertions.assertThrows(FileExistsException.class, () -> FileUtils.moveFile((File)testSourceFile, (File)testDestFile), (String)"Expected FileExistsException when dest already exists");
    }

    @Test
    void testMoveFile_Rename() throws Exception {
        File destination = new File(this.tempDirFile, "move1.txt");
        FileUtils.moveFile((File)this.testFile1, (File)destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)this.testFile1.exists(), (String)"Original deleted");
    }

    @Test
    void testMoveFileToDirectory() throws Exception {
        File destDir = new File(this.tempDirFile, "moveFileDestDir");
        File movedFile = new File(destDir, this.testFile1.getName());
        Assertions.assertFalse((boolean)destDir.exists(), (String)"Check Exist before");
        Assertions.assertFalse((boolean)movedFile.exists(), (String)"Check Exist before");
        FileUtils.moveFileToDirectory((File)this.testFile1, (File)destDir, (boolean)true);
        Assertions.assertTrue((boolean)movedFile.exists(), (String)"Check Exist after");
        Assertions.assertFalse((boolean)this.testFile1.exists(), (String)"Original deleted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testMoveFileToDirectoryErrors() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveFileToDirectory(null, (File)new File("foo"), (boolean)true));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveFileToDirectory((File)new File("foo"), null, (boolean)true));
        File testFile1 = new File(this.tempDirFile, "testMoveFileFile1");
        File testFile2 = new File(this.tempDirFile, "testMoveFileFile2");
        if (!testFile1.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile1 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(testFile1.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 0L);
        }
        if (!testFile2.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile2 + " as the parent directory does not exist"));
        }
        BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile2.toPath(), new OpenOption[0]));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.moveFileToDirectory((File)testFile1, (File)testFile2, (boolean)true));
        File nonExistent = new File(this.tempDirFile, "testMoveFileNonExistent");
        Assertions.assertThrows(IOException.class, () -> FileUtils.moveFileToDirectory((File)testFile1, (File)nonExistent, (boolean)false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testMoveToDirectory() throws Exception {
        File destDir = new File(this.tempDirFile, "testMoveToDirectoryDestDir");
        File testDir = new File(this.tempDirFile, "testMoveToDirectoryTestDir");
        File testFile = new File(this.tempDirFile, "testMoveToDirectoryTestFile");
        testDir.mkdirs();
        if (!testFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile + " as the parent directory does not exist"));
        }
        BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile.toPath(), new OpenOption[0]));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        File movedFile = new File(destDir, testFile.getName());
        File movedDir = new File(destDir, testFile.getName());
        Assertions.assertFalse((boolean)movedFile.exists(), (String)"Check File Doesnt exist");
        Assertions.assertFalse((boolean)movedDir.exists(), (String)"Check Dir Doesnt exist");
        FileUtils.moveToDirectory((File)testFile, (File)destDir, (boolean)true);
        Assertions.assertTrue((boolean)movedFile.exists(), (String)"Check File exists");
        Assertions.assertFalse((boolean)testFile.exists(), (String)"Check Original File doesn't exist");
        FileUtils.moveToDirectory((File)testDir, (File)destDir, (boolean)true);
        Assertions.assertTrue((boolean)movedDir.exists(), (String)"Check Dir exists");
        Assertions.assertFalse((boolean)testDir.exists(), (String)"Check Original Dir doesn't exist");
    }

    @Test
    void testMoveToDirectory_Errors() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveDirectoryToDirectory(null, (File)new File("foo"), (boolean)true));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveDirectoryToDirectory((File)new File("foo"), null, (boolean)true));
        File nonExistent = new File(this.tempDirFile, "non-existent");
        File destDir = new File(this.tempDirFile, "MoveToDirectoryDestDir");
        Assertions.assertThrows(IOException.class, () -> FileUtils.moveToDirectory((File)nonExistent, (File)destDir, (boolean)true), (String)"Expected IOException when source does not exist");
    }

    @Test
    void testOpenInputStream_exists() throws Exception {
        File file = new File(this.tempDirFile, "test.txt");
        TestUtils.createLineFileUtf8(file, new String[]{"Hello"});
        try (FileInputStream in = FileUtils.openInputStream((File)file);){
            Assertions.assertEquals((int)72, (int)in.read());
        }
    }

    @Test
    void testOpenInputStream_existsButIsDirectory() {
        File directory = new File(this.tempDirFile, "subdir");
        directory.mkdirs();
        Assertions.assertThrows(IOException.class, () -> FileUtils.openInputStream((File)directory));
    }

    @Test
    void testOpenInputStream_notExists() {
        File directory = new File(this.tempDirFile, "test.txt");
        Assertions.assertThrows(IOException.class, () -> FileUtils.openInputStream((File)directory));
    }

    @Test
    void testOpenOutputStream_exists() throws Exception {
        File file = new File(this.tempDirFile, "test.txt");
        TestUtils.createLineFileUtf8(file, new String[]{"Hello"});
        try (FileOutputStream out = FileUtils.openOutputStream((File)file);){
            out.write(0);
        }
        Assertions.assertTrue((boolean)file.exists());
    }

    @Test
    void testOpenOutputStream_existsButIsDirectory() {
        File directory = new File(this.tempDirFile, "subdir");
        directory.mkdirs();
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.openOutputStream((File)directory));
    }

    @Test
    void testOpenOutputStream_intoExistingSymlinkedDir() throws Exception {
        Path symlinkedDir = (Path)this.createTempSymbolicLinkedRelativeDir().getLeft();
        File file = symlinkedDir.resolve("test.txt").toFile();
        try (FileOutputStream out = FileUtils.openOutputStream((File)file);){
            out.write(0);
        }
        Assertions.assertTrue((boolean)file.exists());
    }

    @Test
    void testOpenOutputStream_noParentCreateFile() throws Exception {
        this.openOutputStream_noParent(true);
    }

    @Test
    void testOpenOutputStream_noParentNoFile() throws Exception {
        this.openOutputStream_noParent(false);
    }

    @Test
    void testOpenOutputStream_notExists() throws Exception {
        File file = new File(this.tempDirFile, "a/test.txt");
        try (FileOutputStream out = FileUtils.openOutputStream((File)file);){
            out.write(0);
        }
        Assertions.assertTrue((boolean)file.exists());
    }

    @Test
    void testOpenOutputStream_notExistsCannotCreate() {
        String longStr = "abcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyz";
        File file = new File(this.tempDirFile, "a/abcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyz/test.txt");
        Assertions.assertThrows(IOException.class, () -> FileUtils.openOutputStream((File)file));
    }

    @Test
    void testReadFileToByteArray() throws Exception {
        File file = new File(this.tempDirFile, "read.txt");
        Files.write(file.toPath(), new byte[]{11, 21, 31}, new OpenOption[0]);
        byte[] data = FileUtils.readFileToByteArray((File)file);
        Assertions.assertEquals((int)3, (int)data.length);
        Assertions.assertEquals((int)11, (int)data[0]);
        Assertions.assertEquals((int)21, (int)data[1]);
        Assertions.assertEquals((int)31, (int)data[2]);
    }

    @Test
    void testReadFileToByteArray_Errors() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.readFileToByteArray(null));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readFileToByteArray((File)new File("non-exsistent")));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readFileToByteArray((File)this.tempDirFile));
    }

    @Test
    @EnabledIf(value="isPosixFilePermissionsSupported")
    void testReadFileToByteArray_IOExceptionOnPosixFileSystem() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "cant-read.txt");
        TestUtils.createFile(file, 100L);
        Files.setPosixFilePermissions(file.toPath(), PosixFilePermissions.fromString("---------"));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readFileToByteArray((File)file));
    }

    @Test
    void testReadFileToString_Errors() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.readFileToString(null));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readFileToString((File)new File("non-exsistent")));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readFileToString((File)this.tempDirFile));
        Assertions.assertThrows(UnsupportedCharsetException.class, () -> FileUtils.readFileToString((File)this.tempDirFile, (String)"unsupported-charset"));
    }

    @Test
    @EnabledIf(value="isPosixFilePermissionsSupported")
    void testReadFileToString_IOExceptionOnPosixFileSystem() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "cant-read.txt");
        TestUtils.createFile(file, 100L);
        Files.setPosixFilePermissions(file.toPath(), PosixFilePermissions.fromString("---------"));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readFileToString((File)file));
    }

    @Test
    void testReadFileToStringWithDefaultEncoding() throws Exception {
        File file = new File(this.tempDirFile, "read.obj");
        String fixture = "Hello 1234";
        Files.write(file.toPath(), "Hello 1234".getBytes(), new OpenOption[0]);
        Assertions.assertEquals((Object)"Hello 1234", (Object)FileUtils.readFileToString((File)file));
    }

    @Test
    void testReadFileToStringWithEncoding() throws Exception {
        File file = new File(this.tempDirFile, "read.obj");
        byte[] text = "Hello \u1234".getBytes(StandardCharsets.UTF_8);
        Files.write(file.toPath(), text, new OpenOption[0]);
        String data = FileUtils.readFileToString((File)file, (String)"UTF8");
        Assertions.assertEquals((Object)"Hello \u1234", (Object)data);
    }

    @Test
    @EnabledIf(value="isPosixFilePermissionsSupported")
    void testReadLines_IOExceptionOnPosixFileSystem() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "cant-read.txt");
        TestUtils.createFile(file, 100L);
        Files.setPosixFilePermissions(file.toPath(), PosixFilePermissions.fromString("---------"));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readLines((File)file));
    }

    @Test
    void testReadLinesDefaults() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        String[] data = new String[]{"hello", "this is", "some text"};
        TestUtils.createLineFileUtf8(file, data);
        List lines1 = FileUtils.readLines((File)file);
        List lines2 = FileUtils.readLines((File)file, (Charset)null);
        List lines3 = FileUtils.readLines((File)file, (Charset)Charset.defaultCharset());
        Assertions.assertEquals((Object)lines1, Arrays.asList(data));
        Assertions.assertEquals((Object)lines1, (Object)lines2);
        Assertions.assertEquals((Object)lines1, (Object)lines3);
    }

    @Test
    void testReadLinesErrors() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.readLines(null));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readLines((File)new File("non-exsistent")));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readLines((File)this.tempDirFile));
        Assertions.assertThrows(UnsupportedCharsetException.class, () -> FileUtils.readLines((File)this.tempDirFile, (String)"unsupported-charset"));
    }

    @Test
    void testReadLinesUTF8() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        String[] data = new String[]{"hello", "\u1234", "", "this is", "some text"};
        TestUtils.createLineFileUtf8(file, data);
        List lines = FileUtils.readLines((File)file, (String)UTF_8);
        Assertions.assertEquals(Arrays.asList(data), (Object)lines);
    }

    @Test
    void testSizeOf() throws Exception {
        File file = new File(this.tempDirFile, this.getName());
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.sizeOf(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.sizeOf((File)file));
        file.createNewFile();
        Assertions.assertEquals((long)0L, (long)FileUtils.sizeOf((File)file));
        file.delete();
        Assertions.assertEquals((long)this.testFile1Size, (long)FileUtils.sizeOf((File)this.testFile1), (String)"Unexpected files size");
        Assertions.assertEquals((long)0L, (long)FileUtils.sizeOf((File)this.tempDirFile), (String)"Unexpected directory size");
    }

    @Test
    void testSizeOfAsBigInteger() throws Exception {
        File file = new File(this.tempDirFile, this.getName());
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.sizeOfAsBigInteger(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.sizeOfAsBigInteger((File)file));
        file.createNewFile();
        Assertions.assertEquals((Object)BigInteger.ZERO, (Object)FileUtils.sizeOfAsBigInteger((File)file));
        file.delete();
        Assertions.assertEquals((Object)BigInteger.valueOf(this.testFile1Size), (Object)FileUtils.sizeOfAsBigInteger((File)this.testFile1), (String)"Unexpected files size");
        Assertions.assertEquals((Object)TEST_DIRECTORY_SIZE_BI, (Object)FileUtils.sizeOfAsBigInteger((File)this.tempDirFile), (String)"Unexpected directory size");
    }

    @Test
    void testSizeOfDirectory() throws Exception {
        File file = new File(this.tempDirFile, this.getName());
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.sizeOfDirectory(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.sizeOfAsBigInteger((File)file));
        file.createNewFile();
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.sizeOfDirectory((File)file));
        file.delete();
        file.mkdir();
        this.createCircularSymbolicLink(file);
        Assertions.assertEquals((long)0L, (long)FileUtils.sizeOfDirectory((File)file), (String)"Unexpected directory size");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSizeOfDirectoryAsBigInteger() throws Exception {
        File file = new File(this.tempDirFile, this.getName());
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.sizeOfDirectoryAsBigInteger(null));
        Assertions.assertThrows(UncheckedIOException.class, () -> FileUtils.sizeOfDirectoryAsBigInteger((File)file));
        file.createNewFile();
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.sizeOfDirectoryAsBigInteger((File)file));
        file.delete();
        file.mkdir();
        this.createCircularSymbolicLink(file);
        Assertions.assertEquals((Object)TEST_DIRECTORY_SIZE_BI, (Object)FileUtils.sizeOfDirectoryAsBigInteger((File)file), (String)"Unexpected directory size");
        file.delete();
        file.mkdir();
        File nonEmptyFile = new File(file, "non-emptyFile" + System.nanoTime());
        Assertions.assertTrue((boolean)nonEmptyFile.getParentFile().exists(), () -> "Cannot create file " + nonEmptyFile + " as the parent directory does not exist");
        BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(nonEmptyFile.toPath(), new OpenOption[0]));
        try {
            TestUtils.generateTestData(output, TEST_DIRECTORY_SIZE_GT_ZERO_BI.longValue());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        Assertions.assertEquals((Object)TEST_DIRECTORY_SIZE_GT_ZERO_BI, (Object)FileUtils.sizeOfDirectoryAsBigInteger((File)file), (String)"Unexpected directory size");
        nonEmptyFile.delete();
        file.delete();
    }

    @Test
    void testToFile1() throws Exception {
        URL url = new URL("file", null, "a/b/c/file.txt");
        File file = FileUtils.toFile((URL)url);
        Assertions.assertTrue((boolean)file.toString().contains("file.txt"));
    }

    @Test
    void testToFile2() throws Exception {
        URL url = new URL("file", null, "a/b/c/file%20n%61me%2520.tx%74");
        File file = FileUtils.toFile((URL)url);
        Assertions.assertTrue((boolean)file.toString().contains("file name%20.txt"));
    }

    @Test
    void testToFile3() throws Exception {
        Assertions.assertNull((Object)FileUtils.toFile(null));
        Assertions.assertNull((Object)FileUtils.toFile((URL)new URL("http://jakarta.apache.org")));
    }

    @Test
    void testToFile4() throws Exception {
        URL url = new URL("file", null, "a/b/c/file%%20%me.txt%");
        File file = FileUtils.toFile((URL)url);
        Assertions.assertTrue((boolean)file.toString().contains("file% %me.txt%"));
    }

    @Test
    void testToFile5() throws Exception {
        URL url = new URL("file", null, "both%20are%20100%20%25%20true");
        File file = FileUtils.toFile((URL)url);
        Assertions.assertEquals((Object)"both are 100 % true", (Object)file.toString());
    }

    @Test
    void testToFiles1() throws Exception {
        URL[] urls = new URL[]{new URL("file", null, "file1.txt"), new URL("file", null, "file2.txt")};
        File[] files = FileUtils.toFiles((URL[])urls);
        Assertions.assertEquals((int)urls.length, (int)files.length);
        Assertions.assertTrue((boolean)files[0].toString().contains("file1.txt"), (String)("File: " + files[0]));
        Assertions.assertTrue((boolean)files[1].toString().contains("file2.txt"), (String)("File: " + files[1]));
    }

    @Test
    void testToFiles2() throws Exception {
        URL[] urls = new URL[]{new URL("file", null, "file1.txt"), null};
        File[] files = FileUtils.toFiles((URL[])urls);
        Assertions.assertEquals((int)urls.length, (int)files.length);
        Assertions.assertTrue((boolean)files[0].toString().contains("file1.txt"), (String)("File: " + files[0]));
        Assertions.assertNull((Object)files[1], (String)("File: " + files[1]));
    }

    @Test
    void testToFiles3() throws Exception {
        URL[] urls = null;
        File[] files = FileUtils.toFiles(urls);
        Assertions.assertEquals((int)0, (int)files.length);
    }

    @Test
    void testToFiles3a() throws Exception {
        URL[] urls = new URL[]{};
        File[] files = FileUtils.toFiles((URL[])urls);
        Assertions.assertEquals((int)0, (int)files.length);
    }

    @Test
    void testToFiles4() throws Exception {
        URL[] urls = new URL[]{new URL("file", null, "file1.txt"), new URL("http", "jakarta.apache.org", "file1.txt")};
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.toFiles((URL[])urls));
    }

    @Test
    void testToFileUtf8() throws Exception {
        URL url = new URL("file", null, "/home/%C3%A4%C3%B6%C3%BC%C3%9F");
        File file = FileUtils.toFile((URL)url);
        Assertions.assertTrue((boolean)file.toString().contains("\u00e4\u00f6\u00fc\u00df"));
    }

    @Test
    void testTouch() throws IOException {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.touch(null));
        File file = new File(this.tempDirFile, "touch.txt");
        if (file.exists()) {
            file.delete();
        }
        Assertions.assertFalse((boolean)file.exists(), (String)"Bad test: test file still exists");
        FileUtils.touch((File)file);
        Assertions.assertTrue((boolean)file.exists(), (String)"FileUtils.touch() created file");
        try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            Assertions.assertEquals((long)0L, (long)file.length(), (String)"Created empty file.");
            out.write(0);
        }
        Assertions.assertEquals((long)1L, (long)file.length(), (String)"Wrote one byte to file");
        long y2k = new GregorianCalendar(2000, 0, 1).getTime().getTime();
        boolean res = this.setLastModifiedMillis(file, y2k);
        Assertions.assertTrue((boolean)res, (String)"Bad test: set lastModified failed");
        Assertions.assertEquals((long)y2k, (long)this.getLastModifiedMillis(file), (String)"Bad test: set lastModified set incorrect value");
        long nowMillis = System.currentTimeMillis();
        FileUtils.touch((File)file);
        Assertions.assertEquals((long)1L, (long)file.length(), (String)"FileUtils.touch() didn't empty the file.");
        Assertions.assertNotEquals((long)y2k, (long)this.getLastModifiedMillis(file), (String)"FileUtils.touch() changed lastModified");
        int delta = 3000;
        Assertions.assertTrue((this.getLastModifiedMillis(file) >= nowMillis - 3000L ? 1 : 0) != 0, (String)"FileUtils.touch() changed lastModified to more than now-3s");
        Assertions.assertTrue((this.getLastModifiedMillis(file) <= nowMillis + 3000L ? 1 : 0) != 0, (String)"FileUtils.touch() changed lastModified to less than now+3s");
    }

    @Test
    void testTouchDirDoesNotExist() throws Exception {
        File file = new File("target/does-not-exist", "touchme.txt");
        File parentDir = file.getParentFile();
        file.delete();
        parentDir.delete();
        Assertions.assertFalse((boolean)parentDir.exists());
        Assertions.assertFalse((boolean)file.exists());
        FileUtils.touch((File)file);
        Assertions.assertTrue((boolean)parentDir.exists());
        Assertions.assertTrue((boolean)file.exists());
    }

    @Test
    void testToURLs1() throws Exception {
        File[] files = new File[]{new File(this.tempDirFile, "file1.txt"), new File(this.tempDirFile, "file2.txt"), new File(this.tempDirFile, "test file.txt")};
        URL[] urls = FileUtils.toURLs((File[])files);
        Assertions.assertEquals((int)files.length, (int)urls.length);
        Assertions.assertTrue((boolean)urls[0].toExternalForm().startsWith("file:"));
        Assertions.assertTrue((boolean)urls[0].toExternalForm().contains("file1.txt"));
        Assertions.assertTrue((boolean)urls[1].toExternalForm().startsWith("file:"));
        Assertions.assertTrue((boolean)urls[1].toExternalForm().contains("file2.txt"));
        Assertions.assertTrue((boolean)urls[2].toExternalForm().startsWith("file:"));
        Assertions.assertTrue((boolean)urls[2].toExternalForm().contains("test%20file.txt"));
    }

    @Test
    void testToURLs2() {
        File[] files = new File[]{new File(this.tempDirFile, "file1.txt"), null};
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.toURLs((File[])files), (String)"Can't convert null URL");
    }

    @Test
    void testToURLs3() {
        File[] files = null;
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.toURLs((File[])files), (String)"Can't convert null list");
    }

    @Test
    void testToURLs3a() throws Exception {
        File[] files = new File[]{};
        URL[] urls = FileUtils.toURLs((File[])files);
        Assertions.assertEquals((int)0, (int)urls.length);
    }

    @Test
    void testWrite_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.write((File)file, (CharSequence)"this is brand new data", (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    void testWrite_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.write((File)file, (CharSequence)"this is brand new data", (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    @Test
    void testWriteByteArrayToFile() throws Exception {
        File file = new File(this.tempDirFile, "write.obj");
        byte[] data = new byte[]{11, 21, 31};
        FileUtils.writeByteArrayToFile((File)file, (byte[])data);
        TestUtils.assertEqualContent(data, file);
    }

    @Test
    void testWriteByteArrayToFile_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeByteArrayToFile((File)file, (byte[])"this is brand new data".getBytes(), (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    void testWriteByteArrayToFile_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeByteArrayToFile((File)file, (byte[])"this is brand new data".getBytes(), (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    @Test
    void testWriteByteArrayToFile_WithOffsetAndLength() throws Exception {
        File file = new File(this.tempDirFile, "write.obj");
        byte[] data = new byte[]{11, 21, 32, 41, 51};
        byte[] writtenData = new byte[3];
        System.arraycopy(data, 1, writtenData, 0, 3);
        FileUtils.writeByteArrayToFile((File)file, (byte[])data, (int)1, (int)3);
        TestUtils.assertEqualContent(writtenData, file);
    }

    @Test
    void testWriteByteArrayToFile_WithOffsetAndLength_WithAppendOptionTrue_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        byte[] data = "SKIP_THIS_this is brand new data_AND_SKIP_THIS".getBytes(StandardCharsets.UTF_8);
        FileUtils.writeByteArrayToFile((File)file, (byte[])data, (int)10, (int)22, (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    void testWriteByteArrayToFile_WithOffsetAndLength_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        byte[] data = "SKIP_THIS_this is brand new data_AND_SKIP_THIS".getBytes(StandardCharsets.UTF_8);
        FileUtils.writeByteArrayToFile((File)file, (byte[])data, (int)10, (int)22, (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    @Test
    void testWriteCharSequence1() throws Exception {
        File file = new File(this.tempDirFile, "write.txt");
        FileUtils.write((File)file, (CharSequence)"Hello \u1234", (String)"UTF8");
        byte[] text = "Hello \u1234".getBytes(StandardCharsets.UTF_8);
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    void testWriteCharSequence2() throws Exception {
        File file = new File(this.tempDirFile, "write.txt");
        FileUtils.write((File)file, (CharSequence)"Hello \u1234", (String)null);
        byte[] text = "Hello \u1234".getBytes();
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    void testWriteLines_3arg_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeLines((File)file, (String)StandardCharsets.US_ASCII.name(), list);
        String expected = "hello" + System.lineSeparator() + "world" + System.lineSeparator() + System.lineSeparator() + "this is" + System.lineSeparator() + System.lineSeparator() + "some text" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file, (String)StandardCharsets.US_ASCII.name());
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testWriteLines_3argsWithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...", (Charset)StandardCharsets.UTF_8);
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, linesToAppend, (boolean)false);
        String expected = "my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testWriteLines_3argsWithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...", (Charset)StandardCharsets.UTF_8);
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, linesToAppend, (boolean)true);
        String expected = "This line was there before you...my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testWriteLines_4arg() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeLines((File)file, (String)StandardCharsets.US_ASCII.name(), list, (String)"*");
        String expected = "hello*world**this is**some text*";
        String actual = FileUtils.readFileToString((File)file, (String)StandardCharsets.US_ASCII.name());
        Assertions.assertEquals((Object)"hello*world**this is**some text*", (Object)actual);
    }

    @Test
    void testWriteLines_4arg_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeLines((File)file, (String)StandardCharsets.US_ASCII.name(), list, null);
        String expected = "hello" + System.lineSeparator() + "world" + System.lineSeparator() + System.lineSeparator() + "this is" + System.lineSeparator() + System.lineSeparator() + "some text" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file, (String)StandardCharsets.US_ASCII.name());
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testWriteLines_4arg_Writer_nullData() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeLines((File)file, (String)StandardCharsets.US_ASCII.name(), null, (String)"*");
        Assertions.assertEquals((long)0L, (long)file.length(), (String)"Sizes differ");
    }

    @Test
    void testWriteLines_4argsWithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, linesToAppend, null, (boolean)false);
        String expected = "my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testWriteLines_4argsWithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, linesToAppend, null, (boolean)true);
        String expected = "This line was there before you...my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testWriteLines_5argsWithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, null, linesToAppend, null, (boolean)false);
        String expected = "my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testWriteLines_5argsWithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, null, linesToAppend, null, (boolean)true);
        String expected = "This line was there before you...my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testWriteLinesEncoding_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, null, linesToAppend, (boolean)false);
        String expected = "my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testWriteLinesEncoding_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, null, linesToAppend, (boolean)true);
        String expected = "This line was there before you...my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testWriteStringToFile_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeStringToFile((File)file, (String)"this is brand new data", (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    void testWriteStringToFile_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeStringToFile((File)file, (String)"this is brand new data", (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    @Test
    void testWriteStringToFileIntoNonExistentSubdir() throws Exception {
        File file = new File(this.tempDirFile, "subdir/write.txt");
        FileUtils.writeStringToFile((File)file, (String)"Hello \u1234", (Charset)null);
        byte[] text = "Hello \u1234".getBytes();
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    void testWriteStringToFileIntoSymlinkedDir() throws Exception {
        Path symlinkDir = (Path)this.createTempSymbolicLinkedRelativeDir().getLeft();
        File file = symlinkDir.resolve("file").toFile();
        FileUtils.writeStringToFile((File)file, (String)"Hello \u1234", (Charset)StandardCharsets.UTF_8);
        byte[] text = "Hello \u1234".getBytes(StandardCharsets.UTF_8);
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    void testWriteStringToFileWithCharset() throws Exception {
        File file = new File(this.tempDirFile, "write.txt");
        FileUtils.writeStringToFile((File)file, (String)"Hello \u1234", (String)"UTF8");
        byte[] text = "Hello \u1234".getBytes(StandardCharsets.UTF_8);
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    void testWriteStringToFileWithEncoding_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeStringToFile((File)file, (String)"this is brand new data", (String)null, (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    void testWriteStringToFileWithEncoding_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeStringToFile((File)file, (String)"this is brand new data", (String)null, (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    @Test
    void testWriteStringToFileWithNullCharset() throws Exception {
        File file = new File(this.tempDirFile, "write.txt");
        FileUtils.writeStringToFile((File)file, (String)"Hello \u1234", (Charset)null);
        byte[] text = "Hello \u1234".getBytes();
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    void testWriteStringToFileWithNullStringCharset() throws Exception {
        File file = new File(this.tempDirFile, "write.txt");
        FileUtils.writeStringToFile((File)file, (String)"Hello \u1234", (String)null);
        byte[] text = "Hello \u1234".getBytes();
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    void testWriteWithEncoding_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...", (Charset)StandardCharsets.UTF_8);
        FileUtils.write((File)file, (CharSequence)"this is brand new data", (String)null, (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    void testWriteWithEncoding_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...", (Charset)StandardCharsets.UTF_8);
        FileUtils.write((File)file, (CharSequence)"this is brand new data", (String)null, (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    static class ListDirectoryWalker
    extends DirectoryWalker<File> {
        ListDirectoryWalker() {
        }

        protected void handleDirectoryStart(File directory, int depth, Collection<File> results) throws IOException {
            if (depth > 0) {
                results.add(directory);
            }
        }

        protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
            results.add(file);
        }

        List<File> list(File startDirectory) throws IOException {
            ArrayList<File> files = new ArrayList<File>();
            this.walk(startDirectory, files);
            return files;
        }
    }
}

