/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rt.security.claims.Claim;
import org.apache.cxf.sts.claims.ClaimsParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IdentityClaimsParser
implements ClaimsParser {
    public static final String IDENTITY_CLAIMS_DIALECT = "http://schemas.xmlsoap.org/ws/2005/05/identity";
    private static final Logger LOG = LogUtils.getL7dLogger(IdentityClaimsParser.class);

    @Override
    public Claim parse(Element claim) {
        return IdentityClaimsParser.parseClaimType(claim);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Claim parseClaimType(Element claimType) {
        String claimLocalName = claimType.getLocalName();
        String claimNS = claimType.getNamespaceURI();
        if (!"ClaimType".equals(claimLocalName) && !"ClaimValue".equals(claimLocalName)) {
            LOG.fine("Found unknown element: " + claimLocalName + " " + claimNS);
            return null;
        }
        String claimTypeUri = claimType.getAttributeNS(null, "Uri");
        String claimTypeOptional = claimType.getAttributeNS(null, "Optional");
        Claim requestClaim = new Claim();
        try {
            requestClaim.setClaimType(new URI(claimTypeUri));
        }
        catch (URISyntaxException e) {
            LOG.log(Level.WARNING, "Cannot create URI from the given ClaimType attribute value " + claimTypeUri, e);
        }
        requestClaim.setOptional(Boolean.parseBoolean(claimTypeOptional));
        if (!"ClaimValue".equals(claimLocalName)) return requestClaim;
        Node valueNode = claimType.getFirstChild();
        if (valueNode == null) {
            LOG.warning("No child element of ClaimValue element available");
            return null;
        }
        if ("Value".equals(valueNode.getLocalName())) {
            requestClaim.addValue((Object)valueNode.getTextContent().trim());
            return requestClaim;
        }
        LOG.warning("Unsupported child element of ClaimValue element " + valueNode.getLocalName());
        return null;
    }

    @Override
    public String getSupportedDialect() {
        return IDENTITY_CLAIMS_DIALECT;
    }
}

