/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Arrays;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.replication.ReplicationManager;

public class ReplicationAddTXMessage
extends PacketImpl {
    private long txId;
    private long id;
    private byte journalID;
    private byte recordType;
    private Persister persister;
    private Object encodingData;
    private byte[] recordData;
    private ReplicationManager.ADD_OPERATION_TYPE operation;
    private final boolean beforeTwoEighteen;

    public ReplicationAddTXMessage(boolean beforeTwoEighteen) {
        super((byte)92);
        this.beforeTwoEighteen = beforeTwoEighteen;
    }

    public ReplicationAddTXMessage(boolean beforeTwoEighteen, byte journalID, ReplicationManager.ADD_OPERATION_TYPE operation, long txId, long id, byte recordType, Persister persister, Object encodingData) {
        this(beforeTwoEighteen);
        this.journalID = journalID;
        this.operation = operation;
        this.txId = txId;
        this.id = id;
        this.recordType = recordType;
        this.encodingData = encodingData;
        this.persister = persister;
    }

    public int expectedEncodeSize() {
        return 36 + this.persister.getEncodeSize(this.encodingData);
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeByte(this.journalID);
        if (this.beforeTwoEighteen) {
            buffer.writeBoolean(this.operation == ReplicationManager.ADD_OPERATION_TYPE.UPDATE);
        } else {
            buffer.writeByte(this.operation.toRecord());
        }
        buffer.writeLong(this.txId);
        buffer.writeLong(this.id);
        buffer.writeByte(this.recordType);
        buffer.writeInt(this.persister.getEncodeSize(this.encodingData));
        this.persister.encode(buffer, this.encodingData);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        boolean isUpdate;
        this.journalID = buffer.readByte();
        this.operation = this.beforeTwoEighteen ? ((isUpdate = buffer.readBoolean()) ? ReplicationManager.ADD_OPERATION_TYPE.UPDATE : ReplicationManager.ADD_OPERATION_TYPE.ADD) : ReplicationManager.ADD_OPERATION_TYPE.toOperation(buffer.readByte());
        this.txId = buffer.readLong();
        this.id = buffer.readLong();
        this.recordType = buffer.readByte();
        int recordDataSize = buffer.readInt();
        this.recordData = new byte[recordDataSize];
        buffer.readBytes(this.recordData);
    }

    public long getId() {
        return this.id;
    }

    public long getTxId() {
        return this.txId;
    }

    public byte getJournalID() {
        return this.journalID;
    }

    public ReplicationManager.ADD_OPERATION_TYPE getOperation() {
        return this.operation;
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public byte[] getRecordData() {
        return this.recordData;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.encodingData, this.id, this.journalID, this.operation, Arrays.hashCode(this.recordData), this.recordType, this.txId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationAddTXMessage)) {
            return false;
        }
        ReplicationAddTXMessage other = (ReplicationAddTXMessage)((Object)obj);
        return Objects.equals(this.encodingData, other.encodingData) && this.id == other.id && this.journalID == other.journalID && this.operation == other.operation && Arrays.equals(this.recordData, other.recordData) && this.recordType == other.recordType && this.txId == other.txId;
    }
}

