/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.action;

import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.EncryptionActionToken;
import org.apache.wss4j.common.SecurityActionToken;
import org.apache.wss4j.common.SignatureActionToken;
import org.apache.wss4j.common.SignatureEncryptionActionToken;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.action.AbstractDerivedAction;
import org.apache.wss4j.dom.action.Action;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandler;
import org.apache.wss4j.dom.message.WSSecDKEncrypt;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptionDerivedAction
extends AbstractDerivedAction
implements Action {
    @Override
    public void execute(WSHandler handler, SecurityActionToken actionToken, RequestData reqData) throws WSSecurityException {
        CallbackHandler callbackHandler = reqData.getCallbackHandler();
        if (callbackHandler == null) {
            callbackHandler = handler.getPasswordCallbackHandler(reqData);
        }
        EncryptionActionToken encryptionToken = null;
        if (actionToken instanceof EncryptionActionToken) {
            encryptionToken = (EncryptionActionToken)actionToken;
        }
        if (encryptionToken == null) {
            encryptionToken = reqData.getEncryptionToken();
        }
        WSPasswordCallback passwordCallback = handler.getPasswordCB(encryptionToken.getUser(), 65536, callbackHandler, reqData);
        WSSecDKEncrypt wsEncrypt = new WSSecDKEncrypt(reqData.getSecHeader());
        wsEncrypt.setIdAllocator(reqData.getWssConfig().getIdAllocator());
        wsEncrypt.setWsDocInfo(reqData.getWsDocInfo());
        wsEncrypt.setExpandXopInclude(reqData.isExpandXopInclude());
        if (encryptionToken.getKeyIdentifierId() != 0) {
            wsEncrypt.setKeyIdentifierType(encryptionToken.getKeyIdentifierId());
        }
        if (encryptionToken.getSymmetricAlgorithm() != null) {
            wsEncrypt.setSymmetricEncAlgorithm(encryptionToken.getSymmetricAlgorithm());
        }
        wsEncrypt.setUserInfo(encryptionToken.getUser(), passwordCallback.getPassword());
        if (reqData.isUse200512Namespace()) {
            wsEncrypt.setWscVersion(2);
        } else {
            wsEncrypt.setWscVersion(1);
        }
        if (encryptionToken.getDerivedKeyLength() > 0) {
            wsEncrypt.setDerivedKeyLength(encryptionToken.getDerivedKeyLength());
        }
        Document doc = reqData.getSecHeader().getSecurityHeaderElement().getOwnerDocument();
        String derivedKeyTokenReference = encryptionToken.getDerivedKeyTokenReference();
        Element tokenElement = null;
        SecretKey symmetricKey = null;
        if ("EncryptedKey".equals(derivedKeyTokenReference)) {
            if (reqData.getSignatureToken() == null || reqData.getSignatureToken().getKey() == null || reqData.getSignatureToken().getKeyIdentifier() == null) {
                String symmetricKeyAlgorithm = encryptionToken.getSymmetricAlgorithm();
                if (symmetricKeyAlgorithm == null) {
                    symmetricKeyAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
                }
                KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)symmetricKeyAlgorithm);
                symmetricKey = keyGen.generateKey();
            }
            tokenElement = this.setupEncryptedKeyTokenReference(reqData, encryptionToken, wsEncrypt, passwordCallback, doc, symmetricKey);
        } else if ("SecurityContextToken".equals(derivedKeyTokenReference)) {
            tokenElement = this.setupSCTTokenReference(reqData, encryptionToken, wsEncrypt, passwordCallback, doc);
        }
        wsEncrypt.setAttachmentCallbackHandler(reqData.getAttachmentCallbackHandler());
        wsEncrypt.setStoreBytesInAttachment(reqData.isStoreBytesInAttachment());
        try {
            List parts = encryptionToken.getParts();
            if (parts != null && !parts.isEmpty()) {
                wsEncrypt.getParts().addAll(parts);
            } else {
                wsEncrypt.getParts().add(WSSecurityUtil.getDefaultEncryptionPart(doc));
            }
            byte[] key = this.getKey(reqData.getSignatureToken(), passwordCallback, symmetricKey);
            wsEncrypt.prepare(key);
            Element externRefList = wsEncrypt.encrypt();
            Node nextSibling = null;
            if (tokenElement == null && "EncryptedKey".equals(encryptionToken.getDerivedKeyTokenReference())) {
                nextSibling = this.findEncryptedKeySibling(reqData);
            } else if (tokenElement == null && "SecurityContextToken".equals(encryptionToken.getDerivedKeyTokenReference())) {
                nextSibling = this.findSCTSibling(reqData);
            }
            if (nextSibling == null) {
                wsEncrypt.prependDKElementToHeader();
            } else {
                reqData.getSecHeader().getSecurityHeaderElement().insertBefore(wsEncrypt.getdktElement(), nextSibling);
            }
            wsEncrypt.addExternalRefElement(externRefList);
            if (tokenElement != null) {
                WSSecurityUtil.prependChildElement(reqData.getSecHeader().getSecurityHeaderElement(), tokenElement);
            }
            wsEncrypt.clean();
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)e), "empty", new Object[]{"Error during Encryption: "});
        }
    }

    private Element setupSCTTokenReference(RequestData reqData, EncryptionActionToken encryptionToken, WSSecDKEncrypt wsEncrypt, WSPasswordCallback passwordCallback, Document doc) throws WSSecurityException {
        if (reqData.getSignatureToken() != null && reqData.getSignatureToken().getKey() != null && reqData.getSignatureToken().getKeyIdentifier() != null) {
            this.setupSCTReference(wsEncrypt, (SignatureEncryptionActionToken)reqData.getSignatureToken(), reqData.isUse200512Namespace());
            return null;
        }
        return this.setupSCTReference(wsEncrypt, passwordCallback, (SignatureEncryptionActionToken)encryptionToken, reqData.isUse200512Namespace(), doc);
    }

    private Element setupEncryptedKeyTokenReference(RequestData reqData, EncryptionActionToken encryptionToken, WSSecDKEncrypt wsEncrypt, WSPasswordCallback passwordCallback, Document doc, SecretKey symmetricKey) throws WSSecurityException {
        if (symmetricKey == null) {
            this.setupEKReference(wsEncrypt, (SignatureEncryptionActionToken)reqData.getSignatureToken());
            return null;
        }
        return this.setupEKReference(wsEncrypt, reqData.getSecHeader(), passwordCallback, (SignatureEncryptionActionToken)encryptionToken, reqData.isUse200512Namespace(), doc, null, null, symmetricKey);
    }

    private byte[] getKey(SignatureActionToken encryptionToken, WSPasswordCallback passwordCallback, SecretKey symmetricKey) throws WSSecurityException {
        if (symmetricKey != null) {
            return symmetricKey.getEncoded();
        }
        if (encryptionToken != null && encryptionToken.getKey() != null && encryptionToken.getKeyIdentifier() != null) {
            return encryptionToken.getKey();
        }
        return passwordCallback.getKey();
    }
}

