/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.layers;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.daffodil.api.layers.Layer;
import org.apache.daffodil.runtime1.layers.ChecksumDecoderInputStream;
import org.apache.daffodil.runtime1.layers.ChecksumEncoderOutputStream;

public abstract class ChecksumLayerBase
extends Layer {
    private int checksum = -1;
    private int length = -1;
    private boolean isInitialized = false;

    public ChecksumLayerBase(String localName, String targetNamespace) {
        super(localName, targetNamespace);
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int len) {
        this.length = len;
        if (len < 0) {
            this.processingError("The layer length is negative: " + len + ".");
        }
        this.isInitialized = true;
    }

    public final int getChecksum() {
        return this.checksum;
    }

    public final void setChecksum(int checksum) {
        this.checksum = checksum;
    }

    public abstract int compute(boolean var1, ByteBuffer var2);

    private void checkInitialized() {
        if (!this.isInitialized) {
            throw new IllegalStateException("ChecksumLayer API usage: setLength method was never called.");
        }
    }

    @Override
    public final InputStream wrapLayerInput(InputStream jis) {
        this.checkInitialized();
        return new ChecksumDecoderInputStream(this, jis);
    }

    @Override
    public final OutputStream wrapLayerOutput(OutputStream jos) {
        this.checkInitialized();
        return new ChecksumEncoderOutputStream(this, jos);
    }
}

