/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import org.apache.datasketches.quantilescommon.FloatsSortedView;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesFloatsAPI;
import org.apache.datasketches.quantilescommon.QuantilesFloatsSketchIterator;
import org.apache.datasketches.req.ReqSketch;

abstract class BaseReqSketch
implements QuantilesFloatsAPI {
    static final byte INIT_NUMBER_OF_SECTIONS = 3;
    private static final double relRseFactor = Math.sqrt(0.017066666666666667);
    private static final double fixRseFactor = 0.084;

    BaseReqSketch() {
    }

    @Override
    public abstract double[] getCDF(float[] var1, QuantileSearchCriteria var2);

    public abstract boolean getHighRankAccuracyMode();

    @Override
    public abstract int getK();

    @Override
    public abstract float getMaxItem();

    @Override
    public abstract float getMinItem();

    public static double getRSE(int k, double rank, boolean hra, long totalN) {
        return BaseReqSketch.getRankUB(k, 2, rank, 1, hra, totalN);
    }

    @Override
    public abstract long getN();

    @Override
    public abstract double[] getPMF(float[] var1, QuantileSearchCriteria var2);

    @Override
    public abstract float getQuantile(double var1, QuantileSearchCriteria var3);

    @Override
    public abstract float[] getQuantiles(double[] var1, QuantileSearchCriteria var2);

    @Override
    public abstract float getQuantileLowerBound(double var1);

    public abstract float getQuantileLowerBound(double var1, int var3);

    @Override
    public abstract float getQuantileUpperBound(double var1);

    public abstract float getQuantileUpperBound(double var1, int var3);

    @Override
    public abstract double getRank(float var1, QuantileSearchCriteria var2);

    public abstract double getRankLowerBound(double var1, int var3);

    @Override
    public abstract double[] getRanks(float[] var1, QuantileSearchCriteria var2);

    public abstract double getRankUpperBound(double var1, int var3);

    @Override
    public abstract int getNumRetained();

    @Override
    public abstract int getSerializedSizeBytes();

    @Override
    public abstract FloatsSortedView getSortedView();

    @Override
    public abstract boolean isEmpty();

    @Override
    public abstract boolean isEstimationMode();

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public abstract QuantilesFloatsSketchIterator iterator();

    public abstract ReqSketch merge(ReqSketch var1);

    @Override
    public abstract void reset();

    @Override
    public abstract byte[] toByteArray();

    @Override
    public abstract String toString();

    @Override
    public abstract void update(float var1);

    public abstract String viewCompactorDetail(String var1, boolean var2);

    static boolean exactRank(int k, int levels, double rank, boolean hra, long totalN) {
        int baseCap = k * 3;
        if (levels == 1 || totalN <= (long)baseCap) {
            return true;
        }
        double exactRankThresh = (double)baseCap / (double)totalN;
        return hra ? rank >= 1.0 - exactRankThresh : rank <= exactRankThresh;
    }

    static double getRankLB(int k, int levels, double rank, int numStdDev, boolean hra, long totalN) {
        if (BaseReqSketch.exactRank(k, levels, rank, hra, totalN)) {
            return rank;
        }
        double relative = relRseFactor / (double)k * (hra ? 1.0 - rank : rank);
        double fixed = 0.084 / (double)k;
        double lbRel = rank - (double)numStdDev * relative;
        double lbFix = rank - (double)numStdDev * fixed;
        return Math.max(lbRel, lbFix);
    }

    static double getRankUB(int k, int levels, double rank, int numStdDev, boolean hra, long totalN) {
        if (BaseReqSketch.exactRank(k, levels, rank, hra, totalN)) {
            return rank;
        }
        double relative = relRseFactor / (double)k * (hra ? 1.0 - rank : rank);
        double fixed = 0.084 / (double)k;
        double ubRel = rank + (double)numStdDev * relative;
        double ubFix = rank + (double)numStdDev * fixed;
        return Math.min(ubRel, ubFix);
    }
}

