/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.util;

import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.CfgException;
import org.apache.directory.fortress.core.CfgRuntimeException;
import org.apache.directory.fortress.core.ConfigMgr;
import org.apache.directory.fortress.core.ConfigMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.Configuration;
import org.apache.directory.fortress.core.util.LdapUtil;
import org.apache.directory.fortress.core.util.PropUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Config {
    private static CompositeConfiguration config = new CompositeConfiguration();
    private static final String CLS_NM = Config.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private static final String PROP_FILE = "fortress.properties";
    private static final String USER_PROP_FILE = "fortress.user.properties";
    private static final String EXT_LDAP_HOST = "fortress.host";
    private static final String EXT_LDAP_PORT = "fortress.port";
    private static final String EXT_LDAP_ADMIN_POOL_UID = "fortress.admin.user";
    private static final String EXT_LDAP_ADMIN_POOL_PW = "fortress.admin.pw";
    private static final String EXT_LDAP_ADMIN_POOL_MIN = "fortress.min.admin.conn";
    private static final String EXT_LDAP_ADMIN_POOL_MAX = "fortress.max.admin.conn";
    private static final String EXT_LDAP_LOG_POOL_UID = "fortress.log.user";
    private static final String EXT_LDAP_LOG_POOL_PW = "fortress.log.pw";
    private static final String EXT_LDAP_LOG_POOL_MIN = "fortress.min.log.conn";
    private static final String EXT_LDAP_LOG_POOL_MAX = "fortress.max.log.conn";
    private static final String EXT_ENABLE_LDAP_SSL = "fortress.enable.ldap.ssl";
    private static final String EXT_ENABLE_LDAP_STARTTLS = "fortress.enable.ldap.starttls";
    private static final String EXT_ENABLE_LDAP_SSL_DEBUG = "fortress.enable.ldap.ssl.debug";
    private static final String EXT_TRUST_STORE = "fortress.trust.store";
    private static final String EXT_TRUST_STORE_PW = "fortress.trust.store.password";
    private static final String EXT_TRUST_STORE_ONCLASSPATH = "fortress.trust.store.onclasspath";
    private static final String EXT_CONFIG_REALM = "fortress.config.realm";
    private static final String EXT_CONFIG_ROOT_DN = "fortress.config.root";
    private static final String EXT_CONFIG_SUFFIX = "fortress.suffix";
    private static final String EXT_SERVER_TYPE = "fortress.ldap.server.type";
    private static final String EXT_IS_ARBAC02 = "fortress.is.arbac02";
    private static volatile Config sINSTANCE = null;
    private boolean remoteConfigLoaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Config getInstance() {
        if (sINSTANCE != null) return sINSTANCE;
        Class<Config> clazz = Config.class;
        synchronized (Config.class) {
            if (sINSTANCE != null || (sINSTANCE = new Config()).isRemoteConfigLoaded()) return sINSTANCE;
            sINSTANCE.loadRemoteConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sINSTANCE;
        }
    }

    private Config() {
        this.loadLocalConfig();
        this.getExternalConfig();
    }

    public String getProperty(String name) {
        return this.getProperty(name, false);
    }

    public String getProperty(String name, boolean nologvalue) {
        String value = null;
        if (config != null) {
            value = (String)config.getProperty(name);
            LOG.debug("getProperty name [{}] value [{}]", (Object)name, (Object)(nologvalue ? "****" : value));
        } else {
            LOG.warn("getProperty invalid config, can't read prop [{}]", (Object)name);
        }
        return value;
    }

    public String getProperty(String name, String defaultValue) {
        String value = null;
        if (config != null) {
            value = (String)config.getProperty(name);
            LOG.debug("getProperty name [{}] value [{}] default value [{}]", new Object[]{name, value, defaultValue});
        } else {
            String warn = "getProperty invalid config, can't read prop [" + name + "]";
            LOG.warn(warn);
        }
        if (value == null || value.length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    public List<Object> getList(String name) {
        List values = null;
        if (config != null) {
            values = config.getList(name);
            LOG.debug("getList name [{}]", (Object)name);
        } else {
            String warn = "getList invalid config, can't read prop [" + name + "]";
            LOG.warn(warn);
        }
        return values;
    }

    public char getChar(String name) {
        char value = '\u0000';
        if (config != null) {
            value = ((Character)config.getProperty(name)).charValue();
            LOG.debug("getChar name [{}] value [{}]", (Object)name, (Object)Character.valueOf(value));
        } else {
            LOG.warn("getChar invalid config, can't read prop [{}]", (Object)name);
        }
        return value;
    }

    public char getChar(String name, char defaultValue) {
        char value = '\u0000';
        if (config != null) {
            value = ((Character)config.getProperty(name)).charValue();
            LOG.debug("getChar name [{}] value [{}]", (Object)name, (Object)Character.valueOf(value));
        } else {
            LOG.warn("getChar invalid config, can't read prop [{}], using default [{}]", (Object)name, (Object)Character.valueOf(defaultValue));
        }
        if (value == '\u0000') {
            value = defaultValue;
        }
        return value;
    }

    public int getInt(String key) {
        int value = 0;
        try {
            if (config != null) {
                value = config.getInt(key);
                LOG.debug("getInt name [{}] value [{}]", (Object)key, (Object)value);
            } else {
                LOG.warn("getInt invalid config, can't read prop [{}]", (Object)key);
            }
        }
        catch (ConversionException e) {
            LOG.debug("getInt can't read prop [{}], exception [{}]", (Object)key, (Object)e);
        }
        return value;
    }

    public int getInt(String key, int defaultValue) {
        int value = defaultValue;
        try {
            if (config != null) {
                value = config.getInt(key, defaultValue);
                LOG.debug("getInt name [{}] value [{}]", (Object)key, (Object)value);
            } else {
                LOG.warn("getInt invalid config, can't read prop [{}], using default [{}]", (Object)key, (Object)defaultValue);
            }
        }
        catch (IllegalStateException e) {
            LOG.debug("getInt - illegal state exception [{}], using default [{}]", (Object)key, (Object)defaultValue);
        }
        catch (ConversionException e) {
            LOG.debug("getInt name [{}], conversion exception using default  [{}]", (Object)key, (Object)defaultValue);
        }
        return value;
    }

    public boolean getBoolean(String key) {
        boolean value = false;
        try {
            if (config != null) {
                value = config.getBoolean(key);
                LOG.debug("getBoolean name [{}] value [{}]", (Object)key, (Object)value);
            } else {
                LOG.warn("getBoolean invalid config, can't read prop [{}], using default [{}]", (Object)key, (Object)false);
            }
        }
        catch (NoSuchElementException e) {
            LOG.debug("getBoolean - no such element [{}], using default [{}]", (Object)key, (Object)false);
        }
        return value;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        boolean value = defaultValue;
        try {
            if (config != null) {
                try {
                    value = config.getBoolean(key, defaultValue);
                    LOG.debug("getBoolean name [{}] value [{}]", (Object)key, (Object)value);
                }
                catch (ConversionException e) {
                    LOG.debug("getBoolean name [{}], conversion exception using default  [{}]", (Object)key, (Object)defaultValue);
                }
            } else {
                LOG.warn("getBoolean - invalid config, can't read prop [{}], using default [{}]", (Object)key, (Object)defaultValue);
            }
        }
        catch (IllegalStateException e) {
            LOG.debug("getBoolean - illegal state exception [{}], using default [{}]", (Object)key, (Object)defaultValue);
        }
        catch (NoSuchElementException nse) {
            LOG.debug("getBoolean - no such element [{}], using default [{}]", (Object)key, (Object)defaultValue);
        }
        return value;
    }

    public void setProperty(String name, String value) {
        if (config != null) {
            config.setProperty(name, (Object)value);
        } else {
            LOG.warn("setProperty invalid config, can't set prop name [{}], value [{}]" + name, (Object)value);
        }
    }

    public void clearProperty(String name) {
        if (config != null) {
            config.clearProperty(name);
        } else {
            LOG.warn("clearProperty invalid config, prop name [{}]", (Object)name);
        }
    }

    private Properties getRemoteConfig(String realmName) throws SecurityException {
        Properties props = null;
        try {
            String configClassName = this.getProperty("configmgr.implementation");
            ConfigMgr cfgMgr = ConfigMgrFactory.createInstance(configClassName, false);
            Configuration configuration = cfgMgr.read(realmName);
            props = configuration.getProperties();
        }
        catch (CfgException ce) {
            if (ce.getErrorId() == 107) {
                LOG.warn("getRemoteConfig could not find cfg entry [{}]", (Object)realmName);
            }
            throw ce;
        }
        return props;
    }

    public boolean isRestEnabled() {
        return this.getProperty("enable.mgr.impl.rest") != null && this.getProperty("enable.mgr.impl.rest").equalsIgnoreCase("true");
    }

    public String getDelimiter() {
        return this.getProperty("attr.delimiter", "$");
    }

    public boolean isAuditEnabled() {
        return this.getProperty("enable.audit") == null || this.getProperty("enable.audit").equalsIgnoreCase("true");
    }

    public boolean isOpenldap() {
        return this.getProperty("ldap.server.type") != null && this.getProperty("ldap.server.type").equalsIgnoreCase("openldap");
    }

    public boolean isApacheds() {
        return this.getProperty("ldap.server.type") != null && this.getProperty("ldap.server.type").equalsIgnoreCase("apacheds");
    }

    public boolean isRealm() {
        return "REALM".equalsIgnoreCase(this.getProperty("authn.type"));
    }

    public boolean isRoleOccupant() {
        String ROLE_OCCUPANTS = "role.occupants";
        boolean result = true;
        if (this.getProperty(ROLE_OCCUPANTS) != null && this.getProperty(ROLE_OCCUPANTS).equalsIgnoreCase("false")) {
            result = false;
        }
        return result;
    }

    private boolean isRemoteConfigLoaded() {
        return this.remoteConfigLoaded;
    }

    private char[] loadLdapEscapeChars() {
        String prop;
        String value;
        char[] ldapMetaChars = new char[LdapUtil.getInstance().getLdapFilterSize()];
        int i = 1;
        while ((value = this.getProperty(prop = "ldap.filter." + i)) != null) {
            ldapMetaChars[i - 1] = value.charAt(0);
            ++i;
        }
        return ldapMetaChars;
    }

    private String[] loadValidLdapVals() {
        String prop;
        String value;
        String[] ldapReplacements = new String[LdapUtil.getInstance().getLdapFilterSize()];
        int i = 1;
        while ((value = this.getProperty(prop = "ldap.sub." + i)) != null) {
            ldapReplacements[i - 1] = value;
            ++i;
        }
        return ldapReplacements;
    }

    private void loadLocalConfig() {
        try {
            URL fUrl = Config.class.getClassLoader().getResource(PROP_FILE);
            if (fUrl == null) {
                String error = "static init: Error, null cfg file: fortress.properties";
                LOG.warn(error);
            } else {
                LOG.info("static init: found from: {} path: {}", (Object)PROP_FILE, (Object)fUrl.getPath());
                PropertiesConfiguration sysProps = new PropertiesConfiguration();
                FileHandler fileHandler = new FileHandler((FileBased)sysProps);
                fileHandler.load(fUrl);
                config.addConfiguration((org.apache.commons.configuration2.Configuration)sysProps);
                LOG.info("static init: loading from: {}", (Object)PROP_FILE);
            }
            URL fUserUrl = Config.class.getClassLoader().getResource(USER_PROP_FILE);
            if (fUserUrl != null) {
                LOG.info("static init: found user properties from: {} path: {}", (Object)USER_PROP_FILE, (Object)fUserUrl.getPath());
                PropertiesConfiguration userProps = new PropertiesConfiguration();
                FileHandler userFileHandler = new FileHandler((FileBased)userProps);
                userFileHandler.load(fUserUrl);
                config.addConfiguration((org.apache.commons.configuration2.Configuration)userProps);
            }
            config.setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler());
        }
        catch (ConfigurationException ex) {
            String error = "static init: Error loading from cfg file: [fortress.properties] ConfigurationException=" + ex;
            LOG.error(error);
            throw new CfgRuntimeException(126, error, (Exception)((Object)ex));
        }
    }

    private void getExternalConfig() {
        String PREFIX = "getExternalConfig override name [{}] value [{}]";
        String szValue = System.getProperty(EXT_LDAP_HOST);
        if (StringUtils.isNotEmpty((CharSequence)szValue)) {
            config.setProperty("host", (Object)szValue);
            LOG.info(PREFIX, (Object)"host", (Object)szValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_LDAP_PORT)))) {
            config.setProperty("port", (Object)szValue);
            LOG.info(PREFIX, (Object)"port", (Object)szValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_LDAP_ADMIN_POOL_UID)))) {
            config.setProperty("admin.user", (Object)szValue);
            LOG.info("getExternalConfig override name [{}]", (Object)"admin.user");
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_LDAP_ADMIN_POOL_PW)))) {
            config.setProperty("admin.pw", (Object)szValue);
            LOG.info("getExternalConfig override name [{}]", (Object)"admin.pw");
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_LDAP_ADMIN_POOL_MIN)))) {
            config.setProperty("min.admin.conn", (Object)szValue);
            LOG.info(PREFIX, (Object)"min.admin.conn", (Object)szValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_LDAP_ADMIN_POOL_MAX)))) {
            config.setProperty("max.admin.conn", (Object)szValue);
            LOG.info(PREFIX, (Object)"max.admin.conn", (Object)szValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_LDAP_LOG_POOL_UID)))) {
            config.setProperty("log.admin.user", (Object)szValue);
            LOG.info("getExternalConfig override name [{}]", (Object)"log.admin.user");
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_LDAP_LOG_POOL_PW)))) {
            config.setProperty("log.admin.pw", (Object)szValue);
            LOG.info("getExternalConfig override name [{}]", (Object)"log.admin.pw");
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_LDAP_LOG_POOL_MIN)))) {
            config.setProperty("min.log.conn", (Object)szValue);
            LOG.info(PREFIX, (Object)"min.log.conn", (Object)szValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_LDAP_LOG_POOL_MAX)))) {
            config.setProperty("max.log.conn", (Object)szValue);
            LOG.info(PREFIX, (Object)"max.log.conn", (Object)szValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_ENABLE_LDAP_SSL)))) {
            config.setProperty("enable.ldap.ssl", (Object)szValue);
            LOG.info(PREFIX, (Object)"enable.ldap.ssl", (Object)szValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_ENABLE_LDAP_STARTTLS)))) {
            config.setProperty("enable.ldap.starttls", (Object)szValue);
            LOG.info(PREFIX, (Object)"enable.ldap.starttls", (Object)szValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_ENABLE_LDAP_SSL_DEBUG)))) {
            config.setProperty("enable.ldap.ssl.debug", (Object)szValue);
            LOG.info(PREFIX, (Object)"enable.ldap.ssl.debug", (Object)szValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_TRUST_STORE)))) {
            config.setProperty("trust.store", (Object)szValue);
            LOG.info(PREFIX, (Object)"trust.store", (Object)szValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_TRUST_STORE_PW)))) {
            config.setProperty("trust.store.password", (Object)szValue);
            LOG.info("getExternalConfig override name [{}]", (Object)"trust.store.password");
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_TRUST_STORE_ONCLASSPATH)))) {
            config.setProperty("trust.store.onclasspath", (Object)szValue);
            LOG.info(PREFIX, (Object)"trust.store.onclasspath", (Object)szValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_CONFIG_SUFFIX)))) {
            config.setProperty("suffix", (Object)szValue);
            LOG.info(PREFIX, (Object)"suffix", (Object)szValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_CONFIG_REALM)))) {
            config.setProperty("config.realm", (Object)szValue);
            LOG.info(PREFIX, (Object)"config.realm", (Object)szValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_CONFIG_ROOT_DN)))) {
            config.setProperty("config.root", (Object)szValue);
            LOG.info(PREFIX, (Object)"config.root", (Object)szValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_SERVER_TYPE)))) {
            config.setProperty("ldap.server.type", (Object)szValue);
            LOG.info(PREFIX, (Object)"ldap.server.type", (Object)szValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)(szValue = System.getProperty(EXT_IS_ARBAC02)))) {
            Boolean isArbac02 = Boolean.valueOf(szValue);
            config.setProperty("is.arbac02", (Object)isArbac02);
            LOG.info(PREFIX, (Object)"is.arbac02", (Object)isArbac02);
        }
    }

    private void loadRemoteConfig() {
        block9: {
            try {
                if (Config.getInstance().getProperty("config.realm") == null) {
                    LOG.warn("Config realm not enabled");
                    return;
                }
                String realmName = config.getString("config.realm", "DEFAULT");
                if (realmName != null && realmName.length() > 0) {
                    LOG.info("static init: load config realm [{}]", (Object)realmName);
                    Properties props = this.getRemoteConfig(realmName);
                    if (props != null) {
                        Enumeration<?> e = props.propertyNames();
                        while (e.hasMoreElements()) {
                            String key = (String)e.nextElement();
                            String val = props.getProperty(key);
                            config.setProperty(key, (Object)val);
                        }
                    }
                    boolean ldapfilterSizeFound = this.getProperty("ldap.filter.size") != null;
                    LdapUtil.getInstance().setLdapfilterSizeFound(ldapfilterSizeFound);
                    LdapUtil.getInstance().setLdapMetaChars(this.loadLdapEscapeChars());
                    LdapUtil.getInstance().setLdapReplVals(this.loadValidLdapVals());
                    try {
                        String lenProp = this.getProperty("ldap.filter.size");
                        if (ldapfilterSizeFound) {
                            LdapUtil.getInstance().setLdapFilterSize(Integer.valueOf(lenProp));
                        }
                    }
                    catch (NumberFormatException nfe) {
                        String error = "loadRemoteConfig caught NumberFormatException=" + nfe;
                        LOG.warn(error);
                    }
                    this.remoteConfigLoaded = true;
                    break block9;
                }
                LOG.info("static init: config realm not setup");
            }
            catch (SecurityException se) {
                String error = "static init: Error loading from remote config: SecurityException=" + se;
                LOG.error(error);
                throw new CfgRuntimeException(127, error, se);
            }
        }
    }

    public String getConstraintKey(String role, String contextId) {
        return "RC" + this.getDelimiter() + contextId + this.getDelimiter() + role.toLowerCase();
    }

    public synchronized Configuration getIncrementReplacePosixIds(List<String> props, PropUpdater propUpdater) throws CfgException {
        Configuration inConfig;
        String cfgName = Config.getInstance().getProperty("config.realm", "DEFAULT");
        try {
            ConfigMgr cfgMgr = ConfigMgrFactory.createInstance();
            inConfig = cfgMgr.getIds(cfgName);
            Configuration outConfig = new Configuration();
            outConfig.setName(cfgName);
            for (String name : props) {
                if (name.equals("uidNumber")) {
                    outConfig.setUidNumber(propUpdater.newValue(inConfig.getUidNumber()));
                }
                if (!name.equals("gidNumber")) continue;
                outConfig.setGidNumber(propUpdater.newValue(inConfig.getGidNumber()));
            }
            cfgMgr.update(outConfig);
        }
        catch (SecurityException se) {
            String error = "replaceProperty failed, exception=" + se.getMessage();
            throw new CfgRuntimeException(121, error, se);
        }
        return inConfig;
    }
}

