/*
 * Decompiled with CFR 0.152.
 */
package groovy.junit5.plugin;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyRuntimeException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.groovy.plugin.GroovyRunner;
import org.codehaus.groovy.runtime.InvokerHelper;

public class JUnit5Runner
implements GroovyRunner {
    public boolean canRun(Class<?> scriptClass, GroovyClassLoader loader) {
        Method[] methods;
        if (!this.tryLoadClass("org.junit.jupiter.api.Test", loader)) {
            return false;
        }
        if (this.isJUnit5AnnotationPresent(scriptClass.getAnnotations(), loader)) {
            return true;
        }
        for (Method method : methods = scriptClass.getMethods()) {
            if (!this.isJUnit5AnnotationPresent(method.getAnnotations(), loader)) continue;
            return true;
        }
        return false;
    }

    private boolean isJUnit5AnnotationPresent(Annotation[] annotations, GroovyClassLoader loader) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> type = annotation.annotationType();
            String name = type.getName();
            if (name.startsWith("org.junit.jupiter.api.") && this.tryLoadClass(name, loader)) {
                return true;
            }
            if ("org.junit.platform.commons.annotation.Testable".equals(name) && this.tryLoadClass(name, loader)) {
                return true;
            }
            if (!this.isJUnit5TestableMetaAnnotationPresent(type, new HashSet<String>()) || !this.tryLoadClass(name, loader)) continue;
            return true;
        }
        return false;
    }

    private boolean isJUnit5TestableMetaAnnotationPresent(Class<? extends Annotation> type, Set<String> seen) {
        for (Annotation annotation : type.getAnnotations()) {
            if ("org.junit.platform.commons.annotation.Testable".equals(annotation.annotationType().getName())) {
                return true;
            }
            if (seen.contains(annotation.annotationType().getName())) continue;
            seen.add(annotation.annotationType().getName());
            if (!this.isJUnit5TestableMetaAnnotationPresent(annotation.annotationType(), seen)) continue;
            return true;
        }
        return false;
    }

    private boolean tryLoadClass(String name, GroovyClassLoader loader) {
        try {
            loader.loadClass(name);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public Object run(Class<?> scriptClass, GroovyClassLoader loader) {
        try {
            try {
                loader.loadClass("org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder");
            }
            catch (ClassNotFoundException ignored) {
                System.err.println("WARNING: Required dependency: org.junit.platform:junit-platform-launcher doesn't appear to be on the classpath");
            }
            Class helper = loader.loadClass("groovy.junit5.plugin.GroovyJUnitRunnerHelper");
            Throwable ifFailed = (Throwable)InvokerHelper.invokeStaticMethod((Class)helper, (String)"execute", (Object)new Object[]{scriptClass});
            if (ifFailed != null) {
                throw new GroovyRuntimeException(ifFailed);
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new GroovyRuntimeException("Error running JUnit 5 test.", (Throwable)e);
        }
    }
}

