/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.client.proto;

import org.apache.ignite.shaded.org.apache.ignite.compute.JobDescriptor;
import org.apache.ignite.shaded.org.apache.ignite.compute.JobExecutorType;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.shaded.org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.shaded.org.apache.ignite.internal.compute.SharedComputeUtils;
import org.apache.ignite.shaded.org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public final class ClientComputeJobPacker {
    public static <T> void packJobArgument(@Nullable T arg, @Nullable Marshaller<T, byte[]> marshaller, ClientMessagePacker packer) {
        ClientComputeJobPacker.pack(arg, marshaller, packer);
    }

    public static <T> void packJobResult(@Nullable T res, @Nullable Marshaller<T, byte[]> marshaller, ClientMessagePacker packer) {
        ClientComputeJobPacker.pack(res, marshaller, packer);
    }

    public static <T, R> void packJob(JobDescriptor<T, R> descriptor, T arg, boolean platformComputeSupported, ClientMessagePacker w) {
        w.packDeploymentUnits(descriptor.units());
        w.packString(descriptor.jobClassName());
        w.packInt(descriptor.options().priority());
        w.packInt(descriptor.options().maxRetries());
        JobExecutorType executorType = descriptor.options().executorType();
        if (platformComputeSupported) {
            w.packInt(executorType.ordinal());
        } else if (executorType != JobExecutorType.JAVA_EMBEDDED) {
            throw new IllegalArgumentException("Custom job executors are not supported by the server: " + String.valueOf((Object)executorType));
        }
        ClientComputeJobPacker.packJobArgument(arg, descriptor.argumentMarshaller(), w);
    }

    private static <T> void pack(@Nullable T obj, @Nullable Marshaller<T, byte[]> marshaller, ClientMessagePacker packer) {
        ComputeJobDataHolder holder;
        ComputeJobDataHolder computeJobDataHolder = holder = obj instanceof ComputeJobDataHolder ? (ComputeJobDataHolder)obj : SharedComputeUtils.marshalArgOrResult(obj, marshaller);
        if (holder.data() == null) {
            packer.packNil();
            return;
        }
        packer.packInt(holder.type().id());
        packer.packBinary(holder.data());
    }
}

