/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.tx.message.FinishedTransactionsBatchMessage;
import org.apache.ignite.internal.tx.message.FinishedTransactionsBatchMessageImpl;

class FinishedTransactionsBatchMessageSerializer
implements MessageSerializer<FinishedTransactionsBatchMessage> {
    public static final FinishedTransactionsBatchMessageSerializer INSTANCE = new FinishedTransactionsBatchMessageSerializer();

    private FinishedTransactionsBatchMessageSerializer() {
    }

    public boolean writeMessage(FinishedTransactionsBatchMessage msg, MessageWriter writer) throws MessageMappingException {
        FinishedTransactionsBatchMessageImpl message = (FinishedTransactionsBatchMessageImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeHybridTimestamp("timestamp", message.timestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeCollection("transactions", message.transactions(), MessageCollectionItemType.UUID);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

