/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.topology.api;

import java.io.IOException;
import java.util.HashSet;
import java.util.UUID;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNodeSerializer;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerializer;

public class LogicalTopologySnapshotSerializer
extends VersionedSerializer<LogicalTopologySnapshot> {
    public static final LogicalTopologySnapshotSerializer INSTANCE = new LogicalTopologySnapshotSerializer();
    private final LogicalNodeSerializer logicalNodeSerializer = LogicalNodeSerializer.INSTANCE;

    protected void writeExternalData(LogicalTopologySnapshot snapshot, IgniteDataOutput out) throws IOException {
        out.writeVarInt(snapshot.version());
        out.writeVarInt((long)snapshot.nodes().size());
        for (LogicalNode node : snapshot.nodes()) {
            this.logicalNodeSerializer.writeExternal((Object)node, out);
        }
        out.writeUuid(snapshot.clusterId());
    }

    protected LogicalTopologySnapshot readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        long version = in.readVarInt();
        int nodesCount = in.readVarIntAsInt();
        HashSet<LogicalNode> nodes = new HashSet<LogicalNode>(IgniteUtils.capacity((int)nodesCount));
        for (int i = 0; i < nodesCount; ++i) {
            nodes.add((LogicalNode)((Object)this.logicalNodeSerializer.readExternal(in)));
        }
        UUID clusterId = in.readUuid();
        return new LogicalTopologySnapshot(version, nodes, clusterId);
    }
}

