/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.configuration;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.configuration.ConfigurationModule;
import org.apache.ignite.configuration.SuperRootChange;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.internal.replicator.configuration.ReplicationExtensionChange;
import org.apache.ignite.internal.replicator.configuration.ReplicationExtensionConfiguration;
import org.apache.ignite.internal.replicator.configuration.ReplicationExtensionConfigurationSchema;
import org.apache.ignite.internal.replicator.configuration.ReplicationExtensionView;
import org.apache.ignite.internal.replicator.configuration.StorageUpdateView;

@AutoService(value={ConfigurationModule.class})
public class ReplicationConfigurationModule
implements ConfigurationModule {
    public ConfigurationType type() {
        return ConfigurationType.DISTRIBUTED;
    }

    public Collection<Class<?>> schemaExtensions() {
        return List.of(ReplicationExtensionConfigurationSchema.class);
    }

    public void migrateDeprecatedConfigurations(SuperRootChange superRootChange) {
        ReplicationExtensionView rootView = (ReplicationExtensionView)superRootChange.viewRoot(ReplicationExtensionConfiguration.KEY);
        ReplicationExtensionChange rootChange = (ReplicationExtensionChange)superRootChange.changeRoot(ReplicationExtensionConfiguration.KEY);
        StorageUpdateView storageUpdateView = rootView.storageUpdate();
        if (storageUpdateView.batchByteLength() != 8192) {
            rootChange.changeReplication().changeBatchSizeBytes(storageUpdateView.batchByteLength());
        }
    }
}

