/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql2rel.ReflectiveConvertletTable;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.ignite.internal.sql.engine.sql.fun.IgniteSqlOperatorTable;

public class IgniteConvertletTable
extends ReflectiveConvertletTable {
    public static final IgniteConvertletTable INSTANCE = new IgniteConvertletTable();

    private IgniteConvertletTable() {
        this.registerOp((SqlOperator)SqlStdOperatorTable.TIMESTAMP_DIFF, new TimestampDiffConvertlet());
        this.addAlias((SqlOperator)IgniteSqlOperatorTable.PERCENT_REMAINDER, (SqlOperator)SqlStdOperatorTable.MOD);
        this.registerOp((SqlOperator)SqlStdOperatorTable.PLUS, this::convertPlus);
        this.registerOp((SqlOperator)SqlStdOperatorTable.MINUS, this::convertMinus);
    }

    public SqlRexConvertlet get(SqlCall call) {
        SqlRexConvertlet res = super.get(call);
        return res == null ? StandardConvertletTable.INSTANCE.get(call) : res;
    }

    private RexNode convertPlus(SqlRexContext cx, SqlCall call) {
        RexNode rex = StandardConvertletTable.INSTANCE.convertCall(cx, call);
        switch (rex.getType().getSqlTypeName()) {
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                RexBuilder rexBuilder = cx.getRexBuilder();
                List operands = ((RexCall)rex).getOperands();
                if (operands.size() == 2) {
                    SqlTypeName sqlTypeName = ((RexNode)operands.get(0)).getType().getSqlTypeName();
                    switch (sqlTypeName) {
                        case INTERVAL_YEAR: 
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_MONTH: 
                        case INTERVAL_DAY: 
                        case INTERVAL_DAY_HOUR: 
                        case INTERVAL_DAY_MINUTE: 
                        case INTERVAL_DAY_SECOND: 
                        case INTERVAL_HOUR: 
                        case INTERVAL_HOUR_MINUTE: 
                        case INTERVAL_HOUR_SECOND: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_MINUTE_SECOND: 
                        case INTERVAL_SECOND: {
                            operands = ImmutableList.of((Object)((RexNode)operands.get(1)), (Object)((RexNode)operands.get(0)));
                            break;
                        }
                    }
                }
                return rexBuilder.makeCall(call.getParserPosition(), rex.getType(), (SqlOperator)SqlStdOperatorTable.DATETIME_PLUS, operands);
            }
        }
        return rex;
    }

    private RexNode convertMinus(SqlRexContext cx, SqlCall call) {
        RexCall e = (RexCall)StandardConvertletTable.INSTANCE.convertCall(cx, call);
        switch (((RexNode)e.getOperands().get(0)).getType().getSqlTypeName()) {
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return StandardConvertletTable.INSTANCE.convertDatetimeMinus(cx, SqlStdOperatorTable.MINUS_DATE, call);
            }
        }
        return e;
    }

    private static class TimestampDiffConvertlet
    implements SqlRexConvertlet {
        private TimestampDiffConvertlet() {
        }

        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            RexBuilder rexBuilder = cx.getRexBuilder();
            SqlIntervalQualifier unitLiteral = (SqlIntervalQualifier)call.operand(0);
            TimeUnit unit = unitLiteral.getUnit();
            BigDecimal multiplier = BigDecimal.ONE;
            BigDecimal divider = BigDecimal.ONE;
            SqlTypeName sqlTypeName = unit == TimeUnit.NANOSECOND ? SqlTypeName.BIGINT : SqlTypeName.INTEGER;
            switch (unit) {
                case MICROSECOND: 
                case MILLISECOND: 
                case NANOSECOND: {
                    divider = unit.multiplier;
                    unit = TimeUnit.MILLISECOND;
                    break;
                }
                case WEEK: {
                    multiplier = BigDecimal.valueOf(1000L);
                    divider = unit.multiplier;
                    unit = TimeUnit.SECOND;
                    break;
                }
                case QUARTER: {
                    divider = unit.multiplier;
                    unit = TimeUnit.MONTH;
                    break;
                }
            }
            SqlIntervalQualifier qualifier = new SqlIntervalQualifier(unit, null, SqlParserPos.ZERO);
            RexNode op2 = cx.convertExpression(call.operand(2));
            RexNode op1 = cx.convertExpression(call.operand(1));
            RelDataType intervalType = cx.getTypeFactory().createTypeWithNullability(cx.getTypeFactory().createSqlIntervalType(qualifier), op1.getType().isNullable() || op2.getType().isNullable());
            RexCall rexCall = (RexCall)rexBuilder.makeCall(intervalType, (SqlOperator)SqlStdOperatorTable.MINUS_DATE, List.of(op2, op1));
            RelDataType intType = cx.getTypeFactory().createTypeWithNullability(cx.getTypeFactory().createSqlType(sqlTypeName), SqlTypeUtil.containsNullable((RelDataType)rexCall.getType()));
            RexNode e = unit == TimeUnit.MILLISECOND ? TimestampDiffConvertlet.makeCastMilliseconds(rexBuilder, intType, (RexNode)rexCall) : rexBuilder.makeCast(intType, (RexNode)rexCall);
            return rexBuilder.multiplyDivide(e, multiplier, divider);
        }

        static RexNode makeCastMilliseconds(RexBuilder builder, RelDataType type, RexNode exp) {
            return builder.ensureType(type, builder.decodeIntervalOrDecimal(exp), false);
        }
    }
}

