/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.view.AbstractViewConfig;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.view.RapiPDFConfig;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

final class RapidocConfig
extends AbstractViewConfig {
    public static final String RAPIDOC_PREFIX = "rapidoc.";
    private static final String DEFAULT_RAPIDOC_JS_PATH = "res/";
    private static final List<String> RESOURCE_FILES = Collections.singletonList("res/rapidoc-min.js");
    private static final Map<String, Object> DEFAULT_OPTIONS = new HashMap<String, Object>();
    private static final Map<String, Function<String, Object>> VALID_OPTIONS = new HashMap<String, Function<String, Object>>(61);
    RapiPDFConfig rapiPDFConfig;

    private RapidocConfig(Map<Pair<String, String>, OpenApiInfo> openApiInfos) {
        super(RAPIDOC_PREFIX, openApiInfos);
        this.jsUrl = DEFAULT_RAPIDOC_JS_PATH;
    }

    static RapidocConfig fromProperties(Map<String, String> properties, Map<Pair<String, String>, OpenApiInfo> openApiInfos, VisitorContext context) {
        return AbstractViewConfig.fromProperties(new RapidocConfig(openApiInfos), DEFAULT_OPTIONS, properties, OpenApiViewConfig.RendererType.RAPIDOC, context);
    }

    @Override
    public String render(String template, VisitorContext context) {
        template = this.rapiPDFConfig.render(template, OpenApiViewConfig.RendererType.RAPIDOC, context);
        template = OpenApiViewConfig.replacePlaceHolder(template, "rapidoc.js.url.prefix", this.isDefaultJsUrl ? this.getFinalUrlPrefix(OpenApiViewConfig.RendererType.RAPIDOC, context) : this.jsUrl, "");
        return OpenApiViewConfig.replacePlaceHolder(template, "rapidoc.attributes", this.toHtmlAttributes(), "");
    }

    @Override
    protected Function<String, Object> getConverter(String key) {
        return VALID_OPTIONS.get(key);
    }

    @Override
    protected List<String> getResources() {
        return RESOURCE_FILES;
    }

    static {
        VALID_OPTIONS.put("style", AbstractViewConfig::asString);
        VALID_OPTIONS.put("spec-url", AbstractViewConfig::asString);
        VALID_OPTIONS.put("update-route", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("route-prefix", AbstractViewConfig::asString);
        VALID_OPTIONS.put("sort-tags", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("sort-endpoints-by", new AbstractViewConfig.EnumConverter<EndPoint>(EndPoint.class));
        VALID_OPTIONS.put("heading-text", AbstractViewConfig::asString);
        VALID_OPTIONS.put("goto-path", AbstractViewConfig::asString);
        VALID_OPTIONS.put("fill-request-fields-with-example", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("persist-auth", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("theme", new AbstractViewConfig.EnumConverter<Theme>(Theme.class));
        VALID_OPTIONS.put("bg-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("text-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("header-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("primary-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("load-fonts", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("regular-font", AbstractViewConfig::asString);
        VALID_OPTIONS.put("mono-font", AbstractViewConfig::asString);
        VALID_OPTIONS.put("font-size", new AbstractViewConfig.EnumConverter<FontSize>(FontSize.class));
        VALID_OPTIONS.put("css-file", AbstractViewConfig::asString);
        VALID_OPTIONS.put("css-classes", AbstractViewConfig::asString);
        VALID_OPTIONS.put("show-method-in-nav-bar", ShowMethodInNavBar::byCode);
        VALID_OPTIONS.put("use-path-in-nav-bar", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("nav-bg-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("nav-text-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("nav-hover-bg-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("nav-hover-text-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("nav-accent-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("nav-accent-text-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("nav-active-item-marker", AbstractViewConfig::asString);
        VALID_OPTIONS.put("nav-item-spacing", new AbstractViewConfig.EnumConverter<NavItemSpacing>(NavItemSpacing.class));
        VALID_OPTIONS.put("on-nav-tag-click", NavTagClick::byCode);
        VALID_OPTIONS.put("layout", new AbstractViewConfig.EnumConverter<Layout>(Layout.class));
        VALID_OPTIONS.put("render-style", new AbstractViewConfig.EnumConverter<RenderStyle>(RenderStyle.class));
        VALID_OPTIONS.put("response-area-height", AbstractViewConfig::asString);
        VALID_OPTIONS.put("show-info", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("info-description-headings-in-navbar", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("show-components", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("show-header", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("allow-authentication", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("allow-spec-url-load", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("allow-spec-file-load", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("allow-spec-file-download", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("allow-search", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("allow-advanced-search", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("allow-try", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("show-curl-before-try", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("allow-server-selection", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("allow-schema-description-expand-toggle", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("schema-style", new AbstractViewConfig.EnumConverter<SchemaStyle>(SchemaStyle.class));
        VALID_OPTIONS.put("schema-expand-level", AbstractViewConfig::asString);
        VALID_OPTIONS.put("schema-description-expanded", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("schema-hide-read-only", new AbstractViewConfig.EnumConverter<SchemaHideReadOnly>(SchemaHideReadOnly.class));
        VALID_OPTIONS.put("schema-hide-write-only", new AbstractViewConfig.EnumConverter<SchemaHideWriteOnly>(SchemaHideWriteOnly.class));
        VALID_OPTIONS.put("default-schema-tab", new AbstractViewConfig.EnumConverter<DefaultSchemaTab>(DefaultSchemaTab.class));
        VALID_OPTIONS.put("server-url", AbstractViewConfig::asString);
        VALID_OPTIONS.put("default-api-server", AbstractViewConfig::asString);
        VALID_OPTIONS.put("api-key-name", AbstractViewConfig::asString);
        VALID_OPTIONS.put("api-key-location", new AbstractViewConfig.EnumConverter<ApiKeyLocation>(ApiKeyLocation.class));
        VALID_OPTIONS.put("api-key-value", AbstractViewConfig::asString);
        VALID_OPTIONS.put("fetch-credentials", FetchCredentials::byCode);
        DEFAULT_OPTIONS.put("show-header", Boolean.FALSE);
        DEFAULT_OPTIONS.put("theme", (Object)Theme.DARK);
        DEFAULT_OPTIONS.put("layout", (Object)Layout.ROW);
        DEFAULT_OPTIONS.put("sort-tags", Boolean.TRUE);
        DEFAULT_OPTIONS.put("sort-endpoints-by", (Object)EndPoint.METHOD);
    }

    static enum Layout {
        ROW,
        COLUMN;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum Theme {
        LIGHT,
        DARK;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum EndPoint {
        PATH,
        METHOD,
        SUMMARY,
        NONE;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum RenderStyle {
        READ,
        VIEW,
        FOCUSED;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum SchemaStyle {
        TREE,
        TABLE;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum DefaultSchemaTab {
        SCHEMA,
        EXAMPLE;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum SchemaHideWriteOnly {
        DEFAULT,
        NEVER;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum SchemaHideReadOnly {
        DEFAULT,
        NEVER;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum ApiKeyLocation {
        HEADER,
        QUERY;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum ShowMethodInNavBar {
        FALSE("false"),
        AS_PLAIN_TEXT("as-plain-text"),
        AS_COLORED_TEXT("as-colored-text"),
        AS_COLORED_BLOCK("as-colored-block");

        private static final Map<String, ShowMethodInNavBar> BY_CODE;
        private final String code;

        private ShowMethodInNavBar(String code) {
            this.code = code;
        }

        public String toString() {
            return this.code;
        }

        public static ShowMethodInNavBar byCode(String code) {
            ShowMethodInNavBar value = BY_CODE.get(code.toLowerCase());
            if (value == null) {
                throw new IllegalArgumentException("Unknown value " + code);
            }
            return value;
        }

        static {
            HashMap<String, ShowMethodInNavBar> byCode = new HashMap<String, ShowMethodInNavBar>(ShowMethodInNavBar.values().length);
            for (ShowMethodInNavBar showMethodInNavBar : ShowMethodInNavBar.values()) {
                byCode.put(showMethodInNavBar.code, showMethodInNavBar);
            }
            BY_CODE = Collections.unmodifiableMap(byCode);
        }
    }

    static enum FetchCredentials {
        OMIT("omit"),
        SAME_ORIGIN("same-origin"),
        INCLUDE("include");

        private static final Map<String, FetchCredentials> BY_CODE;
        private final String code;

        private FetchCredentials(String code) {
            this.code = code;
        }

        public String toString() {
            return this.code;
        }

        public static FetchCredentials byCode(String code) {
            FetchCredentials value = BY_CODE.get(code.toLowerCase());
            if (value == null) {
                throw new IllegalArgumentException("Unknown value " + code);
            }
            return value;
        }

        static {
            HashMap<String, FetchCredentials> byCode = new HashMap<String, FetchCredentials>(FetchCredentials.values().length);
            for (FetchCredentials navTagClick : FetchCredentials.values()) {
                byCode.put(navTagClick.code, navTagClick);
            }
            BY_CODE = Collections.unmodifiableMap(byCode);
        }
    }

    static enum NavTagClick {
        EXPAND_COLLAPSE("expand-collapse"),
        SHOW_DESCRIPTION("show-description");

        private static final Map<String, NavTagClick> BY_CODE;
        private final String code;

        private NavTagClick(String code) {
            this.code = code;
        }

        public String toString() {
            return this.code;
        }

        public static NavTagClick byCode(String code) {
            NavTagClick value = BY_CODE.get(code.toLowerCase());
            if (value == null) {
                throw new IllegalArgumentException("Unknown value " + code);
            }
            return value;
        }

        static {
            HashMap<String, NavTagClick> byCode = new HashMap<String, NavTagClick>(NavTagClick.values().length);
            for (NavTagClick navTagClick : NavTagClick.values()) {
                byCode.put(navTagClick.code, navTagClick);
            }
            BY_CODE = Collections.unmodifiableMap(byCode);
        }
    }

    static enum NavItemSpacing {
        DEFAULT,
        COMPACT,
        RELAXED;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum FontSize {
        DEFAULT,
        LARGE,
        LARGEST;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

