/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.balance.impl;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import org.apache.bifromq.basekv.balance.BalanceNow;
import org.apache.bifromq.basekv.balance.BalanceResult;
import org.apache.bifromq.basekv.balance.NoNeedBalance;
import org.apache.bifromq.basekv.balance.StoreBalancer;
import org.apache.bifromq.basekv.balance.command.BalanceCommand;
import org.apache.bifromq.basekv.balance.command.TransferLeadershipCommand;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.utils.DescriptorUtil;
import org.apache.bifromq.basekv.utils.EffectiveEpoch;
import org.apache.bifromq.basekv.utils.EffectiveRoute;
import org.apache.bifromq.basekv.utils.RangeLeader;

public class RangeLeaderBalancer
extends StoreBalancer {
    private volatile EffectiveEpoch effectiveEpoch = null;

    public RangeLeaderBalancer(String clusterId, String localStoreId) {
        super(clusterId, localStoreId);
    }

    public void update(Set<KVRangeStoreDescriptor> landscape) {
        Optional effectiveEpoch = DescriptorUtil.getEffectiveEpoch(landscape);
        if (effectiveEpoch.isEmpty()) {
            return;
        }
        this.effectiveEpoch = (EffectiveEpoch)effectiveEpoch.get();
    }

    public BalanceResult balance() {
        EffectiveEpoch currentEpoch = this.effectiveEpoch;
        if (currentEpoch == null) {
            return NoNeedBalance.INSTANCE;
        }
        EffectiveRoute effectiveRoute = DescriptorUtil.getEffectiveRoute((EffectiveEpoch)currentEpoch);
        if (effectiveRoute.leaderRanges().isEmpty()) {
            return NoNeedBalance.INSTANCE;
        }
        return this.balanceLeaderCount(effectiveRoute.leaderRanges());
    }

    private BalanceResult balanceLeaderCount(NavigableMap<Boundary, RangeLeader> effectiveRoute) {
        HashMap<String, Integer> storeLeaderCount = new HashMap<String, Integer>();
        for (Map.Entry entry : effectiveRoute.entrySet()) {
            String localStoreId = ((RangeLeader)entry.getValue()).storeId();
            KVRangeDescriptor rangeDescriptor = ((RangeLeader)entry.getValue()).descriptor();
            ClusterConfig clusterConfig = rangeDescriptor.getConfig();
            clusterConfig.getVotersList().forEach(voter -> storeLeaderCount.computeIfAbsent((String)voter, k -> 0));
            storeLeaderCount.compute(localStoreId, (k, v) -> v == null ? 1 : v + 1);
        }
        List<String> storeSortedByLeaderCount = storeLeaderCount.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).toList();
        String mostLeadersStore = storeSortedByLeaderCount.get(storeSortedByLeaderCount.size() - 1);
        String leastLeadersStore = storeSortedByLeaderCount.get(0);
        int mostLeadersCount = (Integer)storeLeaderCount.get(mostLeadersStore);
        int leastLeadersCount = (Integer)storeLeaderCount.get(leastLeadersStore);
        double totalLeaders = storeLeaderCount.values().stream().mapToInt(Integer::intValue).sum();
        double targetLeadersPerStore = totalLeaders / (double)storeLeaderCount.size();
        int atMostLeadersPerStore = (int)Math.ceil(targetLeadersPerStore);
        int atLeastLeadersPerStore = (int)Math.floor(targetLeadersPerStore);
        if (mostLeadersCount <= atMostLeadersPerStore && leastLeadersCount >= atLeastLeadersPerStore) {
            return NoNeedBalance.INSTANCE;
        }
        for (Map.Entry entry : effectiveRoute.entrySet()) {
            RangeLeader rangeLeader = (RangeLeader)entry.getValue();
            String leaderStoreId = rangeLeader.storeId();
            KVRangeDescriptor rangeDescriptor = rangeLeader.descriptor();
            ClusterConfig clusterConfig = rangeDescriptor.getConfig();
            HashSet voters = Sets.newHashSet((Iterable)clusterConfig.getVotersList());
            if (leaderStoreId.equals(mostLeadersStore)) {
                for (String underloadedStore : storeSortedByLeaderCount) {
                    int leaderCount = (Integer)storeLeaderCount.get(underloadedStore);
                    if (leaderCount + 1 > atMostLeadersPerStore || !voters.contains(underloadedStore) || underloadedStore.equals(leaderStoreId)) continue;
                    if (leaderStoreId.equals(this.localStoreId)) {
                        return BalanceNow.of((BalanceCommand)((TransferLeadershipCommand.TransferLeadershipCommandBuilder)((TransferLeadershipCommand.TransferLeadershipCommandBuilder)((TransferLeadershipCommand.TransferLeadershipCommandBuilder)TransferLeadershipCommand.builder().toStore(leaderStoreId)).kvRangeId(rangeDescriptor.getId())).expectedVer(rangeDescriptor.getVer())).newLeaderStore(underloadedStore).build());
                    }
                    return NoNeedBalance.INSTANCE;
                }
                continue;
            }
            int leaderCount = (Integer)storeLeaderCount.get(leaderStoreId);
            if (!voters.contains(leastLeadersStore) || leaderCount - 1 < atLeastLeadersPerStore) continue;
            if (leaderStoreId.equals(this.localStoreId)) {
                return BalanceNow.of((BalanceCommand)((TransferLeadershipCommand.TransferLeadershipCommandBuilder)((TransferLeadershipCommand.TransferLeadershipCommandBuilder)((TransferLeadershipCommand.TransferLeadershipCommandBuilder)TransferLeadershipCommand.builder().toStore(leaderStoreId)).kvRangeId(rangeDescriptor.getId())).expectedVer(rangeDescriptor.getVer())).newLeaderStore(leastLeadersStore).build());
            }
            return NoNeedBalance.INSTANCE;
        }
        return NoNeedBalance.INSTANCE;
    }
}

