/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3.signer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.aws.s3.signer.ImmutableS3SignResponse;
import org.apache.iceberg.aws.s3.signer.S3SignRequestParser;
import org.apache.iceberg.aws.s3.signer.S3SignResponse;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.JsonUtil;

public class S3SignResponseParser {
    private static final String URI = "uri";
    private static final String HEADERS = "headers";

    private S3SignResponseParser() {
    }

    public static String toJson(S3SignResponse request) {
        return S3SignResponseParser.toJson(request, false);
    }

    public static String toJson(S3SignResponse request, boolean pretty) {
        return JsonUtil.generate(gen -> S3SignResponseParser.toJson(request, gen), (boolean)pretty);
    }

    public static void toJson(S3SignResponse response, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != response ? 1 : 0) != 0, (Object)"Invalid s3 sign response: null");
        gen.writeStartObject();
        gen.writeStringField(URI, response.uri().toString());
        S3SignRequestParser.headersToJson(HEADERS, response.headers(), gen);
        gen.writeEndObject();
    }

    public static S3SignResponse fromJson(String json) {
        return (S3SignResponse)JsonUtil.parse((String)json, S3SignResponseParser::fromJson);
    }

    public static S3SignResponse fromJson(JsonNode json) {
        Preconditions.checkArgument((null != json ? 1 : 0) != 0, (Object)"Cannot parse s3 sign response from null object");
        Preconditions.checkArgument((boolean)json.isObject(), (String)"Cannot parse s3 sign response from non-object: %s", (Object)json);
        URI uri = java.net.URI.create(JsonUtil.getString((String)URI, (JsonNode)json));
        Map<String, List<String>> headers = S3SignRequestParser.headersFromJson(HEADERS, json);
        return ImmutableS3SignResponse.builder().uri(uri).headers(headers).build();
    }
}

