/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.models;

import com.azure.storage.file.datalake.implementation.util.AccessorUtility;
import com.azure.storage.file.datalake.models.PathPermissions;
import java.time.OffsetDateTime;

public final class PathSystemProperties {
    private final OffsetDateTime creationTime;
    private final OffsetDateTime lastModified;
    private final String eTag;
    private final Long fileSize;
    private final Boolean isDirectory;
    private final Boolean isServerEncrypted;
    private final String encryptionKeySha256;
    private final OffsetDateTime expiresOn;
    private final String encryptionScope;
    private final String encryptionContext;
    private final String owner;
    private final String group;
    private final PathPermissions permissions;

    public PathSystemProperties() {
        this.creationTime = null;
        this.lastModified = null;
        this.eTag = null;
        this.fileSize = null;
        this.isDirectory = null;
        this.isServerEncrypted = null;
        this.encryptionKeySha256 = null;
        this.expiresOn = null;
        this.encryptionScope = null;
        this.encryptionContext = null;
        this.owner = null;
        this.group = null;
        this.permissions = null;
    }

    PathSystemProperties(OffsetDateTime creationTime, OffsetDateTime lastModified, String eTag, Long fileSize, Boolean isDirectory, Boolean isServerEncrypted, String encryptionKeySha256, OffsetDateTime expiresOn, String encryptionScope, String encryptionContext, String owner, String group, PathPermissions permissions) {
        this.creationTime = creationTime;
        this.lastModified = lastModified;
        this.eTag = eTag;
        this.fileSize = fileSize;
        this.isDirectory = isDirectory;
        this.isServerEncrypted = isServerEncrypted;
        this.encryptionKeySha256 = encryptionKeySha256;
        this.expiresOn = expiresOn;
        this.encryptionScope = encryptionScope;
        this.encryptionContext = encryptionContext;
        this.owner = owner;
        this.group = group;
        this.permissions = permissions;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public String getETag() {
        return this.eTag;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public Boolean isDirectory() {
        return this.isDirectory;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public String getEncryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    public String getEncryptionContext() {
        return this.encryptionContext;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public PathPermissions getPermissions() {
        return this.permissions;
    }

    static {
        AccessorUtility.setPathSystemPropertiesAccessor(PathSystemProperties::new);
    }
}

