/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingSpanNameExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.RpcAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.RpcClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.AbstractSqsRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.AwsSdkExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.AwsSdkHttpAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.AwsSdkHttpClientSuppressionAttributesExtractor;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.AwsSdkRpcAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.Response;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsParentContext;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsProcessRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsProcessRequestAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsReceiveRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsReceiveRequestAttributesGetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;

public final class AwsSdkInstrumenterFactory {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.aws-sdk-2.2";
    private static final AttributesExtractor<ExecutionAttributes, Response> rpcAttributesExtractor = RpcClientAttributesExtractor.create((RpcAttributesGetter)AwsSdkRpcAttributesGetter.INSTANCE);
    private static final AwsSdkExperimentalAttributesExtractor experimentalAttributesExtractor = new AwsSdkExperimentalAttributesExtractor();
    static final AwsSdkHttpAttributesGetter httpAttributesGetter = new AwsSdkHttpAttributesGetter();
    static final AttributesExtractor<ExecutionAttributes, Response> httpAttributesExtractor = HttpClientAttributesExtractor.create((HttpClientAttributesGetter)httpAttributesGetter);
    private static final AttributesExtractor<ExecutionAttributes, Response> httpClientSuppressionAttributesExtractor = new AwsSdkHttpClientSuppressionAttributesExtractor();
    private static final List<AttributesExtractor<ExecutionAttributes, Response>> defaultAttributesExtractors = Arrays.asList(rpcAttributesExtractor, httpClientSuppressionAttributesExtractor);
    private static final List<AttributesExtractor<ExecutionAttributes, Response>> extendedAttributesExtractors = Arrays.asList(rpcAttributesExtractor, experimentalAttributesExtractor, httpClientSuppressionAttributesExtractor);
    private static final List<AttributesExtractor<ExecutionAttributes, Response>> defaultConsumerAttributesExtractors = Arrays.asList(rpcAttributesExtractor, httpAttributesExtractor);
    private static final List<AttributesExtractor<ExecutionAttributes, Response>> extendedConsumerAttributesExtractors = Arrays.asList(rpcAttributesExtractor, httpAttributesExtractor, experimentalAttributesExtractor);
    private final OpenTelemetry openTelemetry;
    @Nullable
    private final TextMapPropagator messagingPropagator;
    private final List<String> capturedHeaders;
    private final boolean captureExperimentalSpanAttributes;
    private final boolean messagingReceiveInstrumentationEnabled;
    private final boolean useXrayPropagator;

    public AwsSdkInstrumenterFactory(OpenTelemetry openTelemetry, @Nullable TextMapPropagator messagingPropagator, List<String> capturedHeaders, boolean captureExperimentalSpanAttributes, boolean messagingReceiveInstrumentationEnabled, boolean useXrayPropagator) {
        this.openTelemetry = openTelemetry;
        this.messagingPropagator = messagingPropagator;
        this.capturedHeaders = capturedHeaders;
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        this.messagingReceiveInstrumentationEnabled = messagingReceiveInstrumentationEnabled;
        this.useXrayPropagator = useXrayPropagator;
    }

    public Instrumenter<ExecutionAttributes, Response> requestInstrumenter() {
        return AwsSdkInstrumenterFactory.createInstrumenter(this.openTelemetry, AwsSdkInstrumenterFactory::spanName, SpanKindExtractor.alwaysClient(), this.attributesExtractors(), Collections.emptyList(), true);
    }

    private List<AttributesExtractor<ExecutionAttributes, Response>> attributesExtractors() {
        return this.captureExperimentalSpanAttributes ? extendedAttributesExtractors : defaultAttributesExtractors;
    }

    private List<AttributesExtractor<ExecutionAttributes, Response>> consumerAttributesExtractors() {
        return this.captureExperimentalSpanAttributes ? extendedConsumerAttributesExtractors : defaultConsumerAttributesExtractors;
    }

    private <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> messagingAttributesExtractor(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation) {
        return MessagingAttributesExtractor.builder(getter, (MessageOperation)operation).setCapturedHeaders(this.capturedHeaders).build();
    }

    public Instrumenter<SqsReceiveRequest, Response> consumerReceiveInstrumenter() {
        MessageOperation operation = MessageOperation.RECEIVE;
        SqsReceiveRequestAttributesGetter getter = SqsReceiveRequestAttributesGetter.INSTANCE;
        AttributesExtractor<SqsReceiveRequest, Response> messagingAttributeExtractor = this.messagingAttributesExtractor(getter, operation);
        return AwsSdkInstrumenterFactory.createInstrumenter(this.openTelemetry, MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation), SpanKindExtractor.alwaysConsumer(), AwsSdkInstrumenterFactory.toSqsRequestExtractors(this.consumerAttributesExtractors()), Collections.singletonList(messagingAttributeExtractor), this.messagingReceiveInstrumentationEnabled);
    }

    public Instrumenter<SqsProcessRequest, Response> consumerProcessInstrumenter() {
        MessageOperation operation = MessageOperation.PROCESS;
        SqsProcessRequestAttributesGetter getter = SqsProcessRequestAttributesGetter.INSTANCE;
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractors(AwsSdkInstrumenterFactory.toSqsRequestExtractors(this.consumerAttributesExtractors())).addAttributesExtractor(this.messagingAttributesExtractor(getter, operation));
        if (this.messagingReceiveInstrumentationEnabled) {
            builder.addSpanLinksExtractor((spanLinks, parentContext, request) -> {
                Context extracted = SqsParentContext.ofMessage(request.getMessage(), this.messagingPropagator, this.useXrayPropagator);
                spanLinks.addLink(Span.fromContext((Context)extracted).getSpanContext());
            });
        }
        return builder.buildInstrumenter(SpanKindExtractor.alwaysConsumer());
    }

    private static List<AttributesExtractor<AbstractSqsRequest, Response>> toSqsRequestExtractors(List<AttributesExtractor<ExecutionAttributes, Response>> extractors) {
        ArrayList<AttributesExtractor<AbstractSqsRequest, Response>> result = new ArrayList<AttributesExtractor<AbstractSqsRequest, Response>>();
        for (final AttributesExtractor<ExecutionAttributes, Response> extractor : extractors) {
            result.add(new AttributesExtractor<AbstractSqsRequest, Response>(){

                public void onStart(AttributesBuilder attributes, Context parentContext, AbstractSqsRequest sqsRequest) {
                    extractor.onStart(attributes, parentContext, (Object)sqsRequest.getRequest());
                }

                public void onEnd(AttributesBuilder attributes, Context context, AbstractSqsRequest sqsRequest, @Nullable Response response, @Nullable Throwable error) {
                    extractor.onEnd(attributes, context, (Object)sqsRequest.getRequest(), (Object)response, error);
                }
            });
        }
        return result;
    }

    public Instrumenter<ExecutionAttributes, Response> producerInstrumenter() {
        MessageOperation operation = MessageOperation.PUBLISH;
        SqsAttributesGetter getter = SqsAttributesGetter.INSTANCE;
        AttributesExtractor<ExecutionAttributes, Response> messagingAttributeExtractor = this.messagingAttributesExtractor(getter, operation);
        return AwsSdkInstrumenterFactory.createInstrumenter(this.openTelemetry, MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation), SpanKindExtractor.alwaysProducer(), this.attributesExtractors(), Collections.singletonList(messagingAttributeExtractor), true);
    }

    private static <REQUEST, RESPONSE> Instrumenter<REQUEST, RESPONSE> createInstrumenter(OpenTelemetry openTelemetry, SpanNameExtractor<REQUEST> spanNameExtractor, SpanKindExtractor<REQUEST> spanKindExtractor, List<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributeExtractors, List<AttributesExtractor<REQUEST, RESPONSE>> additionalAttributeExtractors, boolean enabled) {
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, spanNameExtractor).addAttributesExtractors(attributeExtractors).addAttributesExtractors(additionalAttributeExtractors).setEnabled(enabled).buildInstrumenter(spanKindExtractor);
    }

    private static String spanName(ExecutionAttributes attributes) {
        String awsServiceName = (String)attributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME);
        String awsOperation = (String)attributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME);
        return awsServiceName + "." + awsOperation;
    }
}

