/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import org.apache.polaris.core.admin.model.CatalogRole;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;

public class CatalogRoleEntity
extends PolarisEntity {
    public CatalogRoleEntity(PolarisBaseEntity sourceEntity) {
        super(sourceEntity);
        Preconditions.checkState((this.getType() == PolarisEntityType.CATALOG_ROLE ? 1 : 0) != 0, (String)"Invalid entity type: %s", (Object)((Object)this.getType()));
        Preconditions.checkState((this.getSubType() == PolarisEntitySubType.NULL_SUBTYPE ? 1 : 0) != 0, (String)"Invalid entity sub type: %s", (Object)((Object)this.getSubType()));
    }

    @Nullable
    public static CatalogRoleEntity of(@Nullable PolarisBaseEntity sourceEntity) {
        if (sourceEntity != null) {
            return new CatalogRoleEntity(sourceEntity);
        }
        return null;
    }

    public static CatalogRoleEntity fromCatalogRole(CatalogRole catalogRole) {
        return ((Builder)((Builder)new Builder().setName(catalogRole.getName())).setProperties(catalogRole.getProperties())).build();
    }

    public CatalogRole asCatalogRole() {
        CatalogRole catalogRole = new CatalogRole(this.getName(), this.getPropertiesAsMap(), Long.valueOf(this.getCreateTimestamp()), Long.valueOf(this.getLastUpdateTimestamp()), Integer.valueOf(this.getEntityVersion()));
        return catalogRole;
    }

    public static class Builder
    extends PolarisEntity.BaseBuilder<CatalogRoleEntity, Builder> {
        public Builder() {
            this.setType(PolarisEntityType.CATALOG_ROLE);
        }

        public Builder(CatalogRoleEntity original) {
            super(original);
        }

        @Override
        public CatalogRoleEntity build() {
            return new CatalogRoleEntity(this.buildBase());
        }
    }
}

