/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LimitNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.MergeSortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TopKNode;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Capture;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class MergeLimitWithMergeSort
implements Rule<LimitNode> {
    private static final Capture<MergeSortNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.mergeSort().capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        MergeSortNode mergeSortNode = captures.get(CHILD);
        PlanNode childOfMergeSort = context.getLookup().resolve(mergeSortNode.getChildren().get(0));
        TopKNode topKNode = MergeLimitWithMergeSort.transformByMergeSortNode(parent, mergeSortNode, childOfMergeSort, context);
        return Rule.Result.ofPlanNode(topKNode);
    }

    static TopKNode transformByMergeSortNode(LimitNode parent, MergeSortNode mergeSortNode, PlanNode childOfMergeSort, Rule.Context context) {
        TopKNode topKNode = new TopKNode(parent.getPlanNodeId(), mergeSortNode.getOrderingScheme(), parent.getCount(), childOfMergeSort.getOutputSymbols(), true);
        for (PlanNode child : mergeSortNode.getChildren()) {
            LimitNode limitNode = new LimitNode(context.getIdAllocator().genPlanNodeId(), child, parent.getCount(), Optional.empty());
            topKNode.addChild(limitNode);
        }
        return topKNode;
    }
}

