/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.other;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.queryengine.common.NodeRef;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.binary.WhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.NullOperand;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDTFExecutor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class CaseWhenThenExpression
extends Expression {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(CaseWhenThenExpression.class);
    protected List<WhenThenExpression> whenThenExpressions = new ArrayList<WhenThenExpression>();
    protected Expression elseExpression;

    public CaseWhenThenExpression(List<WhenThenExpression> whenThenExpressions, Expression elseExpression) {
        this.whenThenExpressions = whenThenExpressions;
        this.elseExpression = elseExpression;
        if (this.elseExpression == null) {
            this.elseExpression = new NullOperand();
        }
    }

    public CaseWhenThenExpression(ByteBuffer byteBuffer) {
        int len = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        Validate.isTrue((len > 0 ? 1 : 0) != 0, (String)"the length of CaseWhenThenExpression's whenThenList must greater than 0", (Object[])new Object[0]);
        for (int i = 0; i < len; ++i) {
            Expression expression = Expression.deserialize(byteBuffer);
            this.whenThenExpressions.add((WhenThenExpression)expression);
        }
        this.elseExpression = Expression.deserialize(byteBuffer);
    }

    public void setElseExpression(Expression expression) {
        this.elseExpression = expression;
    }

    public List<WhenThenExpression> getWhenThenExpressions() {
        return this.whenThenExpressions;
    }

    public Expression getElseExpression() {
        return this.elseExpression;
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.CASE_WHEN_THEN;
    }

    @Override
    public boolean isMappable(Map<NodeRef<Expression>, TSDataType> expressionTypes) {
        for (Expression expression : this.getExpressions()) {
            if (expression.isMappable(expressionTypes)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isConstantOperandInternal() {
        for (Expression expression : this.getExpressions()) {
            if (expression.isConstantOperand()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void constructUdfExecutors(Map<String, UDTFExecutor> expressionName2Executor, ZoneId zoneId) {
        for (Expression expression : this.getExpressions()) {
            expression.constructUdfExecutors(expressionName2Executor, zoneId);
        }
    }

    @Override
    public void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> inputLocations) {
        this.getExpressions().forEach(expression -> expression.bindInputLayerColumnIndexWithExpression(inputLocations));
        String digest = this.getExpressionString();
        if (inputLocations.containsKey(digest)) {
            this.inputColumnIndex = inputLocations.get(digest).get(0).getValueColumnIndex();
        }
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        this.getExpressions().forEach(expression -> expression.updateStatisticsForMemoryAssigner(memoryAssigner));
        memoryAssigner.increaseExpressionReference(this);
    }

    @Override
    protected String getExpressionStringInternal() {
        StringBuilder builder = new StringBuilder();
        builder.append("CASE ");
        for (Expression expression : this.whenThenExpressions) {
            builder.append(expression.getExpressionString()).append(" ");
        }
        if (!(this.elseExpression instanceof NullOperand)) {
            builder.append("ELSE ").append(this.elseExpression.getExpressionString()).append(" ");
        }
        builder.append("END");
        return builder.toString();
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        int len = this.whenThenExpressions.size();
        ReadWriteIOUtils.write((int)len, (ByteBuffer)byteBuffer);
        this.getExpressions().forEach(child -> Expression.serialize(child, byteBuffer));
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.whenThenExpressions.size(), (OutputStream)stream);
        for (Expression expression : this.getExpressions()) {
            Expression.serialize(expression, stream);
        }
    }

    @Override
    public List<Expression> getExpressions() {
        ArrayList<Expression> result = new ArrayList<Expression>(this.whenThenExpressions);
        result.add((WhenThenExpression)this.elseExpression);
        return result;
    }

    @Override
    public String getOutputSymbolInternal() {
        StringBuilder builder = new StringBuilder();
        builder.append("CASE ");
        for (Expression expression : this.whenThenExpressions) {
            builder.append(expression.getOutputSymbol()).append(" ");
        }
        if (!(this.elseExpression instanceof NullOperand)) {
            builder.append("ELSE ").append(this.elseExpression.getOutputSymbol()).append(" ");
        }
        builder.append("END");
        return builder.toString();
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitCaseWhenThenExpression(this, context);
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.elseExpression) + (this.whenThenExpressions == null ? 0L : this.whenThenExpressions.stream().mapToLong(MemoryEstimationHelper::getEstimatedSizeOfAccountableObject).sum());
    }
}

