/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.tika.config.Field;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.io.EndianUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Photoshop;
import org.apache.tika.metadata.TIFF;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.image.AbstractImageParser;
import org.apache.tika.parser.image.ImageMetadataExtractor;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BPGParser
extends AbstractImageParser {
    protected static final int EXTENSION_TAG_EXIF = 1;
    protected static final int EXTENSION_TAG_ICC_PROFILE = 2;
    protected static final int EXTENSION_TAG_XMP = 3;
    protected static final int EXTENSION_TAG_THUMBNAIL = 4;
    private static final int DEFAULT_MAX_RECORD_LENGTH = 0x3200000;
    private static final long serialVersionUID = -161736541253892772L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.image("x-bpg"), MediaType.image("bpg"))));
    private int maxRecordLength = 0x3200000;

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    void extractMetadata(InputStream stream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        byte[] signature = new byte[4];
        IOUtils.readFully(stream, signature);
        if (signature[0] != 66 || signature[1] != 80 || signature[2] != 71 || signature[3] != -5) {
            throw new TikaException("BPG magic signature invalid");
        }
        int pdf = stream.read();
        int pixelFormat = pdf & 7;
        boolean hasAlphaPlane1 = (pdf & 8) == 8;
        int bitDepth = (pdf >> 4) + 8;
        metadata.set(TIFF.BITS_PER_SAMPLE, Integer.toString(bitDepth));
        int cer = stream.read();
        int colourSpace = cer & 0x15;
        switch (colourSpace) {
            case 0: {
                metadata.set(Photoshop.COLOR_MODE, "YCbCr Colour");
                break;
            }
            case 1: {
                metadata.set(Photoshop.COLOR_MODE, "RGB Colour");
                break;
            }
            case 2: {
                metadata.set(Photoshop.COLOR_MODE, "YCgCo Colour");
                break;
            }
            case 3: {
                metadata.set(Photoshop.COLOR_MODE, "YCbCrK Colour");
                break;
            }
            case 4: {
                metadata.set(Photoshop.COLOR_MODE, "CMYK Colour");
            }
        }
        boolean hasExtensions = (cer & 0x10) == 16;
        boolean hasAlphaPlane2 = (cer & 0x20) == 32;
        int width = (int)EndianUtils.readUE7(stream);
        int height = (int)EndianUtils.readUE7(stream);
        metadata.set(TIFF.IMAGE_LENGTH, height);
        metadata.set(TIFF.IMAGE_WIDTH, width);
        EndianUtils.readUE7(stream);
        long extensionDataLength = 0L;
        if (hasExtensions) {
            extensionDataLength = EndianUtils.readUE7(stream);
        }
        long alphaDataLength = 0L;
        if (hasAlphaPlane1 || hasAlphaPlane2) {
            alphaDataLength = EndianUtils.readUE7(stream);
        }
        if (hasExtensions) {
            int extensionLength;
            ImageMetadataExtractor metadataExtractor = new ImageMetadataExtractor(metadata);
            block11: for (long extensionsDataSeen = 0L; extensionsDataSeen < extensionDataLength; extensionsDataSeen += (long)extensionLength) {
                int extensionType = (int)EndianUtils.readUE7(stream);
                extensionLength = (int)EndianUtils.readUE7(stream);
                if (extensionLength > this.maxRecordLength) {
                    throw new TikaMemoryLimitException("extension length (" + extensionLength + " bytes) is greater than 'maxRecordLength' (" + this.maxRecordLength + " bytes).  If this file is not corrupt, consider bumping the maxRecordLength via tika-config.xml");
                }
                switch (extensionType) {
                    case 1: {
                        metadataExtractor.parseRawExif(stream, extensionLength, true);
                        continue block11;
                    }
                    case 3: {
                        this.handleXMP(stream, extensionLength, metadataExtractor);
                        continue block11;
                    }
                    default: {
                        IOUtils.skipFully(stream, (long)extensionLength);
                    }
                }
            }
        }
    }

    @Field
    public void setMaxRecordLength(int maxRecordLength) {
        this.maxRecordLength = maxRecordLength;
    }

    protected void handleXMP(InputStream stream, int xmpLength, ImageMetadataExtractor extractor) throws IOException, TikaException, SAXException {
        if (xmpLength < 0) {
            throw new TikaException("xmp length must be >= 0");
        }
        if (xmpLength > this.maxRecordLength) {
            throw new TikaMemoryLimitException("xmplength (" + xmpLength + " bytes) is larger than maxXMPLength (" + this.maxRecordLength + "). Consider setting maxXMPLength to a greater value for this parser via tika-config.xml if this file is not corrupt.");
        }
        byte[] xmp = new byte[xmpLength];
        IOUtils.readFully(stream, xmp);
        extractor.parseRawXMP(xmp);
    }
}

