/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.jmap.api.model.UploadNotFoundException;
import org.apache.james.jmap.api.upload.UploadRepository;
import org.apache.james.jmap.draft.exceptions.BlobNotFoundException;
import org.apache.james.jmap.draft.methods.BlobManager;
import org.apache.james.jmap.draft.model.Blob;
import org.apache.james.jmap.draft.model.BlobId;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.Function0;

public class BlobManagerImpl
implements BlobManager {
    public static final ContentType MESSAGE_RFC822_CONTENT_TYPE = ContentType.of((String)"message/rfc822");
    public static final String UPLOAD_PREFIX = "upload-";
    private final AttachmentManager attachmentManager;
    private final MessageIdManager messageIdManager;
    private final MessageId.Factory messageIdFactory;
    private final UploadRepository uploadRepository;

    @Inject
    public BlobManagerImpl(AttachmentManager attachmentManager, MessageIdManager messageIdManager, MessageId.Factory messageIdFactory, UploadRepository uploadRepository) {
        this.attachmentManager = attachmentManager;
        this.messageIdManager = messageIdManager;
        this.messageIdFactory = messageIdFactory;
        this.uploadRepository = uploadRepository;
    }

    @Override
    public Publisher<Blob> retrieve(Collection<BlobId> blobIds, MailboxSession session) {
        ImmutableSet supplied = ImmutableSet.copyOf(blobIds);
        Set encodingUploads = (Set)blobIds.stream().filter(blobId -> blobId.asUploadId().isPresent()).collect(ImmutableSet.toImmutableSet());
        Sets.SetView notEncodingUploads = Sets.difference((Set)supplied, (Set)encodingUploads);
        Flux uploads = Flux.fromIterable((Iterable)encodingUploads).flatMap(blobId -> this.getBlobFromUpload((BlobId)blobId, session));
        List notEncodingUploadsAsAttachmentIds = (List)notEncodingUploads.stream().map(BlobId::asAttachmentId).collect(ImmutableList.toImmutableList());
        Flux attachmentOrMessage = Mono.fromCallable(() -> this.attachmentManager.getAttachments(notEncodingUploadsAsAttachmentIds, session)).flatMapIterable(Function.identity()).map(attachment -> this.loadAttachmentContent((AttachmentMetadata)attachment, session)).collect(ImmutableList.toImmutableList()).flatMapMany(arg_0 -> this.lambda$retrieve$5((Set)notEncodingUploads, session, arg_0));
        return Flux.merge((Publisher[])new Publisher[]{uploads, attachmentOrMessage});
    }

    @Override
    public Blob retrieve(BlobId blobId, MailboxSession mailboxSession) throws MailboxException, BlobNotFoundException {
        try {
            return (Blob)this.getBlobFromUpload(blobId, mailboxSession).switchIfEmpty(Mono.fromCallable(() -> this.getBlobFromAttachment(blobId, mailboxSession)).handle(ReactorUtils.publishIfPresent())).switchIfEmpty(this.getBlobFromMessage(blobId, mailboxSession)).switchIfEmpty(Mono.error(() -> new BlobNotFoundException(blobId))).block();
        }
        catch (Exception e) {
            if (e.getCause() instanceof MailboxException) {
                throw (MailboxException)e.getCause();
            }
            throw e;
        }
    }

    private Mono<Blob> getBlobFromUpload(BlobId blobId, MailboxSession mailboxSession) {
        return blobId.asUploadId().map(uploadId -> Mono.from((Publisher)this.uploadRepository.retrieve(uploadId, mailboxSession.getUser())).map(upload -> Blob.builder().id(blobId).contentType(upload.contentType()).size(upload.sizeAsLong()).payload(() -> ((Function0)upload.content()).apply()).build()).onErrorResume(UploadNotFoundException.class, e -> Mono.empty())).orElse(Mono.empty());
    }

    private Optional<Blob> getBlobFromAttachment(BlobId blobId, MailboxSession mailboxSession) throws MailboxException {
        try {
            AttachmentId attachmentId = blobId.asAttachmentId();
            AttachmentMetadata attachment = this.attachmentManager.getAttachment(attachmentId, mailboxSession);
            return Optional.of(this.loadAttachmentContent(attachment, mailboxSession));
        }
        catch (AttachmentNotFoundException e) {
            return Optional.empty();
        }
    }

    private Blob loadAttachmentContent(AttachmentMetadata attachment, MailboxSession mailboxSession) {
        BlobId blobId = BlobId.of(attachment.getAttachmentId());
        return Blob.builder().id(blobId).payload(() -> {
            try {
                return this.attachmentManager.loadAttachmentContent(attachment.getAttachmentId(), mailboxSession);
            }
            catch (AttachmentNotFoundException e) {
                throw new BlobNotFoundException(blobId, (Throwable)e);
            }
        }).size(attachment.getSize()).contentType(attachment.getType()).build();
    }

    private Mono<Blob> getBlobFromMessage(BlobId blobId, MailboxSession mailboxSession) {
        return this.retrieveMessageId(blobId).flatMap(messageId -> this.loadMessageAsInputStream((MessageId)messageId, mailboxSession)).map((Function)Throwing.function(content -> Blob.builder().id(blobId).contentType(MESSAGE_RFC822_CONTENT_TYPE).size(content.size()).payload(() -> ((Content)content).getInputStream()).build()));
    }

    private Mono<MessageId> retrieveMessageId(BlobId blobId) {
        try {
            return Mono.just((Object)this.messageIdFactory.fromString(blobId.getRawValue()));
        }
        catch (IllegalArgumentException e) {
            return Mono.empty();
        }
    }

    private Mono<Content> loadMessageAsInputStream(MessageId messageId, MailboxSession mailboxSession) {
        return Flux.from((Publisher)this.messageIdManager.getMessagesReactive((Collection)ImmutableSet.of((Object)messageId), FetchGroup.FULL_CONTENT, mailboxSession)).map((Function)Throwing.function(MessageResult::getFullContent)).next();
    }

    private /* synthetic */ Publisher lambda$retrieve$5(Set notEncodingUploads, MailboxSession session, ImmutableList attachmentsBlobs) {
        Set attachmentBlobIds = (Set)attachmentsBlobs.stream().map(Blob::getBlobId).collect(ImmutableSet.toImmutableSet());
        Sets.SetView messageBlobIds = Sets.difference((Set)notEncodingUploads, (Set)attachmentBlobIds);
        return Flux.merge((Publisher[])new Publisher[]{Flux.fromIterable((Iterable)attachmentsBlobs), Flux.fromIterable((Iterable)messageBlobIds).flatMap(blobId -> this.getBlobFromMessage((BlobId)blobId, session))});
    }
}

