/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.api;

import com.google.common.base.Optional;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.io.FileBackedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobPartsId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobType;
import org.apache.james.blob.api.BucketName;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuple2;

public interface Store<T, I> {
    public static final int FILE_THRESHOLD = 102400;

    public Mono<I> save(T var1);

    public Mono<T> read(I var1);

    public Publisher<Void> delete(I var1);

    public static class DelegateCloseableByteSource
    extends CloseableByteSource {
        private final ByteSource wrapped;
        private final Closeable closeable;

        DelegateCloseableByteSource(ByteSource wrapped, Closeable closeable) {
            this.wrapped = wrapped;
            this.closeable = closeable;
        }

        public InputStream openStream() throws IOException {
            return this.wrapped.openStream();
        }

        public CharSource asCharSource(Charset charset) {
            return this.wrapped.asCharSource(charset);
        }

        public InputStream openBufferedStream() throws IOException {
            return this.wrapped.openBufferedStream();
        }

        public ByteSource slice(long offset, long length) {
            return this.wrapped.slice(offset, length);
        }

        public boolean isEmpty() throws IOException {
            return this.wrapped.isEmpty();
        }

        public Optional<Long> sizeIfKnown() {
            return this.wrapped.sizeIfKnown();
        }

        public long size() throws IOException {
            return this.wrapped.size();
        }

        public long copyTo(OutputStream output) throws IOException {
            return this.wrapped.copyTo(output);
        }

        public long copyTo(ByteSink sink) throws IOException {
            return this.wrapped.copyTo(sink);
        }

        public byte[] read() throws IOException {
            return this.wrapped.read();
        }

        public <T> T read(ByteProcessor<T> processor) throws IOException {
            return (T)this.wrapped.read(processor);
        }

        public HashCode hash(HashFunction hashFunction) throws IOException {
            return this.wrapped.hash(hashFunction);
        }

        public boolean contentEquals(ByteSource other) throws IOException {
            return this.wrapped.contentEquals(other);
        }

        @Override
        public void close() throws IOException {
            this.closeable.close();
        }
    }

    public static abstract class CloseableByteSource
    extends ByteSource
    implements Closeable {
    }

    public static class Impl<T, I extends BlobPartsId>
    implements Store<T, I> {
        public static final int DEFAULT_CONCURRENCY = 16;
        private final BlobPartsId.Factory<I> idFactory;
        private final Encoder<T> encoder;
        private final Decoder<T> decoder;
        private final BlobStore blobStore;

        public Impl(BlobPartsId.Factory<I> idFactory, Encoder<T> encoder, Decoder<T> decoder, BlobStore blobStore) {
            this.idFactory = idFactory;
            this.encoder = encoder;
            this.decoder = decoder;
            this.blobStore = blobStore;
        }

        @Override
        public Mono<I> save(T t) {
            return Flux.fromStream(this.encoder.encode(t)).flatMapSequential(this::saveEntry).collectMap(Tuple2::getT1, Tuple2::getT2).map(arg_0 -> this.idFactory.generate(arg_0));
        }

        private Mono<Tuple2<BlobType, BlobId>> saveEntry(Pair<BlobType, ValueToSave> entry) {
            return Mono.just((Object)((BlobType)entry.getLeft())).zipWith(((ValueToSave)entry.getRight()).saveIn(this.blobStore.getDefaultBucketName(), this.blobStore));
        }

        @Override
        public Mono<T> read(I blobIds) {
            return Flux.fromIterable(blobIds.asMap().entrySet()).publishOn(Schedulers.elastic()).collectMap(Map.Entry::getKey, entry -> this.readByteSource(this.blobStore.getDefaultBucketName(), (BlobId)entry.getValue(), ((BlobType)entry.getKey()).getStoragePolicy())).map(this.decoder::decode);
        }

        private CloseableByteSource readByteSource(BucketName bucketName, BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
            DelegateCloseableByteSource delegateCloseableByteSource;
            block8: {
                FileBackedOutputStream out = new FileBackedOutputStream(102400);
                InputStream in = this.blobStore.read(bucketName, blobId, storagePolicy);
                try {
                    in.transferTo((OutputStream)out);
                    delegateCloseableByteSource = new DelegateCloseableByteSource(out.asByteSource(), () -> ((FileBackedOutputStream)out).reset());
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                in.close();
            }
            return delegateCloseableByteSource;
        }

        @Override
        public Publisher<Void> delete(I blobIds) {
            return Flux.fromIterable(blobIds.asMap().values()).flatMap(id -> this.blobStore.delete(this.blobStore.getDefaultBucketName(), id), 16).then();
        }

        @FunctionalInterface
        public static interface Decoder<T> {
            public T decode(Map<BlobType, CloseableByteSource> var1);
        }

        @FunctionalInterface
        public static interface Encoder<T> {
            public Stream<Pair<BlobType, ValueToSave>> encode(T var1);
        }

        @FunctionalInterface
        public static interface ValueToSave {
            public Mono<BlobId> saveIn(BucketName var1, BlobStore var2);
        }
    }
}

