/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.change;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.init.CassandraZonedDateTimeModule;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.jmap.api.change.EmailChange;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.model.MessageId;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EmailChangeRepositoryDAO {
    private final CassandraAsyncExecutor executor;
    private final UserType zonedDateTimeUserType;
    private final PreparedStatement insertStatement;
    private final PreparedStatement selectAllStatement;
    private final PreparedStatement selectFromStatement;
    private final PreparedStatement selectLatestStatement;
    private final PreparedStatement selectLatestNotDelegatedStatement;

    @Inject
    public EmailChangeRepositoryDAO(Session session, CassandraTypesProvider cassandraTypesProvider) {
        this.executor = new CassandraAsyncExecutor(session);
        this.zonedDateTimeUserType = cassandraTypesProvider.getDefinedUserType("zonedDateTime");
        this.insertStatement = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"email_change").value("account_id", (Object)QueryBuilder.bindMarker((String)"account_id")).value("state", (Object)QueryBuilder.bindMarker((String)"state")).value("date", (Object)QueryBuilder.bindMarker((String)"date")).value("is_delegated", (Object)QueryBuilder.bindMarker((String)"is_delegated")).value("created", (Object)QueryBuilder.bindMarker((String)"created")).value("updated", (Object)QueryBuilder.bindMarker((String)"updated")).value("destroyed", (Object)QueryBuilder.bindMarker((String)"destroyed")));
        this.selectAllStatement = session.prepare((RegularStatement)QueryBuilder.select().from("email_change").where(QueryBuilder.eq((String)"account_id", (Object)QueryBuilder.bindMarker((String)"account_id"))).orderBy(new Ordering[]{QueryBuilder.asc((String)"state")}));
        this.selectFromStatement = session.prepare((RegularStatement)QueryBuilder.select().from("email_change").where(QueryBuilder.eq((String)"account_id", (Object)QueryBuilder.bindMarker((String)"account_id"))).and(QueryBuilder.gte((String)"state", (Object)QueryBuilder.bindMarker((String)"state"))).orderBy(new Ordering[]{QueryBuilder.asc((String)"state")}));
        this.selectLatestStatement = session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"state"}).from("email_change").where(QueryBuilder.eq((String)"account_id", (Object)QueryBuilder.bindMarker((String)"account_id"))).orderBy(new Ordering[]{QueryBuilder.desc((String)"state")}).limit(1));
        this.selectLatestNotDelegatedStatement = session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"state"}).from("email_change").where(QueryBuilder.eq((String)"account_id", (Object)QueryBuilder.bindMarker((String)"account_id"))).and(QueryBuilder.eq((String)"is_delegated", (Object)false)).orderBy(new Ordering[]{QueryBuilder.desc((String)"state")}).limit(1).allowFiltering());
    }

    Mono<Void> insert(EmailChange change) {
        return this.executor.executeVoid((Statement)this.insertStatement.bind().setString("account_id", change.getAccountId().getIdentifier()).setUUID("state", change.getState().getValue()).setBool("is_delegated", change.isDelegated()).setSet("created", this.toUuidSet(change.getCreated()), UUID.class).setSet("updated", this.toUuidSet(change.getUpdated()), UUID.class).setSet("destroyed", this.toUuidSet(change.getDestroyed()), UUID.class).setUDTValue("date", CassandraZonedDateTimeModule.toUDT((UserType)this.zonedDateTimeUserType, (ZonedDateTime)change.getDate())));
    }

    private ImmutableSet<UUID> toUuidSet(List<MessageId> idSet) {
        return (ImmutableSet)idSet.stream().filter(CassandraMessageId.class::isInstance).map(CassandraMessageId.class::cast).map(CassandraMessageId::get).collect(ImmutableSet.toImmutableSet());
    }

    Flux<EmailChange> getAllChanges(AccountId accountId) {
        return this.executor.executeRows((Statement)this.selectAllStatement.bind().setString("account_id", accountId.getIdentifier())).map(this::readRow);
    }

    Flux<EmailChange> getChangesSince(AccountId accountId, State state) {
        return this.executor.executeRows((Statement)this.selectFromStatement.bind().setString("account_id", accountId.getIdentifier()).setUUID("state", state.getValue())).map(this::readRow);
    }

    Mono<State> latestState(AccountId accountId) {
        return this.executor.executeSingleRow((Statement)this.selectLatestStatement.bind().setString("account_id", accountId.getIdentifier())).map(row -> State.of((UUID)row.getUUID("state")));
    }

    Mono<State> latestStateNotDelegated(AccountId accountId) {
        return this.executor.executeSingleRow((Statement)this.selectLatestNotDelegatedStatement.bind().setString("account_id", accountId.getIdentifier())).map(row -> State.of((UUID)row.getUUID("state")));
    }

    private EmailChange readRow(Row row) {
        return EmailChange.builder().accountId(AccountId.fromString((String)row.getString("account_id"))).state(State.of((UUID)row.getUUID("state"))).date(CassandraZonedDateTimeModule.fromUDT((UDTValue)row.getUDTValue("date"))).isDelegated(row.getBool("is_delegated")).created(this.toIdSet(row.getSet("created", UUID.class))).updated(this.toIdSet(row.getSet("updated", UUID.class))).destroyed(this.toIdSet(row.getSet("destroyed", UUID.class))).build();
    }

    private ImmutableList<MessageId> toIdSet(Set<UUID> uuidSet) {
        return (ImmutableList)uuidSet.stream().map(CassandraMessageId.Factory::of).collect(ImmutableList.toImmutableList());
    }
}

