/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.elasticsearch.v7.events;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.backends.es.v7.DocumentId;
import org.apache.james.backends.es.v7.ElasticSearchIndexer;
import org.apache.james.backends.es.v7.RoutingKey;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.quota.search.elasticsearch.v7.json.QuotaRatioToElasticSearchJson;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ElasticSearchQuotaMailboxListener
implements EventListener.ReactiveGroupEventListener {
    private static final Group GROUP = new ElasticSearchQuotaMailboxListenerGroup();
    private final ElasticSearchIndexer indexer;
    private final QuotaRatioToElasticSearchJson quotaRatioToElasticSearchJson;
    private final RoutingKey.Factory<Username> routingKeyFactory;
    private final QuotaRootResolver quotaRootResolver;

    @Inject
    public ElasticSearchQuotaMailboxListener(@Named(value="quotaRatio") ElasticSearchIndexer indexer, QuotaRatioToElasticSearchJson quotaRatioToElasticSearchJson, RoutingKey.Factory<Username> routingKeyFactory, QuotaRootResolver quotaRootResolver) {
        this.indexer = indexer;
        this.quotaRatioToElasticSearchJson = quotaRatioToElasticSearchJson;
        this.routingKeyFactory = routingKeyFactory;
        this.quotaRootResolver = quotaRootResolver;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.QuotaUsageUpdatedEvent;
    }

    public Publisher<Void> reactiveEvent(Event event) {
        return this.handleEvent((MailboxEvents.QuotaUsageUpdatedEvent)event);
    }

    private Mono<Void> handleEvent(MailboxEvents.QuotaUsageUpdatedEvent event) {
        Username user = this.quotaRootResolver.associatedUsername(event.getQuotaRoot());
        DocumentId id = this.toDocumentId(user);
        RoutingKey routingKey = this.routingKeyFactory.from((Object)user);
        return Mono.fromCallable(() -> this.quotaRatioToElasticSearchJson.convertToJson(event)).flatMap(json -> this.indexer.index(id, json, routingKey)).then();
    }

    private DocumentId toDocumentId(Username user) {
        return DocumentId.fromString((String)user.asString());
    }

    public static class ElasticSearchQuotaMailboxListenerGroup
    extends Group {
    }
}

