/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.protocols.api.CommandDetectionSession;
import org.apache.james.protocols.netty.AllButStartTlsLineBasedChannelHandler;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;

public class SwitchableLineBasedFrameDecoder
extends AllButStartTlsLineBasedChannelHandler {
    public static final String PATTERN = ImapConstants.STARTTLS_COMMAND.getName().toLowerCase();
    private volatile boolean framingEnabled = true;

    public SwitchableLineBasedFrameDecoder(ChannelPipeline pipeline, int maxFrameLength, boolean stripDelimiter) {
        super(pipeline, maxFrameLength, stripDelimiter, PATTERN);
    }

    public synchronized void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this.framingEnabled) {
            super.messageReceived(ctx, e);
        } else {
            ctx.sendUpstream((ChannelEvent)e);
        }
    }

    public synchronized void enableFraming() {
        this.framingEnabled = true;
    }

    public synchronized void disableFraming(ChannelHandlerContext ctx) {
        this.framingEnabled = false;
        if (this.cumulation != null && this.cumulation.readable()) {
            ChannelBuffer spareBytes = this.cumulation.readBytes(this.cumulation.readableBytes());
            this.cumulation = null;
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)spareBytes);
        }
    }

    protected CommandDetectionSession retrieveSession(ChannelHandlerContext ctx, Channel channel) {
        return (ImapSession)NettyConstants.attributes.get(ctx.getChannel());
    }

    protected boolean multiPartsAndOneStartTls(List<String> parts) {
        return parts.stream().map(this::removeTag).anyMatch(line -> line.startsWith(PATTERN)) && parts.size() > 1;
    }

    protected boolean hasInvalidStartTlsPart(List<String> parts) {
        return parts.stream().map(this::removeTag).anyMatch(line -> line.startsWith(PATTERN) && !line.endsWith(PATTERN));
    }

    protected boolean hasStartTLS(String trimedLowerCasedInput) {
        return super.hasStartTLS(this.removeTag(trimedLowerCasedInput));
    }

    protected String removeTag(String input) {
        String trimmedInput = input.trim();
        int tagEnd = trimmedInput.indexOf(32);
        if (tagEnd < 0) {
            return input;
        }
        return trimmedInput.substring(tagEnd + 1);
    }
}

