/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.UserType;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.components.CassandraType;

public class CassandraTypesProvider {
    private final ImmutableMap<String, UserType> userTypes;

    @Inject
    public CassandraTypesProvider(CassandraModule module, Session session) {
        KeyspaceMetadata keyspaceMetadata = session.getCluster().getMetadata().getKeyspace(session.getLoggedKeyspace());
        this.userTypes = (ImmutableMap)module.moduleTypes().stream().collect(ImmutableMap.toImmutableMap(CassandraType::getName, type -> keyspaceMetadata.getUserType(type.getName())));
    }

    public UserType getDefinedUserType(String typeName) {
        return Optional.ofNullable((UserType)this.userTypes.get((Object)typeName)).orElseThrow(() -> new RuntimeException("Cassandra UDT " + typeName + " can not be retrieved"));
    }
}

