/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ExcludeBranchRequestControl
extends Control {
    @NotNull
    public static final String EXCLUDE_BRANCH_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.17";
    private static final byte TYPE_BASE_DNS = -96;
    private static final long serialVersionUID = -8599554860060612417L;
    @NotNull
    private final List<String> baseDNs;

    public ExcludeBranchRequestControl(@NotNull Collection<String> baseDNs) {
        this(true, baseDNs);
    }

    public ExcludeBranchRequestControl(String ... baseDNs) {
        this(true, baseDNs);
    }

    public ExcludeBranchRequestControl(boolean isCritical, String ... baseDNs) {
        super(EXCLUDE_BRANCH_REQUEST_OID, isCritical, ExcludeBranchRequestControl.encodeValue(baseDNs));
        this.baseDNs = Collections.unmodifiableList(Arrays.asList(baseDNs));
    }

    public ExcludeBranchRequestControl(boolean isCritical, @NotNull Collection<String> baseDNs) {
        super(EXCLUDE_BRANCH_REQUEST_OID, isCritical, ExcludeBranchRequestControl.encodeValue(baseDNs));
        this.baseDNs = Collections.unmodifiableList(new ArrayList<String>(baseDNs));
    }

    public ExcludeBranchRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1Sequence valueSequence;
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_EXCLUDE_BRANCH_MISSING_VALUE.get());
        }
        try {
            valueSequence = ASN1Sequence.decodeAsSequence(value.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_EXCLUDE_BRANCH_VALUE_NOT_SEQUENCE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            ASN1Element[] elements = valueSequence.elements();
            ASN1Element[] dnElements = ASN1Sequence.decodeAsSequence(elements[0]).elements();
            ArrayList<String> dnList = new ArrayList<String>(dnElements.length);
            for (ASN1Element e : dnElements) {
                dnList.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
            }
            this.baseDNs = Collections.unmodifiableList(dnList);
            if (this.baseDNs.isEmpty()) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_EXCLUDE_BRANCH_NO_BASE_DNS.get());
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_EXCLUDE_BRANCH_ERROR_PARSING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(String ... baseDNs) {
        Validator.ensureNotNull(baseDNs);
        return ExcludeBranchRequestControl.encodeValue(Arrays.asList(baseDNs));
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull Collection<String> baseDNs) {
        Validator.ensureNotNull(baseDNs);
        Validator.ensureFalse(baseDNs.isEmpty());
        ArrayList<ASN1OctetString> dnElements = new ArrayList<ASN1OctetString>(baseDNs.size());
        for (String s : baseDNs) {
            dnElements.add(new ASN1OctetString(s));
        }
        ASN1Sequence baseDNSequence = new ASN1Sequence(-96, dnElements);
        ASN1Sequence valueSequence = new ASN1Sequence(baseDNSequence);
        return new ASN1OctetString(valueSequence.encode());
    }

    @NotNull
    public List<String> getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_EXCLUDE_BRANCH.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ExcludeBranchRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", baseDNs={");
        Iterator<String> iterator = this.baseDNs.iterator();
        while (iterator.hasNext()) {
            buffer.append('\'');
            buffer.append(iterator.next());
            buffer.append('\'');
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

