/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.sieve.cassandra.model.ActiveScriptInfo;
import org.apache.james.sieverepository.api.ScriptName;
import reactor.core.publisher.Mono;

public class CassandraActiveScriptDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insertActive;
    private final PreparedStatement deleteActive;
    private final PreparedStatement selectActiveName;

    @Inject
    public CassandraActiveScriptDAO(Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.insertActive = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"sieve_active").value("script_name", (Object)QueryBuilder.bindMarker((String)"script_name")).value("user_name", (Object)QueryBuilder.bindMarker((String)"user_name")).value("date", (Object)QueryBuilder.bindMarker((String)"date")));
        this.deleteActive = session.prepare((RegularStatement)QueryBuilder.delete().from("sieve_active").where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name"))));
        this.selectActiveName = session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"script_name", "date"}).from("sieve_active").where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name"))));
    }

    public Mono<ActiveScriptInfo> getActiveSctiptInfo(Username username) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.selectActiveName.bind().setString("user_name", username.asString())).map(row -> new ActiveScriptInfo(new ScriptName(row.getString("script_name")), ZonedDateTime.ofInstant(row.getTimestamp("date").toInstant(), ZoneOffset.UTC)));
    }

    public Mono<Void> unactivate(Username username) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteActive.bind().setString("user_name", username.asString()));
    }

    public Mono<Void> activate(Username username, ScriptName scriptName) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.insertActive.bind().setString("user_name", username.asString()).setString("script_name", scriptName.getValue()).setTimestamp("date", new Date()));
    }
}

