/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.google.common.base.MoreObjects;
import org.apache.james.jmap.draft.model.CreationMessage;
import org.apache.james.jmap.draft.model.CreationMessageId;
import org.apache.james.jmap.draft.model.JmapMDN;
import org.apache.james.jmap.draft.model.SetError;
import org.apache.james.jmap.draft.model.message.view.MessageFullView;

public class ValueWithId<T> {
    private CreationMessageId creationId;
    private T value;

    private ValueWithId(CreationMessageId creationId, T value) {
        this.creationId = creationId;
        this.value = value;
    }

    public CreationMessageId getCreationId() {
        return this.creationId;
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("creationId", (Object)this.creationId).add("value", this.value).toString();
    }

    public static class MessageWithId
    extends ValueWithId<MessageFullView> {
        public MessageWithId(CreationMessageId creationId, MessageFullView message) {
            super(creationId, message);
        }
    }

    public static class ErrorWithId
    extends ValueWithId<SetError> {
        public ErrorWithId(CreationMessageId creationId, SetError error) {
            super(creationId, error);
        }
    }

    public static class MDNCreationEntry
    extends ValueWithId<JmapMDN> {
        public MDNCreationEntry(CreationMessageId creationId, JmapMDN mdn) {
            super(creationId, mdn);
        }
    }

    public static class CreationMessageEntry
    extends ValueWithId<CreationMessage> {
        public CreationMessageEntry(CreationMessageId creationId, CreationMessage message) {
            super(creationId, message);
        }
    }
}

