/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import javax.inject.Inject;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.AbstractPOP3CommandHandler;
import org.apache.james.protocols.pop3.core.MDCConstants;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoopCmdHandler
extends AbstractPOP3CommandHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoopCmdHandler.class);
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"NOOP");
    private final MetricFactory metricFactory;

    @Inject
    public NoopCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    @Override
    public Response onCommand(POP3Session session, Request request) {
        return (Response)this.metricFactory.decorateSupplierWithTimerMetric("pop3-noop", () -> (Response)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addToContext("action", "NOOP").addToContext(MDCConstants.withSession(session)), () -> this.noop(session)));
    }

    private Response noop(POP3Session session) {
        LOGGER.trace("NOOP command received");
        if (session.getHandlerState() == 2) {
            return POP3Response.OK;
        }
        return POP3Response.ERR;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

