/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.aes;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.crypto.tink.subtle.Hex;
import org.apache.james.blob.aes.CryptoConfig;

public class CryptoConfigBuilder {
    private String salt;
    private char[] password;

    CryptoConfigBuilder() {
    }

    public CryptoConfigBuilder salt(String salt) {
        this.salt = salt;
        return this;
    }

    public CryptoConfigBuilder password(char[] password) {
        this.password = password;
        return this;
    }

    public CryptoConfig build() {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.salt) ? 1 : 0) != 0, (Object)"'salt' is mandatory and must not be empty");
        Preconditions.checkState((this.password != null && this.password.length > 0 ? 1 : 0) != 0, (Object)"'password' is mandatory and must not be empty");
        return new CryptoConfig(Hex.encode((byte[])Hex.decode((String)this.salt)), this.password);
    }
}

