/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.mail.internet.AddressException;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.RecipientRewriteTableUserEntityValidator;
import org.apache.james.UserEntityValidator;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.rrt.api.InvalidRegexException;
import org.apache.james.rrt.api.LoopDetectedException;
import org.apache.james.rrt.api.MappingAlreadyExistsException;
import org.apache.james.rrt.api.MappingConflictException;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableConfiguration;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.api.SameSourceAndDestinationException;
import org.apache.james.rrt.api.SourceDomainIsNotInDomainListException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import org.apache.james.rrt.lib.SkipMappingProcessingException;
import org.apache.james.user.api.UsersRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecipientRewriteTable
implements RecipientRewriteTable,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRecipientRewriteTable.class);
    private RecipientRewriteTableConfiguration configuration;
    private UserEntityValidator userEntityValidator;
    private UsersRepository usersRepository;
    private DomainList domainList;

    public void setConfiguration(RecipientRewriteTableConfiguration configuration) {
        Preconditions.checkState((this.configuration == null ? 1 : 0) != 0, (Object)"A configuration cannot be set twice");
        this.configuration = configuration;
        this.userEntityValidator = new RecipientRewriteTableUserEntityValidator(this);
    }

    @Inject
    public void setUsersRepository(UsersRepository usersRepository) {
        this.usersRepository = usersRepository;
    }

    @Inject
    public void setUserEntityValidator(UserEntityValidator userEntityValidator) {
        this.userEntityValidator = userEntityValidator;
    }

    @Inject
    public void setDomainList(DomainList domainList) {
        this.domainList = domainList;
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> config) throws ConfigurationException {
        this.setConfiguration(RecipientRewriteTableConfiguration.fromConfiguration(config));
        this.doConfigure(config);
    }

    protected void doConfigure(HierarchicalConfiguration<ImmutableNode> arg0) throws ConfigurationException {
    }

    public RecipientRewriteTableConfiguration getConfiguration() {
        return this.configuration;
    }

    public Mappings getResolvedMappings(String user, Domain domain, EnumSet<Mapping.Type> mappingTypes) throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        Preconditions.checkState((this.configuration != null ? 1 : 0) != 0, (Object)"RecipientRewriteTable is not configured");
        return this.getMappings(Username.fromLocalPartWithDomain((String)user, (Domain)domain), this.configuration.getMappingLimit(), mappingTypes);
    }

    private Mappings getMappings(Username username, int mappingLimit, EnumSet<Mapping.Type> mappingTypes) throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        if (mappingLimit == 0) {
            throw new RecipientRewriteTable.TooManyMappingException("554 Too many mappings to process");
        }
        Domain domain = (Domain)username.getDomainPart().get();
        String localPart = username.getLocalPart();
        Stream<Mapping> targetMappings = this.mapAddress(localPart, domain).asStream().filter(mapping -> mappingTypes.contains(mapping.getType()));
        try {
            return MappingsImpl.fromMappings(targetMappings.flatMap(Throwing.function(target -> this.convertAndRecurseMapping(username, (Mapping)target, mappingLimit, mappingTypes)).sneakyThrow()));
        }
        catch (SkipMappingProcessingException e) {
            return MappingsImpl.empty();
        }
    }

    private Stream<Mapping> convertAndRecurseMapping(Username originalUsername, Mapping associatedMapping, int remainingLoops, EnumSet<Mapping.Type> mappingTypes) throws RecipientRewriteTable.ErrorMappingException, SkipMappingProcessingException, AddressException {
        Function convertAndRecurseMapping = Throwing.function(rewrittenUser -> this.convertAndRecurseMapping(associatedMapping, originalUsername, (Username)rewrittenUser, remainingLoops, mappingTypes)).sneakyThrow();
        return associatedMapping.rewriteUser(originalUsername).map(rewrittenUser -> rewrittenUser.withDefaultDomainFromUser(originalUsername)).map(convertAndRecurseMapping).orElse(Stream.empty());
    }

    private Stream<Mapping> convertAndRecurseMapping(Mapping mapping, Username originalUsername, Username rewrittenUsername, int remainingLoops, EnumSet<Mapping.Type> mappingTypes) throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        LOGGER.debug("Valid virtual user mapping {} to {}", (Object)originalUsername.asString(), (Object)rewrittenUsername.asString());
        Stream<Mapping> nonRecursiveResult = Stream.of(this.toMapping(rewrittenUsername, mapping.getType()));
        if (!this.configuration.isRecursive()) {
            return nonRecursiveResult;
        }
        if (originalUsername.equals((Object)rewrittenUsername)) {
            return mapping.handleIdentity(nonRecursiveResult);
        }
        return this.recurseMapping(nonRecursiveResult, rewrittenUsername, remainingLoops, mappingTypes);
    }

    private Stream<Mapping> recurseMapping(Stream<Mapping> nonRecursiveResult, Username targetUsername, int remainingLoops, EnumSet<Mapping.Type> mappingTypes) throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        Mappings childMappings = this.getMappings(targetUsername, remainingLoops - 1, mappingTypes);
        if (childMappings.isEmpty()) {
            return nonRecursiveResult;
        }
        return childMappings.asStream();
    }

    private Mapping toMapping(Username rewrittenUsername, Mapping.Type type) {
        switch (type) {
            case Forward: 
            case Group: 
            case Alias: {
                return Mapping.of((Mapping.Type)type, (String)rewrittenUsername.asString());
            }
            case Regex: 
            case Domain: 
            case DomainAlias: 
            case Error: 
            case Address: {
                return Mapping.address((String)rewrittenUsername.asString());
            }
        }
        throw new IllegalArgumentException("unhandled enum type");
    }

    public void addRegexMapping(MappingSource source, String regex) throws RecipientRewriteTableException {
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new InvalidRegexException("Invalid regex: " + regex, (Exception)e);
        }
        Mapping mapping = Mapping.regex((String)regex);
        this.checkDuplicateMapping(source, mapping);
        this.checkDomainMappingSourceIsManaged(source);
        LOGGER.info("Add regex mapping => {} for source {}", (Object)regex, (Object)source.asString());
        this.addMapping(source, mapping);
    }

    public void removeRegexMapping(MappingSource source, String regex) throws RecipientRewriteTableException {
        LOGGER.info("Remove regex mapping => {} for source: {}", (Object)regex, (Object)source.asString());
        this.removeMapping(source, Mapping.regex((String)regex));
    }

    public void addAddressMapping(MappingSource source, String address) throws RecipientRewriteTableException {
        Mapping mapping = Mapping.address((String)address).appendDomainFromThrowingSupplierIfNone(this::defaultDomain);
        this.checkHasValidAddress(mapping);
        this.checkDuplicateMapping(source, mapping);
        this.checkDomainMappingSourceIsManaged(source);
        this.checkNotSameSourceAndDestination(source, address);
        LOGGER.info("Add address mapping => {} for source: {}", (Object)mapping.asString(), (Object)source.asString());
        this.assertNoLoop(source, mapping);
        this.addMapping(source, mapping);
    }

    private Domain defaultDomain() throws RecipientRewriteTableException {
        try {
            return this.domainList.getDefaultDomain();
        }
        catch (DomainListException e) {
            throw new RecipientRewriteTableException("Unable to retrieve default domain", (Throwable)e);
        }
    }

    private void checkHasValidAddress(Mapping mapping) throws RecipientRewriteTableException {
        if (!mapping.asMailAddress().isPresent()) {
            throw new RecipientRewriteTableException("Invalid emailAddress: " + mapping.asString());
        }
    }

    public void removeAddressMapping(MappingSource source, String address) throws RecipientRewriteTableException {
        Mapping mapping = Mapping.address((String)address).appendDomainFromThrowingSupplierIfNone(this::defaultDomain);
        LOGGER.info("Remove address mapping => {} for source: {}", (Object)mapping.asString(), (Object)source.asString());
        this.removeMapping(source, mapping);
    }

    public void addErrorMapping(MappingSource source, String error) throws RecipientRewriteTableException {
        Mapping mapping = Mapping.error((String)error);
        this.checkDuplicateMapping(source, mapping);
        this.checkDomainMappingSourceIsManaged(source);
        LOGGER.info("Add error mapping => {} for source: {}", (Object)error, (Object)source.asString());
        this.addMapping(source, mapping);
    }

    public void removeErrorMapping(MappingSource source, String error) throws RecipientRewriteTableException {
        LOGGER.info("Remove error mapping => {} for source: {}", (Object)error, (Object)source.asString());
        this.removeMapping(source, Mapping.error((String)error));
    }

    public void addDomainMapping(MappingSource source, Domain realDomain) throws RecipientRewriteTableException {
        this.checkDomainMappingSourceIsManaged(source);
        LOGGER.info("Add domain mapping: {} => {}", (Object)source.asDomain().map(Domain::asString).orElse("null"), (Object)realDomain);
        this.addMapping(source, Mapping.domain((Domain)realDomain));
    }

    public void removeDomainMapping(MappingSource source, Domain realDomain) throws RecipientRewriteTableException {
        LOGGER.info("Remove domain mapping: {} => {}", (Object)source.asDomain().map(Domain::asString).orElse("null"), (Object)realDomain);
        this.removeMapping(source, Mapping.domain((Domain)realDomain));
    }

    public void addDomainAliasMapping(MappingSource source, Domain realDomain) throws RecipientRewriteTableException {
        this.checkDomainMappingSourceIsManaged(source);
        LOGGER.info("Add domain alias mapping: {} => {}", (Object)source.asDomain().map(Domain::asString).orElse("null"), (Object)realDomain);
        this.addMapping(source, Mapping.domainAlias((Domain)realDomain));
    }

    public void removeDomainAliasMapping(MappingSource source, Domain realDomain) throws RecipientRewriteTableException {
        LOGGER.info("Remove domain alias mapping: {} => {}", (Object)source.asDomain().map(Domain::asString).orElse("null"), (Object)realDomain);
        this.removeMapping(source, Mapping.domainAlias((Domain)realDomain));
    }

    public void addForwardMapping(MappingSource source, String address) throws RecipientRewriteTableException {
        Mapping mapping = Mapping.forward((String)address).appendDomainFromThrowingSupplierIfNone(this::defaultDomain);
        this.checkHasValidAddress(mapping);
        this.checkDuplicateMapping(source, mapping);
        this.checkDomainMappingSourceIsManaged(source);
        LOGGER.info("Add forward mapping => {} for source: {}", (Object)mapping.asString(), (Object)source.asString());
        this.assertNoLoop(source, mapping);
        this.addMapping(source, mapping);
    }

    public void removeForwardMapping(MappingSource source, String address) throws RecipientRewriteTableException {
        Mapping mapping = Mapping.forward((String)address).appendDomainFromThrowingSupplierIfNone(this::defaultDomain);
        LOGGER.info("Remove forward mapping => {} for source: {}", (Object)mapping.asString(), (Object)source.asString());
        this.removeMapping(source, mapping);
    }

    public void addGroupMapping(MappingSource source, String address) throws RecipientRewriteTableException {
        Mapping mapping = Mapping.group((String)address).appendDomainFromThrowingSupplierIfNone(this::defaultDomain);
        this.checkHasValidAddress(mapping);
        source.asMailAddress().ifPresent(Throwing.consumer(this::ensureGroupNotShadowingAnotherAddress).sneakyThrow());
        this.checkDuplicateMapping(source, mapping);
        this.checkDomainMappingSourceIsManaged(source);
        LOGGER.info("Add group mapping => {} for source: {}", (Object)mapping.asString(), (Object)source.asString());
        this.assertNoLoop(source, mapping);
        this.addMapping(source, mapping);
    }

    private void ensureGroupNotShadowingAnotherAddress(MailAddress groupAddress) throws Exception {
        this.ensureNoConflict(UserEntityValidator.EntityType.GROUP, groupAddress);
    }

    private void ensureAliasNotShadowingAnotherAddress(MailAddress groupAddress) throws Exception {
        this.ensureNoConflict(UserEntityValidator.EntityType.ALIAS, groupAddress);
    }

    private void ensureNoConflict(UserEntityValidator.EntityType entity, MailAddress groupAddress) throws Exception {
        Username username = this.usersRepository.getUsername(groupAddress);
        Optional<UserEntityValidator.ValidationFailure> validationFailure = this.userEntityValidator.canCreate(username, (Set<UserEntityValidator.EntityType>)ImmutableSet.of((Object)entity));
        if (validationFailure.isPresent()) {
            throw new MappingConflictException(validationFailure.get().errorMessage());
        }
    }

    public void removeGroupMapping(MappingSource source, String address) throws RecipientRewriteTableException {
        Mapping mapping = Mapping.group((String)address).appendDomainFromThrowingSupplierIfNone(this::defaultDomain);
        LOGGER.info("Remove group mapping => {} for source: {}", (Object)mapping.asString(), (Object)source.asString());
        this.removeMapping(source, mapping);
    }

    public void addAliasMapping(MappingSource source, String address) throws RecipientRewriteTableException {
        Mapping mapping = Mapping.alias((String)address).appendDomainFromThrowingSupplierIfNone(this::defaultDomain);
        this.checkHasValidAddress(mapping);
        this.checkDuplicateMapping(source, mapping);
        source.asMailAddress().ifPresent(Throwing.consumer(this::ensureAliasNotShadowingAnotherAddress).sneakyThrow());
        this.checkNotSameSourceAndDestination(source, address);
        this.checkDomainMappingSourceIsManaged(source);
        LOGGER.info("Add alias source => {} for destination mapping: {}", (Object)source.asString(), (Object)mapping.asString());
        this.assertNoLoop(source, mapping);
        this.addMapping(source, mapping);
    }

    public void removeAliasMapping(MappingSource source, String address) throws RecipientRewriteTableException {
        Mapping mapping = Mapping.alias((String)address).appendDomainFromThrowingSupplierIfNone(this::defaultDomain);
        LOGGER.info("Remove alias source => {} for destination mapping: {}", (Object)source.asString(), (Object)mapping.asString());
        this.removeMapping(source, mapping);
    }

    public abstract Map<MappingSource, Mappings> getAllMappings() throws RecipientRewriteTableException;

    protected abstract Mappings mapAddress(String var1, Domain var2) throws RecipientRewriteTableException;

    private void checkDomainMappingSourceIsManaged(MappingSource source) throws RecipientRewriteTableException {
        Optional notManagedSourceDomain = source.availableDomain().filter(Throwing.predicate(domain -> !this.isManagedByDomainList((Domain)domain)).sneakyThrow());
        if (notManagedSourceDomain.isPresent()) {
            throw new SourceDomainIsNotInDomainListException("Source domain '" + ((Domain)notManagedSourceDomain.get()).asString() + "' is not managed by the domainList");
        }
    }

    private boolean isManagedByDomainList(Domain domain) throws RecipientRewriteTableException {
        try {
            return this.domainList.containsDomain(domain);
        }
        catch (DomainListException e) {
            throw new RecipientRewriteTableException("Cannot verify domainList contains the available domain in source");
        }
    }

    private void checkDuplicateMapping(MappingSource source, Mapping mapping) throws RecipientRewriteTableException {
        Mappings mappings = this.getStoredMappings(source);
        if (mappings.contains(mapping)) {
            throw new MappingAlreadyExistsException("Mapping " + mapping.asString() + " for " + source.asString() + " already exist!");
        }
    }

    private void checkNotSameSourceAndDestination(MappingSource source, String address) throws RecipientRewriteTableException {
        if (source.asMailAddress().map(mailAddress -> mailAddress.asString().equals(address)).orElse(false).booleanValue()) {
            throw new SameSourceAndDestinationException("Source and destination can't be the same!");
        }
    }

    private void assertNoLoop(MappingSource source, Mapping mapping) throws RecipientRewriteTableException {
        boolean leadsToALoop;
        if (this.configuration.isRecursive() && (leadsToALoop = mapping.asMailAddress().map(Throwing.function(mailAddress -> this.getResolvedMappings(mailAddress.getLocalPart(), mailAddress.getDomain())).sneakyThrow()).map(mappings -> mappings.asStream().flatMap(aMapping -> aMapping.asMailAddress().stream()).anyMatch(address -> source.asMailAddress().map(arg_0 -> ((MailAddress)address).equals(arg_0)).orElse(false))).orElse(false).booleanValue())) {
            throw new LoopDetectedException(source, mapping);
        }
    }
}

