/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetMimeHeaderHandler
implements JamesMessageHook,
ProtocolHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetMimeHeaderHandler.class);
    private String headerName;
    private String headerValue;

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public void setHeaderValue(String headerValue) {
        this.headerValue = headerValue;
    }

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        try {
            MimeMessage message = mail.getMessage();
            if (this.headerName != null) {
                message.setHeader(this.headerName, this.headerValue);
                message.saveChanges();
            }
        }
        catch (MessagingException me) {
            LOGGER.error(me.getMessage());
        }
        return HookResult.DECLINED;
    }

    public void init(Configuration config) throws ConfigurationException {
        this.setHeaderName(config.getString("headername"));
        this.setHeaderValue(config.getString("headervalue"));
    }
}

