/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.message;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Objects;

public class Capability {
    private final String value;

    public static Capability of(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"'value' can not be null");
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)"'value' can not be empty");
        return new Capability(value.toUpperCase(Locale.US));
    }

    private Capability(String value) {
        this.value = value;
    }

    public String asString() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof Capability) {
            Capability that = (Capability)o;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }
}

