/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.StoreRequest;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.NullableMessageSequenceNumber;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class StoreProcessor
extends AbstractMailboxProcessor<StoreRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreProcessor.class);
    private static final ImapCommand CONDSTORE_COMMAND = ImapCommand.selectedStateCommand("Conditional STORE");

    public StoreProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(StoreRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void processRequest(StoreRequest request, ImapSession session, ImapProcessor.Responder responder) {
        IdRange[] idSet = request.getIdSet();
        boolean useUids = request.isUseUids();
        long unchangedSince = request.getUnchangedSince();
        try {
            MessageManager mailbox = this.getSelectedMailbox(session).orElseThrow(() -> new MailboxException("Session not in SELECTED state"));
            MailboxSession mailboxSession = session.getMailboxSession();
            Flags flags = request.getFlags();
            if (unchangedSince != -1L) {
                Flags.Flag[] systemFlags;
                MessageManager.MailboxMetaData metaData = mailbox.getMetaData(false, mailboxSession, MessageManager.MailboxMetaData.FetchGroup.NO_COUNT);
                if (!metaData.isModSeqPermanent()) {
                    this.taggedBad(request, responder, HumanReadableText.NO_MOD_SEQ);
                    return;
                }
                if (unchangedSince == 0L && (systemFlags = flags.getSystemFlags()) != null && systemFlags.length != 0) {
                    StatusResponse response = this.getStatusResponseFactory().taggedOk(request.getTag(), request.getCommand(), HumanReadableText.FAILED, StatusResponse.ResponseCode.condStore(idSet));
                    responder.respond(response);
                    return;
                }
            }
            ArrayList<MessageUid> failed = new ArrayList<MessageUid>();
            ArrayList<NullableMessageSequenceNumber> failedMsns = new ArrayList<NullableMessageSequenceNumber>();
            List<String> userFlags = Arrays.asList(flags.getUserFlags());
            for (IdRange range : idSet) {
                SelectedMailbox selected = session.getSelected();
                MessageRange messageSet = this.messageRange(selected, range, useUids);
                if (messageSet == null) continue;
                if (unchangedSince != -1L) {
                    ArrayList<MessageUid> uids = new ArrayList<MessageUid>();
                    Iterator results = Flux.from((Publisher)mailbox.listMessagesMetadata(messageSet, mailboxSession)).toStream().iterator();
                    while (results.hasNext()) {
                        ComposedMessageIdWithMetaData r = (ComposedMessageIdWithMetaData)results.next();
                        MessageUid uid = r.getComposedMessageId().getUid();
                        boolean fail = false;
                        if (unchangedSince == 0L) {
                            String[] uFlags;
                            for (String uFlag : uFlags = r.getFlags().getUserFlags()) {
                                if (!userFlags.contains(uFlag)) continue;
                                fail = true;
                                break;
                            }
                        }
                        if (!fail && r.getModSeq().asLong() <= unchangedSince) {
                            uids.add(uid);
                            continue;
                        }
                        if (useUids) {
                            failed.add(uid);
                            continue;
                        }
                        failedMsns.add(selected.msn(uid));
                    }
                    List mRanges = MessageRange.toRanges(uids);
                    for (MessageRange mRange : mRanges) {
                        this.setFlags(request, mailboxSession, mailbox, mRange, session, responder);
                    }
                    continue;
                }
                this.setFlags(request, mailboxSession, mailbox, messageSet, session, responder);
            }
            boolean omitExpunged = !useUids;
            this.unsolicitedResponses(session, responder, omitExpunged, useUids);
            if (failed.isEmpty() && failedMsns.isEmpty()) {
                this.okComplete(request, responder);
            } else if (useUids) {
                List ranges = MessageRange.toRanges(failed);
                UidRange[] idRanges = new UidRange[ranges.size()];
                for (int i = 0; i < ranges.size(); ++i) {
                    MessageRange r = (MessageRange)ranges.get(i);
                    idRanges[i] = r.getType() == MessageRange.Type.ONE ? new UidRange(r.getUidFrom()) : new UidRange(r.getUidFrom(), r.getUidTo());
                }
                StatusResponse response = this.getStatusResponseFactory().taggedOk(request.getTag(), request.getCommand(), HumanReadableText.FAILED, StatusResponse.ResponseCode.condStore(idRanges));
                responder.respond(response);
            } else {
                ArrayList<IdRange> ranges = new ArrayList<IdRange>();
                for (NullableMessageSequenceNumber msn : failedMsns) {
                    msn.ifPresent(id -> ranges.add(new IdRange(id.asInt())));
                }
                IdRange[] failedRanges = (IdRange[])IdRange.mergeRanges(ranges).toArray(IdRange[]::new);
                StatusResponse response = this.getStatusResponseFactory().taggedOk(request.getTag(), request.getCommand(), HumanReadableText.FAILED, StatusResponse.ResponseCode.condStore(failedRanges));
                responder.respond(response);
            }
        }
        catch (MessageRangeException e) {
            LOGGER.debug("Store failed for mailbox {} because of an invalid sequence-set {}", new Object[]{session.getSelected().getMailboxId(), idSet, e});
            this.taggedBad(request, responder, HumanReadableText.INVALID_MESSAGESET);
        }
        catch (MailboxException e) {
            LOGGER.error("Store failed for mailbox {} and sequence-set {}", new Object[]{session.getSelected().getMailboxId(), idSet, e});
            this.no(request, responder, HumanReadableText.SAVE_FAILED);
        }
    }

    private void setFlags(StoreRequest request, MailboxSession mailboxSession, MessageManager mailbox, MessageRange messageSet, ImapSession session, ImapProcessor.Responder responder) throws MailboxException {
        Flags flags = request.getFlags();
        boolean useUids = request.isUseUids();
        boolean silent = request.isSilent();
        long unchangedSince = request.getUnchangedSince();
        MessageManager.FlagsUpdateMode mode = request.getFlagsUpdateMode();
        SelectedMailbox selected = session.getSelected();
        Map flagsByUid = mailbox.setFlags(flags, mode, messageSet, mailboxSession);
        if (selected.hasNewApplicableFlags()) {
            this.flags(responder, selected);
            this.permanentFlags(responder, mailbox.getMetaData(false, mailboxSession, MessageManager.MailboxMetaData.FetchGroup.NO_COUNT), selected);
            selected.resetNewApplicableFlags();
        }
        Set<Capability> enabled = EnableProcessor.getEnabledCapabilities(session);
        boolean qresyncEnabled = enabled.contains(ImapConstants.SUPPORTS_QRESYNC);
        boolean condstoreEnabled = enabled.contains(ImapConstants.SUPPORTS_CONDSTORE);
        if (!silent || unchangedSince != -1L || qresyncEnabled || condstoreEnabled) {
            HashMap<MessageUid, ModSeq> modSeqs = new HashMap<MessageUid, ModSeq>();
            if (unchangedSince != -1L || qresyncEnabled || condstoreEnabled) {
                Iterator results = Flux.from((Publisher)mailbox.listMessagesMetadata(messageSet, mailboxSession)).toStream().iterator();
                while (results.hasNext()) {
                    ComposedMessageIdWithMetaData r = (ComposedMessageIdWithMetaData)results.next();
                    modSeqs.put(r.getComposedMessageId().getUid(), r.getModSeq());
                }
            }
            for (Map.Entry entry : flagsByUid.entrySet()) {
                MessageUid uid = (MessageUid)entry.getKey();
                selected.msn(uid).fold(() -> {
                    LOGGER.debug("No message found with uid {} in the uid<->msn mapping for mailbox {}. This may be because it was deleted by a concurrent session. So skip it..", (Object)uid, (Object)selected.getPath().asString());
                    return null;
                }, msn -> {
                    Flags resultFlags = (Flags)entry.getValue();
                    Object resultUid = useUids || qresyncEnabled ? uid : null;
                    if (selected.isRecent(uid)) {
                        resultFlags.add(Flags.Flag.RECENT);
                    }
                    FetchResponse response = silent && (unchangedSince != -1L || qresyncEnabled || condstoreEnabled) ? new FetchResponse(msn, null, (MessageUid)resultUid, (ModSeq)modSeqs.get(uid), null, null, null, null, null, null) : (!silent && (unchangedSince != -1L || qresyncEnabled || condstoreEnabled) ? new FetchResponse(msn, resultFlags, (MessageUid)resultUid, (ModSeq)modSeqs.get(uid), null, null, null, null, null, null) : new FetchResponse(msn, resultFlags, (MessageUid)resultUid, null, null, null, null, null, null, null));
                    responder.respond(response);
                    return null;
                });
            }
            if (unchangedSince != -1L) {
                this.condstoreEnablingCommand(session, responder, mailbox.getMetaData(false, mailboxSession, MessageManager.MailboxMetaData.FetchGroup.NO_COUNT), true);
            }
        }
    }

    @Override
    protected Closeable addContextToMDC(StoreRequest message) {
        return MDCBuilder.create().addToContext("action", "STORE").addToContext("ranges", IdRange.toString(message.getIdSet())).addToContext("useUids", Boolean.toString(message.isUseUids())).addToContext("unchangedSince", Long.toString(message.getUnchangedSince())).addToContext("isSilent", Boolean.toString(message.isSilent())).build();
    }
}

