/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.common;

import java.util.Collection;
import org.parboiled.common.ImmutableList;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Predicate;
import org.parboiled.common.StringUtils;

public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return AlwaysTruePredicate.INSTANCE;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return AlwaysFalsePredicate.INSTANCE;
    }

    public static <T> Predicate<T> isNull() {
        return IsNullPredicate.INSTANCE;
    }

    public static <T> Predicate<T> notNull() {
        return NotNullPredicate.INSTANCE;
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return new NotPredicate(predicate);
    }

    public static <T> Predicate<T> and(Collection<? extends Predicate<? super T>> collection) {
        return new AndPredicate(collection);
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... predicateArray) {
        return new AndPredicate(ImmutableList.of(predicateArray));
    }

    public static <T> Predicate<T> and(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        Preconditions.checkArgNotNull(predicate, "first");
        Preconditions.checkArgNotNull(predicate2, "second");
        return new AndPredicate(ImmutableList.of(predicate, predicate2));
    }

    public static <T> Predicate<T> or(Collection<? extends Predicate<? super T>> collection) {
        return new OrPredicate(collection);
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... predicateArray) {
        return new OrPredicate(ImmutableList.of(predicateArray));
    }

    public static <T> Predicate<T> or(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        Preconditions.checkArgNotNull(predicate, "first");
        Preconditions.checkArgNotNull(predicate2, "second");
        return new OrPredicate(ImmutableList.of(predicate, predicate2));
    }

    public static <T> Predicate<T> equalTo(T t) {
        return t == null ? Predicates.isNull() : new IsEqualToPredicate(t);
    }

    public static Predicate<Object> instanceOf(Class<?> clazz) {
        return new InstanceOfPredicate(clazz);
    }

    public static <T> Predicate<T> in(Collection<? extends T> collection) {
        return new InPredicate(collection);
    }

    private static class InPredicate<T>
    implements Predicate<T> {
        private final Collection<?> target;

        private InPredicate(Collection<?> collection) {
            Preconditions.checkArgNotNull(collection, "target");
            this.target = collection;
        }

        @Override
        public boolean apply(T t) {
            try {
                return this.target.contains(t);
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public String toString() {
            return "In(" + this.target + ")";
        }
    }

    private static class NotNullPredicate
    implements Predicate<Object> {
        private static final Predicate<Object> INSTANCE = new NotNullPredicate();

        private NotNullPredicate() {
        }

        @Override
        public boolean apply(Object object) {
            return object != null;
        }

        public String toString() {
            return "NotNull";
        }
    }

    private static class IsNullPredicate
    implements Predicate<Object> {
        private static final Predicate<Object> INSTANCE = new IsNullPredicate();

        private IsNullPredicate() {
        }

        @Override
        public boolean apply(Object object) {
            return object == null;
        }

        public String toString() {
            return "IsNull";
        }
    }

    private static class InstanceOfPredicate
    implements Predicate<Object> {
        private final Class<?> clazz;

        private InstanceOfPredicate(Class<?> clazz) {
            Preconditions.checkArgNotNull(clazz, "clazz");
            this.clazz = clazz;
        }

        @Override
        public boolean apply(Object object) {
            return this.clazz.isInstance(object);
        }

        public String toString() {
            return "IsInstanceOf(" + this.clazz.getName() + ")";
        }
    }

    private static class IsEqualToPredicate<T>
    implements Predicate<T> {
        private final T target;

        private IsEqualToPredicate(T t) {
            this.target = t;
        }

        @Override
        public boolean apply(T t) {
            return this.target.equals(t);
        }

        public String toString() {
            return "IsEqualTo(" + this.target + ")";
        }
    }

    private static class OrPredicate<T>
    implements Predicate<T> {
        private final Collection<? extends Predicate<? super T>> components;

        private OrPredicate(Collection<? extends Predicate<? super T>> collection) {
            this.components = collection;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (!predicate.apply(t)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "Or(" + StringUtils.join(this.components, ", ") + ")";
        }
    }

    private static class AndPredicate<T>
    implements Predicate<T> {
        private final Collection<? extends Predicate<? super T>> components;

        private AndPredicate(Collection<? extends Predicate<? super T>> collection) {
            this.components = collection;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (predicate.apply(t)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "And(" + StringUtils.join(this.components, ", ") + ")";
        }
    }

    private static class NotPredicate<T>
    implements Predicate<T> {
        private final Predicate<T> predicate;

        private NotPredicate(Predicate<T> predicate) {
            Preconditions.checkArgNotNull(predicate, "predicate");
            this.predicate = predicate;
        }

        @Override
        public boolean apply(T t) {
            return !this.predicate.apply(t);
        }

        public String toString() {
            return "Not(" + this.predicate.toString() + ")";
        }
    }

    private static class AlwaysFalsePredicate
    implements Predicate<Object> {
        private static final Predicate<Object> INSTANCE = new AlwaysFalsePredicate();

        private AlwaysFalsePredicate() {
        }

        @Override
        public boolean apply(Object object) {
            return false;
        }

        public String toString() {
            return "AlwaysFalse";
        }
    }

    private static class AlwaysTruePredicate
    implements Predicate<Object> {
        private static final Predicate<Object> INSTANCE = new AlwaysTruePredicate();

        private AlwaysTruePredicate() {
        }

        @Override
        public boolean apply(Object object) {
            return true;
        }

        public String toString() {
            return "AlwaysTrue";
        }
    }
}

