/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.OID;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.GeneralAlternativeNameExtension;
import com.unboundid.util.ssl.cert.GeneralNames;
import com.unboundid.util.ssl.cert.X509CertificateExtension;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SubjectAlternativeNameExtension
extends GeneralAlternativeNameExtension {
    @NotNull
    public static final OID SUBJECT_ALTERNATIVE_NAME_OID = new OID("2.5.29.17");
    private static final long serialVersionUID = 4194307412985686108L;

    SubjectAlternativeNameExtension(boolean isCritical, @NotNull GeneralNames generalNames) throws CertException {
        super(SUBJECT_ALTERNATIVE_NAME_OID, isCritical, generalNames);
    }

    SubjectAlternativeNameExtension(@NotNull X509CertificateExtension extension) throws CertException {
        super(extension);
    }

    @Override
    @NotNull
    public String getExtensionName() {
        return CertMessages.INFO_SUBJECT_ALT_NAME_EXTENSION_NAME.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        this.toString("SubjectAlternativeNameExtension", buffer);
    }
}

