/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.opensearch;

import org.apache.james.backends.opensearch.AliasName;
import org.apache.james.backends.opensearch.IndexCreationFactory;
import org.apache.james.backends.opensearch.IndexName;
import org.apache.james.backends.opensearch.OpenSearchConfiguration;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.quota.search.opensearch.QuotaRatioMappingFactory;
import org.apache.james.quota.search.opensearch.QuotaRatioOpenSearchConstants;

public class QuotaSearchIndexCreationUtil {
    public static ReactorOpenSearchClient prepareClient(ReactorOpenSearchClient client, AliasName readAlias, AliasName writeAlias, IndexName indexName, OpenSearchConfiguration configuration) {
        return new IndexCreationFactory(configuration).useIndex(indexName).addAlias(new AliasName[]{readAlias}).addAlias(new AliasName[]{writeAlias}).createIndexAndAliases(client, QuotaRatioMappingFactory.getMappingContent());
    }

    public static ReactorOpenSearchClient prepareDefaultClient(ReactorOpenSearchClient client, OpenSearchConfiguration configuration) {
        return QuotaSearchIndexCreationUtil.prepareClient(client, (AliasName)QuotaRatioOpenSearchConstants.DEFAULT_QUOTA_RATIO_READ_ALIAS, (AliasName)QuotaRatioOpenSearchConstants.DEFAULT_QUOTA_RATIO_WRITE_ALIAS, QuotaRatioOpenSearchConstants.DEFAULT_QUOTA_RATIO_INDEX, configuration);
    }
}

