/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.mdc;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.util.MDCStructuredLogger;
import org.apache.james.webadmin.mdc.RequestId;
import org.apache.james.webadmin.mdc.RequestLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Filter;
import spark.Request;
import spark.Response;

public class LoggingRequestFilter
implements Filter {
    public static final Logger LOGGER = LoggerFactory.getLogger(LoggingRequestFilter.class);
    public static final String REQUEST_BODY = "request-body";
    public static final String METHOD = "method";
    public static final String ENDPOINT = "endpoint";
    public static final String QUERY_PARAMETERS = "queryParameters";
    public static final String IP = "ip";
    public static final String REQUEST_ID = "requestId";
    private final Set<RequestLogger> requestLoggers;

    public static LoggingRequestFilter create() {
        return new LoggingRequestFilter((Set<RequestLogger>)ImmutableSet.of());
    }

    @Inject
    public LoggingRequestFilter(Set<RequestLogger> requestLoggers) {
        this.requestLoggers = requestLoggers;
    }

    public void handle(Request request, Response response) {
        RequestId requestId = RequestId.random();
        request.attribute(REQUEST_ID, (Object)requestId);
        this.requestLoggers.stream().filter(requestLogger -> requestLogger.applies(request)).findFirst().orElse(DefaultRequestLogger.INSTANCE).log(request, requestId);
    }

    private static class DefaultRequestLogger
    implements RequestLogger {
        private static final DefaultRequestLogger INSTANCE = new DefaultRequestLogger();

        private DefaultRequestLogger() {
        }

        @Override
        public boolean applies(Request request) {
            return true;
        }

        @Override
        public void log(Request request, RequestId requestId) {
            MDCStructuredLogger.forLogger((Logger)LOGGER).field(LoggingRequestFilter.REQUEST_ID, requestId.asString()).field(LoggingRequestFilter.IP, request.ip()).field("real-ip", Optional.ofNullable(request.headers("X-Real-IP")).orElse("")).field(LoggingRequestFilter.ENDPOINT, request.url()).field(LoggingRequestFilter.METHOD, request.requestMethod()).field("LOGIN", (String)request.attribute("LOGIN")).field(LoggingRequestFilter.QUERY_PARAMETERS, ImmutableSet.copyOf((Collection)request.queryParams()).toString()).field(LoggingRequestFilter.REQUEST_BODY, request.body()).log(logger -> logger.info("WebAdmin request received"));
        }
    }
}

