/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.Iterator;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.CapabilityResponse;

public class CapabilityResponseEncoder
implements ImapResponseEncoder<CapabilityResponse> {
    @Override
    public Class<CapabilityResponse> acceptableMessages() {
        return CapabilityResponse.class;
    }

    @Override
    public void encode(CapabilityResponse response, ImapResponseComposer composer) throws IOException {
        Iterator<Capability> capabilities = response.getCapabilities().iterator();
        composer.untagged();
        composer.message(ImapConstants.CAPABILITY_COMMAND.getNameAsBytes());
        while (capabilities.hasNext()) {
            composer.message(capabilities.next().asBytes());
        }
        composer.end();
    }
}

