/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.webadmin.dto.QuotaDomainDTO;
import org.apache.james.webadmin.dto.ValidatedQuotaDTO;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple4;

public class DomainQuotaService {
    private final MaxQuotaManager maxQuotaManager;

    @Inject
    public DomainQuotaService(MaxQuotaManager maxQuotaManager) {
        this.maxQuotaManager = maxQuotaManager;
    }

    public Optional<QuotaCountLimit> getMaxCountQuota(Domain domain) {
        return Mono.from((Publisher)this.maxQuotaManager.getDomainMaxMessageReactive(domain)).blockOptional();
    }

    public void setMaxCountQuota(Domain domain, QuotaCountLimit quotaCount) {
        Mono.from((Publisher)this.maxQuotaManager.setDomainMaxMessageReactive(domain, quotaCount)).block();
    }

    public void remoteMaxQuotaCount(Domain domain) {
        Mono.from((Publisher)this.maxQuotaManager.removeDomainMaxMessageReactive(domain)).block();
    }

    public Optional<QuotaSizeLimit> getMaxSizeQuota(Domain domain) {
        return Mono.from((Publisher)this.maxQuotaManager.getDomainMaxStorageReactive(domain)).blockOptional();
    }

    public void setMaxSizeQuota(Domain domain, QuotaSizeLimit quotaSize) {
        Mono.from((Publisher)this.maxQuotaManager.setDomainMaxStorageReactive(domain, quotaSize)).block();
    }

    public void remoteMaxQuotaSize(Domain domain) {
        Mono.from((Publisher)this.maxQuotaManager.removeDomainMaxStorageReactive(domain)).block();
    }

    public QuotaDomainDTO getQuota(Domain domain) {
        Mono getDomainMaxMessage = Mono.from((Publisher)this.maxQuotaManager.getDomainMaxMessageReactive(domain)).map(Optional::of).defaultIfEmpty(Optional.empty());
        Mono getDomainMaxStorage = Mono.from((Publisher)this.maxQuotaManager.getDomainMaxStorageReactive(domain)).map(Optional::of).defaultIfEmpty(Optional.empty());
        Mono getGlobalMaxMessage = Mono.from((Publisher)this.maxQuotaManager.getGlobalMaxMessageReactive()).map(Optional::of).defaultIfEmpty(Optional.empty());
        Mono getGlobalMaxStorage = Mono.from((Publisher)this.maxQuotaManager.getGlobalMaxStorageReactive()).map(Optional::of).defaultIfEmpty(Optional.empty());
        return (QuotaDomainDTO)Mono.zip((Mono)getDomainMaxMessage, (Mono)getDomainMaxStorage, (Mono)getGlobalMaxMessage, (Mono)getGlobalMaxStorage).map(tuple4 -> QuotaDomainDTO.builder().domain(ValidatedQuotaDTO.builder().count((Optional)tuple4.getT1()).size((Optional)tuple4.getT2())).global(ValidatedQuotaDTO.builder().count((Optional)tuple4.getT3()).size((Optional)tuple4.getT4())).computed(ValidatedQuotaDTO.builder().count(((Optional)tuple4.getT1()).or(() -> ((Tuple4)tuple4).getT3())).size(((Optional)tuple4.getT2()).or(() -> ((Tuple4)tuple4).getT4()))).build()).block();
    }

    public void defineQuota(Domain domain, ValidatedQuotaDTO quota) {
        this.defineDomainMaxMessage(domain, quota).then(this.defineDomainMaxStorage(domain, quota)).block();
    }

    private Mono<Void> defineDomainMaxStorage(Domain domain, ValidatedQuotaDTO quota) {
        return quota.getSize().map(sizeLimit -> Mono.from((Publisher)this.maxQuotaManager.setDomainMaxStorageReactive(domain, sizeLimit))).orElseGet(() -> Mono.from((Publisher)this.maxQuotaManager.removeDomainMaxStorageReactive(domain)));
    }

    private Mono<Void> defineDomainMaxMessage(Domain domain, ValidatedQuotaDTO quota) {
        return quota.getCount().map(countLimit -> Mono.from((Publisher)this.maxQuotaManager.setDomainMaxMessageReactive(domain, countLimit))).orElseGet(() -> Mono.from((Publisher)this.maxQuotaManager.removeDomainMaxMessageReactive(domain)));
    }
}

