/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.CommandHandler;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.eventsourcing.Subscriber;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.task.Hostname;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskNotFoundException;
import org.apache.james.task.TaskWithId;
import org.apache.james.task.WorkQueue;
import org.apache.james.task.eventsourcing.CancelCommandHandler;
import org.apache.james.task.eventsourcing.CancelRequested;
import org.apache.james.task.eventsourcing.CompleteCommandHandler;
import org.apache.james.task.eventsourcing.CreateCommandHandler;
import org.apache.james.task.eventsourcing.Created;
import org.apache.james.task.eventsourcing.FailCommandHandler;
import org.apache.james.task.eventsourcing.RequestCancelCommandHandler;
import org.apache.james.task.eventsourcing.StartCommandHandler;
import org.apache.james.task.eventsourcing.TaskAggregateId;
import org.apache.james.task.eventsourcing.TaskCommand;
import org.apache.james.task.eventsourcing.TaskEvent;
import org.apache.james.task.eventsourcing.TaskExecutionDetailsProjection;
import org.apache.james.task.eventsourcing.TerminationSubscriber;
import org.apache.james.task.eventsourcing.UpdateCommandHandler;
import org.apache.james.task.eventsourcing.WorkQueueSupplier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005c\u0001B\u0010!\u0001-B\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u0017\u0002\u0011)\u0019!C\u0001\u0019\"AA\u000b\u0001B\u0001B\u0003%Q\n\u0003\u0005V\u0001\t\u0015\r\u0011\"\u0001W\u0011!Q\u0006A!A!\u0002\u00139\u0006\u0002C.\u0001\u0005\u000b\u0007I\u0011\u0001/\t\u0011\u0001\u0004!\u0011!Q\u0001\nuC\u0001\"\u0019\u0001\u0003\u0006\u0004%\tA\u0019\u0005\tM\u0002\u0011\t\u0011)A\u0005G\"1q\r\u0001C\u0001A!D\u0011\"a\u0003\u0001\u0005\u0004%\t!!\u0004\t\u0011\u0005m\u0001\u0001)A\u0005\u0003\u001fAq!!\b\u0001\t\u0013\ty\u0002C\u0005\u0002*\u0001\u0011\r\u0011\"\u0003\u0002,!A\u00111\f\u0001!\u0002\u0013\ti\u0003C\u0005\u0002^\u0001\u0011\r\u0011\"\u0003\u0002`!A\u0011q\r\u0001!\u0002\u0013\t\t\u0007C\u0005\u0002j\u0001\u0011\r\u0011\"\u0003\u0002l!A\u00111\u000f\u0001!\u0002\u0013\ti\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005}\u0004\u0001\"\u0001\u0002x!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0005bBAJ\u0001\u0011\u0005\u0013Q\u0013\u0005\b\u0003C\u0003A\u0011BAR\u0011\u001d\tI\u000b\u0001C!\u0003WCq!!+\u0001\t\u0003\nI\fC\u0004\u0002N\u0002!I!a4\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002j\"9\u0011Q\u001e\u0001\u0005B\u0005=\bb\u0002B\u0019\u0001\u0011\u0005\u0013q\u000f\u0002\u0019\u000bZ,g\u000e^*pkJ\u001c\u0017N\\4UCN\\W*\u00198bO\u0016\u0014(BA\u0011#\u00035)g/\u001a8ug>,(oY5oO*\u00111\u0005J\u0001\u0005i\u0006\u001c8N\u0003\u0002&M\u0005)!.Y7fg*\u0011q\u0005K\u0001\u0007CB\f7\r[3\u000b\u0003%\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u00175qy\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\t1\fgn\u001a\u0006\u0002c\u0005!!.\u0019<b\u0013\t\u0019dF\u0001\u0004PE*,7\r\u001e\t\u0003kYj\u0011AI\u0005\u0003o\t\u00121\u0002V1tW6\u000bg.Y4feB\u0011\u0011\bP\u0007\u0002u)\u00111\bM\u0001\u0003S>L!!\u0010\u001e\u0003\u0013\rcwn]3bE2,\u0007CA E\u001b\u0005\u0001%BA!C\u0003\r\t\u0007/\u001b\u0006\u0003\u0007\u0012\n\u0011\u0002\\5gK\u000eL8\r\\3\n\u0005\u0015\u0003%!C*uCJ$\u0018M\u00197f\u0003E9xN]6Rk\u0016,XmU;qa2LWM\u001d\t\u0003\u0011&k\u0011\u0001I\u0005\u0003\u0015\u0002\u0012\u0011cV8sWF+X-^3TkB\u0004H.[3s\u0003))g/\u001a8u'R|'/Z\u000b\u0002\u001bB\u0011aJU\u0007\u0002\u001f*\u0011\u0001+U\u0001\u000bKZ,g\u000e^:u_J,'BA\u0011%\u0013\t\u0019vJ\u0001\u0006Fm\u0016tGo\u0015;pe\u0016\f1\"\u001a<f]R\u001cFo\u001c:fA\u0005QR\r_3dkRLwN\u001c#fi\u0006LGn\u001d)s_*,7\r^5p]V\tq\u000b\u0005\u0002I1&\u0011\u0011\f\t\u0002\u001f)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8EKR\f\u0017\u000e\\:Qe>TWm\u0019;j_:\f1$\u001a=fGV$\u0018n\u001c8EKR\f\u0017\u000e\\:Qe>TWm\u0019;j_:\u0004\u0013\u0001\u00035pgRt\u0017-\\3\u0016\u0003u\u0003\"!\u000e0\n\u0005}\u0013#\u0001\u0003%pgRt\u0017-\\3\u0002\u0013!|7\u000f\u001e8b[\u0016\u0004\u0013!\u0006;fe6Lg.\u0019;j_:\u001cVOY:de&\u0014WM]\u000b\u0002GB\u0011\u0001\nZ\u0005\u0003K\u0002\u0012Q\u0003V3s[&t\u0017\r^5p]N+(m]2sS\n,'/\u0001\fuKJl\u0017N\\1uS>t7+\u001e2tGJL'-\u001a:!\u0003\u0019a\u0014N\\5u}Q1\u0011N[6m[:\u0004\"\u0001\u0013\u0001\t\u000b\u0019S\u0001\u0019A$\t\u000b-S\u0001\u0019A'\t\u000bUS\u0001\u0019A,\t\u000bmS\u0001\u0019A/\t\u000b\u0005T\u0001\u0019A2)\u0005)\u0001\bCA9{\u001b\u0005\u0011(BA:u\u0003-\tgN\\8uCRLwN\\:\u000b\u0005U4\u0018AB2p[6|gN\u0003\u0002xq\u00061qm\\8hY\u0016T\u0011!_\u0001\u0004G>l\u0017BA>s\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgn\u001a\u0015\u0003\u0015u\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\ta!\u001b8kK\u000e$(BAA\u0003\u0003\u0015Q\u0017M^1y\u0013\r\tIa \u0002\u0007\u0013:TWm\u0019;\u0002\r1{uiR#S+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\u0002K\u0001\u0006g24GG[\u0005\u0005\u00033\t\u0019B\u0001\u0004M_\u001e<WM]\u0001\b\u0019>;u)\u0012*!\u000399xN]6ESN\u0004\u0018\r^2iKJ,\"!!\t\u0011\t\u0005\r\u0012QE\u0007\u0002#&\u0019\u0011qE)\u0003\u0015M+(m]2sS\n,'/A\u0006m_\u0006$\u0007*[:u_JLXCAA\u0017!!\ty#!\u000e\u0002:\u0005}RBAA\u0019\u0015\t\t\u0019$A\u0003tG\u0006d\u0017-\u0003\u0003\u00028\u0005E\"!\u0003$v]\u000e$\u0018n\u001c82!\u0011\t\u0019#a\u000f\n\u0007\u0005u\u0012KA\u0006BO\u001e\u0014XmZ1uK&#\u0007CBA!\u0003#\n)&\u0004\u0002\u0002D)!\u0011QIA$\u0003%\u0001XO\u00197jg\",'O\u0003\u0003\u00024\u0005%#\u0002BA&\u0003\u001b\nAaY8sK*\u0011\u0011qJ\u0001\be\u0016\f7\r^8s\u0013\u0011\t\u0019&a\u0011\u0003\u000bMkuN\\8\u0011\u00079\u000b9&C\u0002\u0002Z=\u0013q\u0001S5ti>\u0014\u00180\u0001\u0007m_\u0006$\u0007*[:u_JL\b%A\nfm\u0016tGoU8ve\u000eLgnZ*zgR,W.\u0006\u0002\u0002bA!\u00111EA2\u0013\r\t)'\u0015\u0002\u0014\u000bZ,g\u000e^*pkJ\u001c\u0017N\\4TsN$X-\\\u0001\u0015KZ,g\u000e^*pkJ\u001c\u0017N\\4TsN$X-\u001c\u0011\u0002\u0013]|'o[)vKV,WCAA7!\r)\u0014qN\u0005\u0004\u0003c\u0012#!C,pe.\fV/Z;f\u0003)9xN]6Rk\u0016,X\rI\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003s\u0002B!a\f\u0002|%!\u0011QPA\u0019\u0005\u0011)f.\u001b;\u0002\u000fI,7\u000f^1si\u000611/\u001e2nSR$B!!\"\u0002\fB\u0019Q'a\"\n\u0007\u0005%%E\u0001\u0004UCN\\\u0017\n\u001a\u0005\u0007GY\u0001\r!!$\u0011\u0007U\ny)C\u0002\u0002\u0012\n\u0012A\u0001V1tW\u0006\u0019r-\u001a;Fq\u0016\u001cW\u000f^5p]\u0012+G/Y5mgR!\u0011qSAO!\r)\u0014\u0011T\u0005\u0004\u00037\u0013#\u0001\u0006+bg.,\u00050Z2vi&|g\u000eR3uC&d7\u000fC\u0004\u0002 ^\u0001\r!!\"\u0002\u0005%$\u0017aG4fi\u0016CXmY;uS>tG)\u001a;bS2\u001c(+Z1di&4X\r\u0006\u0003\u0002&\u0006\u001d\u0006CBA!\u0003#\n9\nC\u0004\u0002 b\u0001\r!!\"\u0002\t1L7\u000f\u001e\u000b\u0003\u0003[\u0003b!a,\u00026\u0006]UBAAY\u0015\r\t\u0019\fM\u0001\u0005kRLG.\u0003\u0003\u00028\u0006E&\u0001\u0002'jgR$B!!,\u0002<\"9\u0011Q\u0018\u000eA\u0002\u0005}\u0016AB:uCR,8\u000f\u0005\u0003\u0002B\u0006\u001dgbA\u001b\u0002D&\u0019\u0011Q\u0019\u0012\u0002\u0017Q\u000b7o['b]\u0006<WM]\u0005\u0005\u0003\u0013\fYM\u0001\u0004Ti\u0006$Xo\u001d\u0006\u0004\u0003\u000b\u0014\u0013!\u00037jgR\u001c6-\u00197b+\t\t\t\u000e\u0005\u0004\u0002T\u0006\r\u0018q\u0013\b\u0005\u0003+\fyN\u0004\u0003\u0002X\u0006uWBAAm\u0015\r\tYNK\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005M\u0012\u0002BAq\u0003c\tq\u0001]1dW\u0006<W-\u0003\u0003\u00028\u0006\u0015(\u0002BAq\u0003c\taaY1oG\u0016dG\u0003BA=\u0003WDq!a(\u001d\u0001\u0004\t))A\u0003bo\u0006LG\u000f\u0006\u0004\u0002\u0018\u0006E\u00181\u001f\u0005\b\u0003?k\u0002\u0019AAC\u0011\u001d\t)0\ba\u0001\u0003o\fq\u0001^5nK>,H\u000f\u0005\u0003\u0002z\u0006}XBAA~\u0015\r\ti\u0010M\u0001\u0005i&lW-\u0003\u0003\u0003\u0002\u0005m(\u0001\u0003#ve\u0006$\u0018n\u001c8)\u000bu\u0011)Aa\t\u0011\r\u0005=\"q\u0001B\u0006\u0013\u0011\u0011I!!\r\u0003\rQD'o\\<t!\u0011\u0011iAa\b\u000f\t\t=\u00111\u0019\b\u0005\u0005#\u0011iB\u0004\u0003\u0003\u0014\tma\u0002\u0002B\u000b\u00053qA!a6\u0003\u0018%\t\u0011&\u0003\u0002(Q%\u0011QEJ\u0005\u0003G\u0011JAA!\t\u0002L\n9\"+Z1dQ\u0016$G+[7f_V$X\t_2faRLwN\\\u0012\u0003\u0005\u0017AS!\bB\u0014\u0005_\u0001b!a\f\u0003\b\t%\u0002cA\u001b\u0003,%\u0019!Q\u0006\u0012\u0003+Q\u000b7o\u001b(pi\u001a{WO\u001c3Fq\u000e,\u0007\u000f^5p]\u000e\u0012!\u0011F\u0001\u0006G2|7/\u001a\u0015\u0004=\tU\u0002\u0003\u0002B\u001c\u0005{i!A!\u000f\u000b\t\tm\u00121A\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B \u0005s\u0011!\u0002\u0015:f\t\u0016\u001cHO]8z\u0001")
public class EventSourcingTaskManager
implements TaskManager,
Closeable,
Startable {
    private final EventStore eventStore;
    private final TaskExecutionDetailsProjection executionDetailsProjection;
    private final Hostname hostname;
    private final TerminationSubscriber terminationSubscriber;
    private final Logger LOGGER;
    private final Function1<AggregateId, SMono<History>> loadHistory;
    private final EventSourcingSystem eventSourcingSystem;
    private final WorkQueue workQueue;

    public EventStore eventStore() {
        return this.eventStore;
    }

    public TaskExecutionDetailsProjection executionDetailsProjection() {
        return this.executionDetailsProjection;
    }

    public Hostname hostname() {
        return this.hostname;
    }

    public TerminationSubscriber terminationSubscriber() {
        return this.terminationSubscriber;
    }

    public Logger LOGGER() {
        return this.LOGGER;
    }

    private Subscriber workDispatcher() {
        return event -> {
            Event event2 = event.event();
            if (event2 instanceof Created) {
                Created created = (Created)event2;
                TaskAggregateId aggregateId = created.aggregateId();
                Task task = created.task();
                TaskWithId taskWithId = new TaskWithId(aggregateId.taskId(), task);
                this.workQueue().submit(taskWithId);
                return;
            }
            if (event2 instanceof CancelRequested) {
                CancelRequested cancelRequested = (CancelRequested)event2;
                TaskAggregateId aggregateId = cancelRequested.aggregateId();
                this.workQueue().cancel(aggregateId.taskId());
                return;
            }
        };
    }

    private Function1<AggregateId, SMono<History>> loadHistory() {
        return this.loadHistory;
    }

    private EventSourcingSystem eventSourcingSystem() {
        return this.eventSourcingSystem;
    }

    private WorkQueue workQueue() {
        return this.workQueue;
    }

    public void start() {
        this.workQueue().start();
    }

    public void restart() {
        this.workQueue().restart();
    }

    public TaskId submit(Task task) {
        TaskId taskId = TaskId.generateTaskId();
        TaskCommand.Create command = new TaskCommand.Create(taskId, task);
        SMono qual$1 = SMono$.MODULE$.apply(this.eventSourcingSystem().dispatch((Command)command));
        Duration x$1 = qual$1.block$default$1();
        qual$1.block(x$1);
        return taskId;
    }

    public TaskExecutionDetails getExecutionDetails(TaskId id) {
        return (TaskExecutionDetails)this.executionDetailsProjection().load(id).getOrElse((Function0 & Serializable)() -> {
            throw new TaskNotFoundException();
        });
    }

    private SMono<TaskExecutionDetails> getExecutionDetailsReactive(TaskId id) {
        return SMono$.MODULE$.apply(this.executionDetailsProjection().loadReactive(id)).switchIfEmpty(SMono$.MODULE$.error((Throwable)new TaskNotFoundException()));
    }

    public java.util.List<TaskExecutionDetails> list() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.listScala()).asJava();
    }

    public java.util.List<TaskExecutionDetails> list(TaskManager.Status status) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.listScala().filter((Function1 & Serializable)details -> BoxesRunTime.boxToBoolean((boolean)EventSourcingTaskManager.$anonfun$list$1(status, details)))).asJava();
    }

    private List<TaskExecutionDetails> listScala() {
        return this.executionDetailsProjection().list();
    }

    public void cancel(TaskId id) {
        TaskCommand.RequestCancel command = new TaskCommand.RequestCancel(id);
        SMono qual$1 = SMono$.MODULE$.apply(this.eventSourcingSystem().dispatch((Command)command));
        Duration x$1 = qual$1.block$default$1();
        qual$1.block(x$1);
    }

    public TaskExecutionDetails await(TaskId id, java.time.Duration timeout) throws TaskNotFoundException, TaskManager.ReachedTimeoutException {
        TaskExecutionDetails taskExecutionDetails;
        try {
            Mono details = Mono.from(this.getExecutionDetailsReactive(id)).filter(x$1 -> x$1.getStatus().isFinished());
            Mono findEvent = Flux.from(this.terminationSubscriber().listenEvents()).filter(x0$1 -> {
                Event event = x0$1;
                if (event instanceof TaskEvent) {
                    TaskEvent taskEvent = (TaskEvent)event;
                    TaskId taskId = taskEvent.getAggregateId().taskId();
                    TaskId taskId2 = id;
                    return !(taskId != null ? !taskId.equals(taskId2) : taskId2 != null);
                }
                return false;
            }).next().then(details);
            taskExecutionDetails = (TaskExecutionDetails)Flux.merge((Publisher[])new Publisher[]{findEvent, details}).blockFirst(timeout);
        }
        catch (IllegalStateException illegalStateException) {
            throw new TaskManager.ReachedTimeoutException();
        }
        return taskExecutionDetails;
    }

    @Override
    @PreDestroy
    public void close() {
        this.workQueue().close();
    }

    public static final /* synthetic */ boolean $anonfun$list$1(TaskManager.Status status$1, TaskExecutionDetails details) {
        TaskManager.Status status = details.getStatus();
        TaskManager.Status status2 = status$1;
        return !(status != null ? !status.equals(status2) : status2 != null);
    }

    @Inject
    @VisibleForTesting
    public EventSourcingTaskManager(WorkQueueSupplier workQueueSupplier, EventStore eventStore, TaskExecutionDetailsProjection executionDetailsProjection, Hostname hostname, TerminationSubscriber terminationSubscriber) {
        this.eventStore = eventStore;
        this.executionDetailsProjection = executionDetailsProjection;
        this.hostname = hostname;
        this.terminationSubscriber = terminationSubscriber;
        this.LOGGER = LoggerFactory.getLogger(EventSourcingTaskManager.class);
        this.loadHistory = (Function1 & Serializable)aggregateId -> SMono$.MODULE$.apply(this.eventStore().getEventsOfAggregate(aggregateId));
        this.eventSourcingSystem = new EventSourcingSystem((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CommandHandler[]{new CreateCommandHandler(this.loadHistory(), hostname), new StartCommandHandler(this.loadHistory(), hostname), new RequestCancelCommandHandler(this.loadHistory(), hostname), new CompleteCommandHandler(this.loadHistory()), new CancelCommandHandler(this.loadHistory()), new FailCommandHandler(this.loadHistory()), new UpdateCommandHandler(this.loadHistory())})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Subscriber[]{executionDetailsProjection.asSubscriber(hostname), this.workDispatcher(), terminationSubscriber})), eventStore);
        this.workQueue = workQueueSupplier.apply(this.eventSourcingSystem());
    }
}

